/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.tools.liquidcontainer;

import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.weather.rain.RainEffect;
import java.util.Random;
import java.util.Set;

public abstract class FillLiquidContainerRainEffect
implements RainEffect {
    private final boolean isForcedEmptyInInventory = true;
    private final double probabilityOfFilling = FillLiquidContainerRainEffect.probabilityFromHalfLife(20.0);

    public abstract Noun supplyRainWater(Simulation var1);

    @Override
    public void onRain(Noun target, double amount, Simulation simulation) {
        Frame frame = simulation.getCurrentFrame();
        if (InventoryState.isInAnInventory(target, frame)) {
            this.forceEmpty(target, simulation);
            return;
        }
        if (this.isFull(target, frame) || InventoryState.isInAnInventory(target, frame)) {
            return;
        }
        if (this.shouldFill(simulation.getRandom())) {
            Noun rainWater = this.supplyRainWater(simulation);
            PositionState.requestPut(rainWater, Prepositions.in, null, target, simulation);
        }
    }

    private boolean isFull(Noun target, Frame frame) {
        return !StructureState.getNonintegralChildren(target, frame).isEmpty();
    }

    private void forceEmpty(Noun target, Simulation simulation) {
        Set<Noun> contents = StructureState.getNonintegralChildren(target, simulation.getCurrentFrame());
        contents.forEach(noun -> PositionState.requestRemove(noun, simulation));
    }

    private boolean shouldFill(Random random) {
        return random.nextDouble() < this.probabilityOfFilling;
    }

    private static double probabilityFromHalfLife(double halflifeSeconds) {
        return 1.0 - Math.pow(0.5, 1.0 / halflifeSeconds);
    }
}

