/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.notification;

import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.notification.Notification;
import com.fabriziopolo.textcraft.states.notification.NotificationKey;
import com.fabriziopolo.textcraft.states.notification.NotificationState;
import java.util.HashMap;
import java.util.Map;

public class NotificationStateBuilder
extends NotificationState {
    public NotificationStateBuilder putTimedNotification(NotificationState.TimedNotification tn) {
        this.getOrCreateNotificationMap(tn.notification.player).put(tn.notification.key, tn);
        return this;
    }

    public NotificationStateBuilder putUnnotified(Notification notification) {
        this.requireMutable();
        this.putTimedNotification(NotificationState.TimedNotification.createUnnotified(notification));
        return this;
    }

    public NotificationStateBuilder putNotified(Notification notification) {
        this.requireMutable();
        this.putTimedNotification(NotificationState.TimedNotification.createNotified(notification));
        return this;
    }

    public NotificationStateBuilder putNotified(Notification notification, NotificationState.TimedNotification oldTimedNotification) {
        this.requireMutable();
        this.putTimedNotification(NotificationState.TimedNotification.createNotified(notification, oldTimedNotification));
        return this;
    }

    public NotificationStateBuilder putUpdated(Notification notification, NotificationState.TimedNotification oldTimedNotification) {
        this.requireMutable();
        this.putTimedNotification(NotificationState.TimedNotification.createUpdated(notification, oldTimedNotification));
        return this;
    }

    public NotificationStateBuilder rePut(Notification notification) {
        this.requireMutable();
        this.putTimedNotification(NotificationState.TimedNotification.createUpdated(notification, (NotificationState.TimedNotification)((Map)this.notifications.get(notification.player)).get(notification.key)));
        return this;
    }

    private Map<NotificationKey, NotificationState.TimedNotification> getOrCreateNotificationMap(Noun noun) {
        HashMap notificationMap = (HashMap)this.notifications.get(noun);
        if (notificationMap == null) {
            notificationMap = new HashMap();
            this.notifications.put(noun, notificationMap);
        }
        return notificationMap;
    }

    public NotificationState build() {
        this.setImmutable();
        return this;
    }
}

