/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.light;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.ValueProvider;
import com.fabriziopolo.textcraft.states.ValueProviderState;
import com.fabriziopolo.textcraft.states.light.LightStateBuilder;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.sun.SunState;
import com.fabriziopolo.textcraft.text.DebugInfoBuilder;
import java.util.Set;
import java.util.stream.Collectors;

public class LightState
extends ValueProviderState<Double, Noun> {
    private static final double DEFAULT_BRIGHTNESS = 0.0;

    protected LightState() {
        super(0.0);
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        DebugInfoBuilder builder = new DebugInfoBuilder(this.getStateKey());
        builder.addLine("lightProvider", this.get(noun));
        try {
            builder.addLine("light", this.get(noun) == null ? null : ((ValueProvider)this.get(noun)).get(noun, null, frame));
        }
        catch (Exception ex) {
            builder.addLine("light", "<FAILED TO GET VALUE>");
        }
        builder.addLine("brightnessAt", LightState.getBrightnessAt(noun, frame));
        return builder.toString();
    }

    @Override
    protected Class getStateKey() {
        return LightState.class;
    }

    @Override
    public State updateState(Simulation simulation) {
        LightStateBuilder newState = new LightStateBuilder();
        this.setUpdatedState(simulation, newState);
        return newState.build();
    }

    private double getBrightnessTowardNoun(Noun lightSource, Noun otherNoun, Frame frame) {
        return (Double)this.get(lightSource, otherNoun, frame);
    }

    public static double getBrightnessAt(Noun noun, Frame frame) {
        double sunIntensity = SunState.get(frame).getIntensityAt(noun, frame);
        LightState lightState = LightState.get(frame);
        PositionState positionState = PositionState.get(frame);
        Set<Noun> allObjectsInRoom = positionState.getDesendentsOf(positionState.getContainingRoom(noun));
        double generatedLightIntensity = allObjectsInRoom.stream().collect(Collectors.summingDouble(maybeLightSource -> lightState.getBrightnessTowardNoun((Noun)maybeLightSource, noun, frame)));
        double intensity = sunIntensity + generatedLightIntensity;
        return Math.min(Math.max(intensity, 0.0), 1.0);
    }

    public static LightState get(Frame frame) {
        return (LightState)frame.states.get(LightState.class);
    }

    public static LightStateBuilder builder() {
        return new LightStateBuilder();
    }

    public static void requestSetBrightness(Noun noun, ValueProvider<Double, Noun> brightnessProvider, Simulation simulation) {
        simulation.requestStateChange(LightState.class, new ValueProviderState.ChangeRequest(noun, brightnessProvider));
    }

    public static void requestSetBrightness(Noun noun, double brightness, Simulation simulation) {
        simulation.requestStateChange(LightState.class, new ValueProviderState.ChangeRequest(noun, brightness));
    }
}

