/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.AbstractCommand;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.text.TextMatcher;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GoPrepositionCommand
extends AbstractCommand {
    private static final List<String> GO_SYNONYMS = Arrays.asList("go", "g");

    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length == 0) {
            return null;
        }
        int idx = 0;
        List<Preposition> allPrepositions = Prepositions.getAllPrepositions();
        if (GO_SYNONYMS.contains(words[idx].toLowerCase())) {
            ++idx;
        }
        if (words.length <= idx) {
            return null;
        }
        String maybePreposition = words[idx].toLowerCase();
        List matches = allPrepositions.stream().filter(prep -> prep.toString().equals(maybePreposition.toString())).collect(Collectors.toList());
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1) {
            throw new IllegalStateException("MORE THAN ONE PREPOSITION WITH SAME STRING?!?!");
        }
        Preposition matchingPreposition = (Preposition)matches.get(0);
        if (words.length == ++idx) {
            return this.doGoWithoutNoun(matchingPreposition, context);
        }
        Frame frame = context.simulation.getCurrentFrame();
        List<Noun> perceivableNouns = context.player.getPerceivableNouns(frame);
        List<TextMatcher.ResultWithData<Noun>> results = GoPrepositionCommand.matchOne(words, idx, perceivableNouns, context.player, frame);
        if (results == null || results.isEmpty()) {
            return ActionsAndHints.hint("It looks like you're trying to go " + matchingPreposition + " something but I don't recognize what");
        }
        return new ActionsAndHints(results.stream().filter(tmReslt -> tmReslt.getEndIndex() == words.length).map(tmResult -> new Result((Noun)tmResult.data, matchingPreposition, context)).collect(Collectors.toList()));
    }

    @Override
    public String getHelpString() {
        return null;
    }

    @Override
    public String getNameString() {
        return "go";
    }

    @Override
    public String getPurposeString() {
        return null;
    }

    @Override
    public boolean isVisibleInHelp() {
        return false;
    }

    private ActionsAndHints doGoWithoutNoun(Preposition preposition, Command.Context context) {
        Preposition inversePrep = PositionState.get(context.simulation.getCurrentFrame()).getReversePreposition(context.player);
        if (!preposition.equals(inversePrep)) {
            return ActionsAndHints.hint("You cannot go " + preposition + " from here.  ");
        }
        return ActionsAndHints.action(new Result(null, preposition, context));
    }

    public static class Result
    implements UserAction {
        public final Noun noun;
        public final Preposition preposition;
        public final Command.Context context;

        public Result(Noun noun, Preposition preposition, Command.Context context) {
            this.noun = noun;
            this.preposition = Objects.requireNonNull(preposition);
            this.context = Objects.requireNonNull(context);
        }

        @Override
        public String getDescription() {
            if (this.noun == null) {
                return "to go " + this.preposition;
            }
            return "to go " + this.preposition + " " + NounPhraseWithArticle.the(this.noun.getContextFreeDescription());
        }

        @Override
        public void execute(TextAppController controller) {
            PositionState.requestGo(this.context.player, this.preposition, Prepositions.guessInverseOf(this.preposition), this.context.simulation, this.noun);
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }
}

