/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.app.menu;

import com.fabriziopolo.textapp.InteractiveTextUi;
import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.app.SinglePlayerGameState;
import com.fabriziopolo.textcraft.app.TextPrinter;
import com.fabriziopolo.textcraft.app.menu.NewGameMenuOptionAction;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.peristence.Campaign;
import com.fabriziopolo.textcraft.simulation.Frame;
import java.util.function.Supplier;

public final class NewCampaignMenuOptionAction
implements UserAction {
    private final Supplier<SinglePlayerGameState> gameStateSupplier;
    private final String description;

    public NewCampaignMenuOptionAction(Supplier<SinglePlayerGameState> gameStateSupplier) {
        this(gameStateSupplier, "New Campaign");
    }

    public NewCampaignMenuOptionAction(Supplier<SinglePlayerGameState> gameStateSupplier, String description) {
        this.gameStateSupplier = gameStateSupplier;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void execute(TextAppController controller) {
        TextPrinter txt = controller.getTxt();
        InteractiveTextUi ui = controller.getUi();
        txt.println("-- Enter a name for your campaign --");
        if (ui != null) {
            ui.requireInput(campaignName -> {
                txt.logInput((String)campaignName);
                txt.println();
                txt.println("Creating a new campaign...");
                Campaign campaign = controller.getPersistence().createCampaign((String)campaignName);
                new NewGameMenuOptionAction(campaign, this.gameStateSupplier).execute(controller);
            });
        }
    }

    @Override
    public boolean isValid(Frame frame) {
        return true;
    }
}

