module AR
  module Game

    class HiddenForest01 < Scene
      def initialize id=nil
        super 

        self.noun = "hidden forest glade"

        add_story_implement StoryImplement.new
      end


      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            if e.enterer == e.engine.world.player
              ret = "You enter a truly beautiful portion of the forest.  Soft, green turf softens your step."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "Rays of light shine through the canopy of trees above, and provide light to patches of grateful flowers on the forest floor."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end
      end
    end




  end
end
