module AR
  module Game

    class Bed < PhysicalObject
      def initialize id=nil
        super 
        add_behavior AR::Game::RestStation
        self.noun = "ornate bed"
        add_story_implement StoryImplement.new
      end

      class Story < AR::Game::StoryBehavior::Story
      end


      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The bed is made with a thick, soft looking comforter.  Just looking at it makes you want to take a nap."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "There is a wooden framed bed, with an ornate headboard in the corner of the home, next to a delicate nightstand."
            else 
              ret = ""
            end
            ret 
          end
          add_story story


        end
      end

    end

  end
end
