module AR
  module Game

    class OldManHouse < Scene
      def initialize id=nil
        super 
        self.noun = "cottage"
        #add_behavior AR::Game::SomeBehavior
        #
        bed = Bed.new "bed"
        add_inhabitant bed, "in the corner by a delicate nightstand"
        add_story_implement StoryImplement.new
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            if e.enterer == e.engine.world.player
              ret = "The old man's home fills you with comfort as you enter.  There's a sweet, herbal smell that greets you.  The wooden cabin-like feel of it is quite uplifting."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "On the eastern wall of the home, there is a kitchenette, on which there is a bubbling pot.  A small living quarters includes a bookshelf and two cloth chairs.  By the front door there is a workbench that sits in front of a small round window. It's littered with strange contraptions."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end
      end
    end



  end
end
