10 REM +---------------------------------------+
15 REM |'Green Falls'                          |
20 REM |By: Paul Panks                         |
25 REM |Public Domain 2006                     |
30 REM |* A 60 room, 30 object adventure game *|
35 REM +---------------------------------------+
40 REM Intialize variables, READ in data structures
45 DIM NO$(32),EX$(32),LO(32),DE$(70),AO$(30),BO$(30),M(60,6),VB$(22):VB$(21)="put"
46 A=0:C=0:CT=0:HP=380:I=0:L=10:LT=0:N=0:QS=0:SD=0:SI=0:V=0:X=0:Y=0:Z=0
50 FOR X=1 TO 30: READ NO$(X):NEXT X:AO$(24)="troll":AO$(25)="oracle"
51 FOR X=1 TO 30: READ EX$(X):NEXT X:BO$(24)="gomar":BO$(25)="time"
52 FOR X=1 TO 30: READ LO(X):NEXT X:AO$(29)="shadow":BO$(29)="demon"
53 FOR X=1 TO 60: READ DE$(X):NEXT X:AO$(30)="orb":BO$(30)="light"
54 FOR X=1 TO 60:FOR Y=1 TO 6: READ M(X,Y):NEXT Y,X:FOR X=1 TO 20: READ VB$(X):NEXT X
55 DATA "north","south","east","west","up","down"
56 DATA "lantern","oil","rope","backpack","key"
57 DATA "gardenspade","shield","helmet","armor"
58 DATA "gauntlets","ring","dagger","broadsword"
59 DATA "wolf","spirit","hellhound","villager"
60 DATA "Troll Gomar","Oracle of Time","blackwidow"
61 DATA "bard","priest","Shadow Demon","Orb of Light"
62 REM +--------------------------------------------+
63 DATA "North is a compass direction heading north."
64 DATA "South is a compass direction heading south."
65 DATA "East is a compass direction heading east."
66 DATA "West is a compass direction heading west."
67 DATA "Up is a compass direction heading up."
68 DATA "Down is a compass direction heading down."
69 DATA "This ghostly brass lantern is stained with blood. It is already lit (glowing brightly)."
70 DATA "This is oil used with the brass lantern. Should it ever go out, have this!"
71 DATA "A small coil of rope about 15' in length. It looks sturdy and well made."
72 DATA "A leather backpack. You can put things in it."
73 DATA "A large metal key with a skull. It appears to fit most any lock."
74 DATA "This is a large gardenspade. It can be used to tend a garden and much more."
75 DATA "A large, rusty shield. It has the emblem of an eagle on the front. It looks heavily dented."
76 DATA "A brass helmet from the Roman fields. It, too, is stained in blood and grossly battered."
77 DATA "A suit of interlinked platemail armor. The interior is made from leather, the shell metal."
78 DATA "A pair of mysterious-looking gauntlets. They feel magical to the touch!"
79 DATA "A magical ring of protection. It glows with a soft, pale blue light."
80 DATA "A jeweled double-edged dagger. Similar to the Roman gladius, but shorter."
81 DATA "A large broadsword with a ruby hilt. It hums softly in the darkness of the light fallen day."
82 DATA "This large, howling wolf looks up at you briefly from the cliff. He appears content on watching you."
83 DATA "This restless spirit wanders the tunnels of this cavern, never stopping to consider his plight!"
84 DATA "A large, menacing hellhound from the fiery pits of hell! Fire consumes him as he gazes into your very soul!"
85 DATA "A simple villager from the surrounding village. He smiles at you briefly before passing."
86 DATA "This is Troll Gomar, a wise troll from deep within the woodland. He bows to you slowly. 'Hello, my friend.' he says to you. You may 'talk' to him at any time."
87 DATA "This is the ancient Oracle of Time deep within the chasms of this world. He looks at you with a haunting emptiness as he sits from his perch inside a wayward keep. 'You have found the Oracle of Time.' he says to you. 'Time neither stops.'
88 DATA "This is a large blackwidow spider. It spins a tangled web, sticky to the touch. As it moves towards you, the drops of blood from its fangs fall warily close to your feet!"
89 DATA "A traveling bard from the surrounding countryside. He carries with him a rosewood harp."
90 DATA "A local priest from the church. He looks up at you from his altar. 'Welcome to my church,' he says to you. 'Care to stay awhile and rest?'"
91 DATA "As you step into the darkness of the crypt, a shiver runs up and down your spine! You have come to the Shadow Demon, an ancient evil so powerful that no one has come out of here alive to tell the tale! Dare you opose him?"
92 DATA "This is a magical orb of light, shining forth unto a darkened world. It is the light of the earth, and any man whom follows its path knows no darkness!"
93 REM +---------------------------------------------
94 DATA 99,99,99,99,99,99
95 DATA 4,999,10,12,13,17,999,60,44,4,22,999,39
96 DATA 11,43,28,6,22,39,52,27,8,53,39
97 REM ---------------------------------------------+
98 DATA "You are standing in a large tavern. Wood-rotted tables surround you, while a bar and staircase are visible up ahead. Although there is no bartender here, most of the local patrons can be seen drinking ale from around the dingy tavern.
99 DATA "You are standing at the bar inside the tavern. There isn't a bartender here at the moment, although you can still order from the 'menu' by leaving gold on the counter and serving yourself."
100 DATA "You are walking in a narrow hallway on the second floor of this tavern. Up ahead lies a small room, while a staircase leads downstairs to the main tavern below."
101 DATA "You are inside a small guest room. There isn't much here save for a few wooden barrels and a large bed."
102 DATA "You are walking along a cobblestone path near the entrance to the tavern (north). There are several buildings here, including a large shop visible to the east. Smoke rises from the chimney of the tavern ahead."
103 DATA "You are standing in front of a large, ornate fountain in the center of the village. It goes down some 50 feet below the surface, the walls of which are covered in a thick, green moss. It is icky to the touch. A church stands to the west.
104 DATA "You are standing inside a large church. Rows of pews adorn the room, while tall, stained glass windows rise high above. An altar stands to the north (occupied by a priest)."
105 DATA "You stand before a stone altar inside the church. A priest is here giving blessing to the few inside the church. It must be mass right about now, although you don't have a view of the sun to gauge the time of day. A door is east.
106 DATA "You are inside a small storage room within the church. Items pertaining to the priest and his clergy are often stored here. The only exit is back west."
107 DATA "You are standing at the entrance to a small village. A sign by the side of the road here reads: 'Welcome to Eldor.' A cobblestone path heads north into town past a picket fence, while a wider dirt path heads south into a well-lit forest."
108 DATA "You are walking on a dirt path. It heads north and south across the landscape here. A forest lies to the south, with trees towering high above you. There is a large oak tree to the southwest of here, but you cannot reach it from here.
109 DATA "You are inside a small room south of the hallway. It is dimly lit. There isn't much here save for a small bed and a dresser. It looks dirty, as if someone has not been here in years."
110 DATA "You are inside a room west of the main hallway. It is a very cramped room lacking any amenities whatsoever. There may be a few useful items inside, but judging from the dust around the room it hasn't been used for several years."
111 DATA "You are standing in a dark hallway inside the cottage. From here you can head east into a kitchen, while west and south of here lie unattended rooms. The entrance to the cottage is back north."
112 DATA "You are standing in a small kitchen within the cottage. There is a square wooden table in the center of the room, atop which rest some useful items. To the north of the kitchen is the outside patio, passed through under tall sheets.
113 DATA "You are standing before an old cottage within the village. The outer walls of the building appear charred, blackened with ash and smoke. An open doorway leads into a darkened hallway to the south, while a large fountain is west.
114 DATA "You are inside a darkened toolshed. Not much can be seen here, for there is very little light! You may need a small candle or lantern to light the contents of this room."
115 DATA "You are standing north of the patio in a small garden. A large tree -- too high to be climbed -- stands before you, its rotted bark and twisted branches a testament to the age of this abode. The main area of the garden is east of here."
116 DATA "You are standing on an open patio just north of a small cottage. Lush, green grass fills the courtyard of this patio, while the sounds of birds echo in the near distance. A large tree stands to the north in the center of a small garden."
117 DATA "You are standing in a small garden. Rows of beautiful flowers of all shapes, colors and sizes fill the area, while towering vines grow atop the enclosed walls of the courtyard. The only way back is west."
118 DATA "You are standing inside a large shop. Adventurers can come here to sell their wares and to purchase needed goods. Type 'buy <item>' to buy an item, 'sell <item>' to sell and 'list' to see what's presently in stock."
119 DATA "You are standing inside a small hut on the branch of a tree. Inside the hut are a table, a wooden bookshelf and a hammock (suspended from the ceiling). A small being looks up at you and smiles. 'Welcome, friend. What can I do for you?'"
120 DATA "You are standing on a branch atop the tree. A small, thatched roof hut stands on the center of the branch to the east (built into the tree). Looking inside, you can see a figure deep in prayer. Perhaps it would be wise not to disturb him.
121 DATA "You are standing before a tree with low-lying branches. Wooden steps -- nailed into the bark of the tree -- lead up into the shaded canopy of the forest."
122 DATA "You are walking in a well-lit forest just south of a large, dirt path. The road forks in four directions here: North, towards a path; East, towards a large, sloping valley; West, towards a tall tree; and South, taking you deeper still.
123 DATA "You are standing before a small pond within a lush, green meadow. The water is mossy green, and the pond appears dull and lifeless, as if someone has stolen the life right out of it!"
124 DATA "You are standing in a large, sloping green valley west of the forest. Clouds move on by endlessly in the near distance, as towering purple mountains frame a small lighthouse far to the east. A path slopes down here to the south."
125 DATA "You are deep within the forest. A long road branches out to the south from here, heading into a beautiful (but rocky) gorge towards the southeast."
126 DATA "You are walking along a long road sloping southward from a dense forest. The road steadily becomes more difficult to the east, as the climb steepens somewhat into a narrow cliff-face just beyond a large gorge."
127 DATA "You are facing a tall cliff atop a mile-long gorge snaking around the countryside to the northeast. The gorge continues for miles on end, although it might be better to be just go south where the path is easier to cross."
128 DATA "You are standing before a towering stone castle in the midst of a lush, green valley. The castle rises hundreds of feet into the air, as flags flap atop imposing ramparts covered in thick vines. A moat is here, with the drawbridge down."
129 DATA "You are standing inside the main hall of the castle. Tall gryphons beckon you inward, into an impressive parlor towards the north. You hear a faint laughter echo throughout the castle walls as you step closer inside!"
130 DATA "You are facing a long gorge about 250 feet down from a narrow cliff. Looking out, you can see a large waterfall cascading down to the east, while further a cave is visible near the bank of a raging river. The only way out is back up.
131 DATA "You are standing inside a dark cave within the waterfall. As water cascades down behind you, a cold, hallowing wind shivers your spine. Up ahead, a long tunnel heads into darkness in front of you, your lantern dancing upon the walls.
132 DATA "You stand before an impressive waterfall west of the gorge. It is quite a drop from the top of the cliff from which the waterfall emerges. Inside the waterfall you notice a small opening, similar to a cave. It may be possible to enter it.
133 DATA "You are walking inside a narrow tunnel inside a large cavern. South of here lies the main entrance, while north takes you deeper into the cave. An opening is visible here in the ceiling, where a small shaft leads into a chiseled room.
134 DATA "You are walking in a narrow tunnel inside the cave. There is very little light here! Up ahead lies a small intersection, leading into several small tunnels on either side."
135 DATA "You have reached a small opening inside the cave. A narrow shaft heads east here into a small room, carved out of the walls of this cavern. It looks abandoned, though well-maintained despite its age."
136 DATA "You are inside a small keep within the caves, chiseled out of the eastern most wall of this cavern. Small candles, ghostly-lit, strangely illuminate the darkness, while crude 'writing' is carved upon the wall to the east."
137 DATA "You are crawling on your belly inside the cave. A narrow tunnel heads east from here, heading into darkness ahead."
138 DATA "You are east of an intersection into the cave. The tunnel narrows somewhat up ahead to the north."
139 DATA "You are winding the corner of a small, narrow tunnel. The light dims from your lantern as you crawl slowly through the passageway. The tunnel stops abruptly to the east."
140 DATA "You have reached the end of a long tunnel inside the cave. The air is very damp here. The only exit is back west."
141 DATA "You are standing inside a massive parlor inside the castle. A tall chandelier hangs down from the ceiling, illuminating the room below. From the parlor you can head north into a lavish throne room (framed by majestic silk curtains).
142 DATA "You are standing before a tall, spiraling staircase which heads upstairs, presumedly to the top of the castle. It goes round and round for several hundred feet, the height truly dizzying!"
143 DATA "You are standing atop the castle on the western rampart. A large red flag with gryphons emblazoned on it flaps smoothly in a near silent breeze. A long walkway is here, extending from rampart to rampart. It is covered in lush vines.
144 DATA "You are walking along a stone walkway atop the castle. Vines grow along the walls, stretching downward for hundreds of feet. It may be possible to 'climb' the vines down to the castle entrance. To the east and west stand the ramparts.
145 DATA "You are standing atop the castle on the eastern rampart. A large flag, complete with gryphons on it, flaps in the breeze ahead. There is a walkway here which extends from rampart to rampart, the walls of which are covered in green vines.
146 DATA "You are standing before a tall, spiraling staircase which heads upstairs to the castle ramparts. It spirals upward several hundred feet. The castle parlor is east."
147 DATA "You are inside a dark dungeon just east of the throne room. It appears to head in a spiral fashion around the corner of a long crypt-like abode, the walls of which are covered in mold."
148 DATA "You are standing in an impressive looking throne room inside the castle. Silk curtains adorn either side of the throne, which itself is covered in gold and jewels. Inscribed on the throne are the letters: 'SARCA.' South is the parlor.
149 DATA "You are walking in a dark dungeon. Cobwebs line the walls here, and you can sense a presence in the nearby shadows! Whatever lives here isn't human, although plenty of THOSE bones litter the floor here, prey to a vengeful beast!"
150 DATA "You have reached the end of the dungeon. You are amazed by what you see here! A small circular object, softly glowing green, sits suspended in midair above the ground! You feel a cold, evil, foreboding presence here, almost overwhelming!
151 DATA "You are walking on the bank of a swiftly moving river, heading downstream. The river snakes around a small cliff to the northeast, stopping at a pair of wooden docks. To the west, a large waterfall cascades down a steep cliff."
152 DATA "You are wading knee deep in a fast moving river. Although crossing it does not appear to be too difficult, caution should be taken. The river continues east."
153 DATA "You are wading in a river. The pace of the water's movement increases steadily downstream towards the west. The river empties into a large body of water up ahead, next to a pair of wooden docks."
154 DATA "You have reached the docks, just south of a tall lighthouse. The lighthouse rises hundreds of feet into the air, providing a guiding light to incoming vessels. A river flows to the west."
155 DATA "You are standing before a large lighthouse near the docks. It is painted in two colors: red and white. The entrance to the light house is wide open."
156 DATA "You are climbing a spiraling staircase inside the lighthouse. It is just a bit further until you reach the top. Down from here lies the entrance to the lighthouse (the door is open)."
157 DATA "You have reached the top of the lighthouse. A large lantern is here, shining a brilliant beam of light onto the waters ahead. Looking out, you see a few vessels moving about, oblivious to your peering eyes. The only exit is back down."
158 REM +-------------------------------------------------------------------
159 REM  N,S,E,W,U,D
201 DATA 2,5,0,0,3,0
202 DATA 0,1,0,0,0,0
203 DATA 0,0,4,0,0,1
204 DATA 0,0,0,3,0,0
205 DATA 1,6,21,0,0,0
206 DATA 5,10,16,7,0,0
207 DATA 8,0,6,0,0,0
208 DATA 0,7,9,0,0,0
209 DATA 0,0,0,8,0,0
210 DATA 6,11,0,0,0,0
211 DATA 10,25,0,0,0,0
212 DATA 14,0,0,0,0,0
213 DATA 0,0,14,0,0,0
214 DATA 16,12,15,13,0,0
215 DATA 19,0,0,14,0,0
216 DATA 0,14,0,6,0,0
217 DATA 0,0,19,0,0,0
218 DATA 0,19,20,0,0,0
219 DATA 18,15,0,17,0,0
220 DATA 0,0,0,18,0,0
221 DATA 0,0,0,5,0,0
222 DATA 0,0,0,23,0,0
223 DATA 0,0,22,0,0,24
224 DATA 0,0,25,0,23,0
225 DATA 11,28,27,24,0,0
226 DATA 0,27,0,0,0,0
227 DATA 26,30,0,25,0,0
228 DATA 25,29,0,0,0,0
229 DATA 28,0,30,0,0,0
230 DATA 27,33,31,29,0,0
231 DATA 0,0,32,30,0,0
232 DATA 44,0,0,31,0,0
233 DATA 30,0,35,0,0,0
234 DATA 36,35,0,0,0,0
235 DATA 34,0,54,33,0,0
236 DATA 37,34,0,0,38,0
237 DATA 40,36,0,0,0,0
238 DATA 0,0,39,0,0,36
239 DATA 0,0,0,38,0,0
240 DATA 0,37,41,0,0,0
241 DATA 42,0,0,40,0,0
242 DATA 0,41,43,0,0,0
243 DATA 0,0,0,42,0,0
244 DATA 51,32,45,49,0,0
245 DATA 0,0,0,44,46,0
246 DATA 0,0,0,47,0,45
247 DATA 0,0,46,48,0,0
248 DATA 0,0,47,0,0,49
249 DATA 0,0,44,0,48,0
250 DATA 0,52,51,0,0,0
251 DATA 0,44,0,50,0,0
252 DATA 50,0,53,0,0,0
253 DATA 0,0,0,52,0,0
254 DATA 55,0,0,35,0,0
255 DATA 0,54,56,0,0,0
256 DATA 0,0,57,55,0,0
257 DATA 58,0,0,56,0,0
258 DATA 0,57,0,0,59,0
259 DATA 0,0,0,0,60,58
260 DATA 0,0,0,0,0,59
261 REM +-----------------------
262 DATA "go","get","drop","wield","unwield","wear","remove","use","light","examine","read"
263 DATA "buy","sell","list","menu","talk","talk to","fight","kill","attack"
264 REM finalize initialization
265 DIM P(30):P(1)=10000:P(2)=10000:P(3)=10000:P(4)=10000:P(5)=10000:P(6)=10000
266 P(7)=30:P(8)=14:P(9)=36:P(10)=42:P(11)=6:P(12)=150:P(13)=328:P(14)=480:G=200
267 P(15)=890:P(16)=400:P(17)=1200:P(18)=200:P(19)=5000:for X=20 to 29:P(X)=10000:NEXT X:P(30)=6000
275 REM Display opening marquee
276 COLOR 10,0:CLS:?"'Green Falls'":?"(C)opyright 2006 by Paul Panks (writing as Dunric)":?"Written for the 12th annual interactive fiction contest.":?
277 ?"INSTRUCTIONS":?:?"Long ago, the land of Eldor had a life force (Chi) which":?"flowed smoothly across the world. But now, thanks to a nefarious"
278 ?"evil, known as the Shadow Demon, a lurking, all-powerful":?"force has sucked the life out of the land.":?
279 ?"Armed with only a dagger and your wits, you must venture deep within Eldor":?"to uncover the truth about the evil permeating the landscape. Along"
280 ?"the way, you will battle the evil spawn of the Shadow":?"Demon, sucked up from the bowels of hell itself!":?:?"Dare you conquer the Shadow Demon?":?
281 ?"(Ok, stop laughing...I wasn't drunk when I wrote this adventure!) :)":?
282 ?"~~~@@@ PRESS ANY KEY TO BEGIN PLAYING @@@~~~"
283 a$=inkey$:if a$="" then goto 283
284 CLS:?"NEW CHARACTER OR SAVED GAME?":?:?"Are you playing a saved game (y/n)? ";
285 a$=inkey$:if a$="" then goto 285
286 if a$="y" or a$="Y" or a$="yes" or a$="Yes" then ? a$:?:goto 290
287 if a$="n" or a$="N" or a$="no" or a$="No" then ? a$:?:goto 300
288 goto 285
289 rem load saved game
290 open"game.sav" for input as #1
291 input #1,A:input #1,C:input #1,CT:input #1,H:input #1,HP:input #1,I:input #1,L:input #1,LT:input #1,N
292 input #1,QS:input #1,SI:input #1,V:input #1,X:input #1,Y:input #1,Z:input #1,ac:input #1,WD:input #1,ap:input #1,G:input #1,E
293 for X=1 to 30:input #1,LO(X):NEXT X
294 close #1:goto 301
299 rem start new game
300 L=10
301 if LT=0 THEN if L>21 then ?"It's too dark to see anything!":goto 303:else if LO(29)=998 then goto 950: REM player wins game
302 gosub 995
303 print"Obvious exits: < ";:if M(L,1)>0 then ?"North ";
304 if M(L,2)>0 then ?"South ";
305 if M(L,3)>0 then ?"East ";
306 if M(L,4)>0 then ?"West ";
307 if M(L,5)>0 then ?"Up ";
308 if M(L,6)>0 then ?"Down ";
309 ?">":for X=7 to 30:if LO(X)=L then ? "There is a(n) ";NO$(X);" here."
310 NEXT X:if LT=2 then ?"(A brilliant light shoots throughout the room)"
320 n$="":v$="":v2$="":n2$="":v=0:n=0:a=0:pt=0:nm=0:dt$="":print:line input">",a$
IF LT=1 THEN
LO=LO+1:IF LO=25 THEN LO=0:LT=0:?"The lantern fizzles into darkness..."
END IF
328 pt=1: nm=0:dt$=a$:FOR a=1 TO LEN(dt$)
331 IF MID$(dt$,a,1)=" " THEN a$=MID$(dt$,pt,a-pt):pt=a+1:nm=nm+1:wd$(nm)=LCASE$(a$)
332 NEXT:nm=nm+1:a$=MID$(dt$,pt,a-pt):wd$(nm)=LCASE$(a$):a$=dt$:m(3,2)=1
333 n$=wd$(2):n2$=wd$(5):v$=wd$(1):v2$=wd$(4):if LO(29)=998 or SD=1 then goto 950: rem player wins game
334 if wd$(1)="talk" and wd$(2)="to" then wd$(2)=wd$(3):n$=wd$(2):wd$(3)=""
335 if v$="i" or v$="inventory" or v$="inv" or v$="invent" or v$="in" then goto 700
336 if v$="quit" or v$="bye" or v$="exit" or v$="goodbye" or v$="good bye" or v$="q" then goto 850
337 if v$="go" or v$="n" or v$="north" or v$="s" or v$="south" or v$="east" or v$="e" or v$="w" or v$="west" or v$="u" or v$="up" or v$="d" or v$="down" then goto 350
338 if v$="look" or v$="l" or v$="lk" then goto 301:else if a$="list" then goto 520
339 if v$="save" or v$="save game" then goto 800:else if a$="menu" then goto 530
340 if v$="help" or v$="hint" or v$="mercy" then goto 650:else if a$="score" then goto 750
341 SI=0:V=0:for X=1 to 21:if VB$(X)=v$ then V=X:X=22:SI=1
342 NEXT
343 SI=0:N=0:for X=1 to 30:if NO$(X)=n$ or n$=AO$(X) or n$=BO$(X) then N=X:X=32:SI=1
344 NEXT:IF SI=0 and V<>10 then print"I don't understand the noun '"n$"'.":goto 320
345 ON V GOTO 350,360,370,380,390,400,410,420,420,430,430,500,510,520,530,540,540,600,600,600,980
346 ?"I don't understand the word '";v$;"'.":GOTO 320
349 rem go
350 gosub 960:if N=3 then if LO(26)=L then ?"The blackwidow blocks your path!":?"It twitches and snaps at you, blood dripping from its fangs!":goto 320
351 if N=2 then if LO(22)=L then ?"The hellhound stops you!":?"It growls,'Care to visit another realm?! Like HELL!!!!!":?">>>>>>>>>>>>>>>>>>>> F-I-R-E-B-A-L-L":?"You are burnt to a crisp!":?"You died.":SLEEP 4:RUN
352 if N=1 then if LO(21)=L then ?"The spirit halts your progress!":?"'NOOOOOoooooooo one goes this WAAAAAaaaaayyyyy!' it bellows.":goto 320
353 if N=5 then if LO(9)<>0 and L=36 then ?"You need a rope to climb up the shaft.":goto 320
354 if N=6 then if L=47 then ?"You climb down the vines...":L=31:goto 301
355 if N=3 then if L=8 then if LO(11)<>0 then ?"The locked door prevents you from passing east.":?"You need a key to open the door (type 'use key' to open it).":goto 320
357 if M(L,N)>0 THEN L=M(L,N):goto 301
358 ?"You can't go that way."
359 rem get
360 if LO(N)=L or LO(N)=305 then if N=30 or N<20 and N>6 then if CT<8 then ?"Ok.":LO(N)=0:goto 320
361 if CT>=8 then ?"Too heavy!":goto 320
362 ?"It's beyond your power to do that!":goto 320
369 rem drop
370 if LO(N)=0 then LO(N)=L:?"Ok.":LO(N)=L:CT=CT-1:goto 320
371 ?"You can't drop that here.":goto 320
379 rem wield
380 if LO(N)=0 then if N=12 then IF WD<>1 then LO(N)=105:?"Ok.":WD=1:goto 320
381 if LO(N)=0 then if N=18 then IF WD<>1 then LO(N)=105:?"Ok.":WD=1:goto 320
382 if LO(N)=0 then if N=19 then IF WD<>1 then LO(N)=105:?"Ok.":WD=1:goto 320
383 if WD=1 then ?"You are wielding something already!":goto 320
384 ?"That cannot be wielded.":goto 320
389 rem unwield
390 if LO(N)=105 then if N=12 then LO(N)=0:?"Ok.":WD=0:goto 320
391 if LO(N)=105 then if N=18 then LO(N)=0:?"Ok.":WD=0:goto 320
392 if LO(N)=105 then if N=19 then LO(N)=0:?"Ok.":WD=0:goto 320
394 ?"That cannot be unwielded.":goto 320
399 rem wear
400 if LO(N)=0 then if N=13 or N=14 or N=15 or N=16 or N=17 then LO(N)=205:ac=ac+N:?"Ok.":goto 320
401 ?"That cannot be worn.":goto 320
409 rem remove
410 if LO(N)=205 then if N=13 or N=14 or N=15 or N=16 or N=17 then LO(N)=0:ac=ac-N:?"Ok.":goto 320
411 ?"That cannot be removed.":goto 320
419 rem use/light
420 if LO(N)<>0 and LO(N)<>rm then ?"You can't use that here!":goto 320
421 if L=36 then if N=9 then L=38:?"You climb the rope to reach the shaft...":goto 301
422 if N=7 then if LO(8)=0 then LT=1:?"Fzzzzt! The lantern flickers on!":goto 320
423 if N=7 then ?"You need the oil first to use the lantern.":goto 320
424 if N=11 then if L=8 then L=9:?"Click! The door unlocks and you pass on through...":goto 301
425 if N=30 then LT=2:?"Fzzzzzzzzzzzzzzzzzzt!":?"A brilliant light shoots from the orb!":?"The darkness fades and eternal light falls upon the land!":goto 320
426 if N=10 then ?"Use the 'put' verb instead.":goto 320
427 ?"That cannot be used.":goto 320
429 rem examine/read
430 if N=0 or LO(N)<>L AND LO(N)<>0 AND LO(N)<>105 and LO(N)<>205 then goto 433
431 ? EX$(N):IF N=10 then goto 433
432 goto 320
433 IF N=10 then ?"The backpack contains:":gosub 990:goto 320
434 :
498 ?"You notice nothing unusual about it.":goto 320
499 rem buy
500 if L<>21 then ?"You are not in the village shop!":goto 320
501 if LO(N)=999 then if G<P(N) then ?"You do not have enough money to purchase the ";NO$(N);".":goto 320
502 if LO(N)=999 then if CT<8 then G=G-P(N):LO(N)=0:CT=CT+1:?"You purchase the ";NO$(N);", worth";P(N);"gold coins.":goto 320
503 if LO(N)<>999 then ?"That isn't in stock at the moment. Type 'list' for current items.":goto 320
504 IF CT>=8 then ?"You can't carry that. Transaction aborted.":goto 320
505 ?"What you expected didn't happen.":goto 320
509 rem sell
510 if L<>21 then ?"You are not in the village shop!":goto 320
511 if LO(N)=0 then F=P(N)/2:G=G+F:LO(N)=999:CT=CT-1:?"You sell the ";NO$(N);", worth";F;"gold coins.":goto 320
512 ?"What you expected didn't happen.":goto 320
519 rem list
520 if L<>21 then ?"You are not in the village shop!":goto 320
521 ?"Here is what the shop currently has in stock:"
522 SI=0:for X=7 to 30:if LO(X)=999 then SI=1:?" ";P(X);": ";NO$(X);"."
523 NEXT X:if SI=0 then ?"Alas, the shop has nothing in stock at the moment.":?"Perhaps you should 'sell' something to it?":goto 320
524 ?"Your gold:";G:goto 320
529 rem menu
530 if L<>2 then ?"You are not in the tavern!":goto 320
531 ?"Here is what we have on tap:":?"(1) Drunk's Delight: Heals 25 hp, costs 15 gold.":?"(2) Wizard's Potion: Heals 75 hp, costs 30 gold"
532 ?"(3) Veteran's Vodka: Heals 125 hp, costs 75 gold":?"Your gold:";G:?"Enter your selection (1-3), or type '0' for no sale: ";
533 a$=inkey$:if a$="" then goto 533
534 if a$="1" then ? a$:if G>=15 then G=G-15:?"You purchase the Drunk's Delight and consume it with gusto.":?"You feel much better!":hp=hp+15:goto 320
535 if a$="1" then ? a$:?"You don't have enough money.":goto 320
536 if a$="2" then ? a$:if G>=30 then G=G-30:?"You purchase the Wizard's Potion and consume it quickly.":?"You feel amazing!":hp=hp+30:goto 320
537 if a$="2" then ? a$:?"You don't have enough money.":goto 320
538 goto 590
539 rem talk/talk to
540 IF N<20 then ?"Don't be silly!":goto 320
541 if LO(N)<>L then ?"There is no response but the empty echo of your own voice.":goto 320
542 if N=20 then ?"The wolf howls at you!":?"It does not appear to understand the human tongue.":goto 320
543 if N=21 then ?"The spirit does not respond to you.":goto 320
544 if N=22 then ?"The hellhound growls at you! He says,'What are you trying to say, KNAVE?!!!'":?"'Leave these woods at once, or I will send YOU to hell!'":goto 320
545 if N=23 then ?"The village smiles at you.":?"He says,'Hello there! Welcome to Eldor!'":goto 320
546 if N=24 then ?"Troll Gomar looks at you.":?"He bows to you and says,'Long ago, many eons ago, this forest was alive":?"with the power of Chi. Everything worked in harmony.'":?"'But He has stolen this prosperity and we suffer for it!'":goto 320
547 if N=25 then ?"The Oracle of Time says,'What do you want to know about time?'":?"'What is time?' you ask.":?"The Oracle replies,'Time has no beginning and no end. It is forever moving, but it also never stops!'":goto 320
548 if N=26 then ?"The blackwidow twitches at your words!":?"'Leave me be!' it hisses in loud voice.":goto 320
549 if N=27 then ?"The bard bows. He says,'I am but a wandering bard of the forest. I play music to make the land happy, but lo, it is not happy! I wonder when it will become happy once more?'":goto 320
550 if N=28 then ?"The priest smiles. 'Welcome to the house of the LORD! God is almighty here, and you can find him for but a gold piece or two!'":goto 320
551 if N=29 then ?"The Shadow Demon laughs at you!":?"'Fool!' he cackles. 'You are unwelcome here! But...if you insist on staying...DIIIIIEEEEEE, FIEND!'":goto 320
552 ?"There is no response but the empty echo of your own voice.":goto 320
589 rem rest of menu
590 if a$="3" then ? a$:if G>=75 then G=G-75:?"You purchase the Veteran's Vodka. A FIREBALL erupts in your head!":?"VVVvvvvrrroooommmmmm!":?"You feel SO much better now!":hp=hp+125:goto 320
591 if a$="3" then ? a$:?"You don't have enough money.":goto 320
592 if a$="0" then ? a$:?"No sale. Transaction aborted.":goto 320
593 goto 533
599 rem fight/kill/attack
600 ?"Your HP:";HP:if ac=0 then ac=2
601 IF N<20 and N<>30 then ?"You cannot kill something that isn't":?"alive.":goto 320
602 if N=20 then mh=120
603 if N=21 then mh=210
604 if N=22 then mh=250
605 if N=23 then mh=80
606 if N=24 then mh=500
607 if N=25 then mh=600
608 if N=26 then mh=400
609 if N=27 then mh=180
610 if N=28 then mh=50
611 if N=29 then mh=800
612 if LO(12)=105 then ?"You are wielding the gardenspade.":DM=6
613 if LO(18)=105 then ?"You are wielding the dagger.":DM=4
614 if LO(19)=105 then ?"You are wielding the broadsword.":DM=18
615 if WD=0 then ?"You fight with your bare hands.":DM=2
616 ?"(Damage potential:";DM;"% of a full hit)":?
617 ?"You attack:":IF N=29 then SD=1
622 RANDOMIZE TIMER:i=int(rnd*32)+1:?">":if i<5 then ?"You missed ";NO$(N);"."
623 if i>=5 and i<=10 then ?"You hit ";NO$(N);".":mh=mh-DM
624 if i>=11 and i<=14 then ?"You hit ";NO$(N);" very hard.":F=DM*4:mh=mh-F
625 if i>=15 and i<=18 then ?"You smashed ";NO$(N);" with a bone-crushing sound.":F=DM*6:mh=mh-F
626 if i>=19 and i<=21 then ?"You massacred ";NO$(N);" into small fragments.":F=DM*8:mh=mh-F
627 if i=22 or i=23 then if DM=18 then ?"Your BROADSWORD glows!":?"A bolt of lightning streaks down and hits ";NO$(N);"!":F=DM*20:mh=mh-F
628 if i>23 then ?"The ";NO$(N);" dodged your attack."
629 ?">":?"Your HP:";HP:?"The ";NO$(N);"'s:";mh:SLEEP .333
630 RANDOMIZE TIMER:c=int(rnd*40)+1:if c<5 then ?"The ";NO$(N);" missed you."
631 if c>=5 and c<=10 then ?"The ";NO$(N);" hit you.":HP=HP-c
632 if c>=11 and c<=14 then ?"The ";NO$(N);" hit you very hard.":F=c*3:HP=HP-F
633 if c>=15 and c<=19 then ?"The ";NO$(N);" smashed you with a bone-crushing sound.":F=c*4:HP=HP-F
634 if c>=20 and c<=22 then ?"The ";NO$(N);" massacred you in to small fragments.":F=c*6:HP=HP-F
635 if N=26 then if c=23 or c=24 then ?"The BLACKWIDOW bites you!":?"You feel weaker!":F=c*8:HP=HP-F
636 if N=22 then if c=23 or c=24 then ?"The HELLHOUND breathes fires on you!":?">>>>>>>>>>>>>>>>>>>> F-I-R-E-B-A-L-L":?"You are burnt to a crisp!":F=c*12:HP=HP-F
637 if N=29 then if c=23 or c=24 then ?"The SHADOW DEMON shoots lightning bolts at you!":?">>>>>>>>>>>>>>>>>>>>>>>>> L-I-G-H-T-N-I-N-G":?"You are atomized into nothingness!":F=c*18:HP=HP-F
638 if N=29 then if c=25 or c=26 then ?"The SHADOW DEMON incants his staff!":?"A ghostly arm snatches life-blood from your very veins into his!":?"'HA HA HA HA!' he laughs.":F=c*6:mh=mh+F:HP=HP-F
639 if c>=27 then ?"You dodged the attack."
640 if mh<0 then mh=0:else if c>=15 then F=ac/i:F=CINT(F):HP=HP+F:?"Your armor absorbed some of the blow."
641 if HP<0 then HP=0
642 if mh=0 then ?"The ";NO$(N);" died.":?"You killed ";NO$(N);".":goto 900
643 if HP=0 then ?"You died.":?"You are now a ghost.":SLEEP 2:?"@@@ GAME OVER @@@":SLEEP 2:RUN
644 SLEEP 1.8:goto 612
650 rem help
651 ?"HELP COMMAND":?:?"This is a traditional text adventure in the Scott Adams mold, with some":?"MUD-like and AD&D-inspired elements. You type in one or two word commands"
652 ?"such as 'GO NORTH' and 'GET SWORD' to instruct your character what to":?"do. The parser also accepts one word commands and abbreviations, such"
653 ?"as 'I' for 'INVENTORY' and 'N' for 'NORTH'. At any time you can":?"type 'HELP' at the game prompt to see what commands are available.":?:gosub 999
654 ?:?"COMMANDS AVAILABLE":?:?"Here are the present commands available. Remember, in some instances":?"you can also use abbreviations:":?
655 gosub 1000:?"(Some commands may not be implemented)":?:?"If you need further help, you can email me at: lumberjacks76@lycos.com":goto 320
700 rem inventory
701 SI=0:CT=0:WD=0:ac=0:for x=7 to 30:if LO(X)=0 then SI=1:CT=CT+1:? " ";NO$(X)
702 if LO(X)=105 then WD=1:SI=1:CT=CT+1:? " ";NO$(X);" (wielded)"
703 if LO(X)=205 then ac=ac+X:SI=1:CT=CT+1:? " ";NO$(X);" (worn)"
704 NEXT X:if SI=1 then ?"You are carrying";CT;"item(s)."
705 ap=ac*2:if ac>0 then ?"Your armor is protecting";ap;"% of your body."
706 F=G*3:?"You carry with you";G;"gold pieces worth";F;"Denari."
707 if SI=0 then ?"Alas, you are empty-handed."
708 goto 320
750 rem score
751 ap=ac*2:?"You have earned";E;"experience points.":?"You have";HP;"hit points and";G;"gold coins.":?"You are carrying";CT;"items and your armor":?"is protecting";ap;"% of your body."
752 ?"Type 'INVENTORY' to see a list of items presently carried.":goto 320
800 rem save game
810 open"game.sav" for output as #1
811 print #1,A:print #1,C:print #1,CT:print #1,H:print #1,HP:print #1,I:print #1,L:print #1,LT:print #1,N
812 print #1,QS:print #1,SI:print #1,V:print #1,X:print #1,Y:print #1,Z:print #1,ac:print #1,WD:print #1,ap:print #1,G:print #1,E
813 for X=1 to 30:print #1,LO(X):NEXT X
814 close #1:?"Game saved as file 'GAME.SAV'.":goto 320
849 rem quit
850 ?"Thanks for playing!":?:?"You finished with";CT;"items carried,";HP;"hit points and";G;"gold coins.":?:?"@@@ Press any key to quit program @@@"
851 a$=inkey$:if a$="" then goto 851
852 END
900 ?"You gained";c;"gold coins and";i;"experience points.":E=E+i:G=G+c:F=CINT(HP*1.2):HP=HP+F:GOSUB 970:if i>15 then ?"You gained a level!":F=CINT(HP*1.8):HP=HP+F:GOSUB 970
901 LO(N)=998:mh=0:goto 320
949 rem win game
950 print "The crumbled body of the SHADOW DEMON lay at your field, bathed":?"in blood. No more will the evil of this creature haunt the"
951 ?"people of Eldor. As the sun rises on a new day,":?"you lay your sword at your feet, tired of the bloodshed."
952 ?"Taking one long, last look, you turn and walk away for good.":?"For you are the savior of Eldor, and now they need a king!":?:?"@@@ THE END @@@"
953 a$=inkey$:if a$="" then goto 953
954 END
959 rem abbreviations for movement
960 if a$="n" or a$="north" or a$="go north" then N=1
961 if a$="s" or a$="south" or a$="go south" then N=2
962 if a$="e" or a$="east" or a$="go east" then N=3
963 if a$="w" or a$="west" or a$="go west" then N=4
964 if a$="u" or a$="up" or a$="go up" then N=5
965 if a$="d" or a$="down" or a$="go down" then N=6
966 return
969 rem cap HP
970 if HP>=1000 THEN HP=1000
971 return
979 rem use
980 if LO(10)<>0 and LO(10)<>L then ?"The backpack isn't here. You must use the backpack.":goto 320
981 if LO(N)<>0 and LO(N)<>L then ?"That isn't here to place inside.":goto 320
982 if N>19 and N<>30 or N<7 then ?"Don't be silly!":goto 320
983 LO(N)=305:CT=CT-1:?"Ok.":goto 320
989 rem check for backpack
990 SI=0:for x=7 to 30:if LO(X)=305 then ?" ";NO$(X);".":SI=1
991 NEXT:IF SI=0 then ?"Nothing!"
992 return
994 rem wordwrap by Borg953
995 c = 1:text$=DE$(L)
DO
buffer$ = ""
DO
xbuffer$ = MID$(text$, c, 1)
IF LEN(xbuffer$) > 0 THEN z = ASC(xbuffer$) ELSE z = 0
IF z >= 32 THEN buffer$ = buffer$ + xbuffer$
c = c + 1
LOOP UNTIL RIGHT$(buffer$, 1) = " " OR RIGHT$(buffer$, 1) = CHR$(13) OR c = LEN(text$) + 1
col = POS(0)
IF LEN(buffer$) < 80 - col THEN
PRINT buffer$;
ELSEIF LEN(buffer$) >= 80 - col AND INSTR(buffer$, "-") <> 0 THEN
d = 0
DO
d = d + 1
xxbuffer$ = MID$(buffer$, d, 1)
PRINT xxbuffer$;
LOOP UNTIL xxbuffer$ = "-"
PRINT
PRINT RIGHT$(buffer$, LEN(buffer$) - d);
ELSE
PRINT
PRINT buffer$;
END IF
LOOP UNTIL c = LEN(text$) + 1
PRINT
return
999 ?"@@@ Press any key to continue @@@"
waiter:
a$=inkey$:if a$="" then goto waiter
return
1000 ?"1. go 2. get 3. drop 4. wield 5. unwield 6. wear 7. remove 8. use"
1001 ?"9. light 10. examine 11. read 12. buy 13. sell 14. list 15. menu"
1002 ?"16. talk to 17. score 18. inventory 19. kill 20. save":return