##########################################################################
#
#
# Little girl in the big world. An Interactive Fiction story file.
# Designed to be compiled and run with StoryFactory.
#
# Written and declared public domain by Peter Wendrich 2003.
#
#
##########################################################################
#
# Process 'about' metaverb
#
##########################################################################


sub _about_about {
  this is the online manual for the game printGameName . ^
  the following pages are available : ^
  - about bugs ^
  - about game ^
  - about persons ^
  - about verbs ^
  - about parser ^
  - about engine ^
  - about author ^
}

sub _about_bugs {
  known bugs: ^ ^ 
  the parser can not deal with multiple objects with the same name .
  the only place this matters is in the halls ( ground and first floor ) .
  do ` open west ' instead of ` open door ' and problem is solved . ^ ^
  
  there is no load or save ( sorry about that ! ) .
  on the plus side, you can't die in the game ( atleast not that I know ) .
}

sub _about_author {
  hi , ^ ^
  I ' m Peter Wendrich , a software developer from the Netherlands . ^
  this game and engine was actually started as a proof of concept of a new virtual machine . after discovering the IF-Competition I decided to extend the system and implement a complete game with it . ^
  although english is not my native language I tried my best to keep everything clean . anyway I hope you enjoy yourself in my virtual world . ^ ^
  while you wander around take good care of my little Alice will ya ? she has the nasty habbit of running into trouble all the time . ^ ^
  look in the startup banner of this game for contact information . ^ ^
  have fun , ^
  Peter
}

sub _about_game {
  welcome to this interactive fiction game printGameName .
  the game is a little different from the usual IF-games , because there are two main characters in the story . ^ ^

  typing ` I examine dollhouse ' will use the ` I ' or you figure in the game to examine the dollhouse . the other main character is
  Alice . by typing ` Alice open door ' , you will instruct the ` I ' character to ask Alice to open the door . actually
  typing just ` open door ' will give the same result ( if Alice is available ) .
  if the person is not given the game engine will guess the correct one ( most of the time that will be Alice ) and informs you of it's choice . ^ ^

  the main story is linear , but there are enough side steps and puzzles to hide this fact from the player .
  this game is not a ` guess the verb ' game and most puzzles have multiple ( logical ? ) solutions . if all fails use _hintName by typing ` hint ' . ^ ^

  this program is freeware and put into the public domain . you are allowed to copy , share , reproduce , duplicate , inspect , install , review , list , change , download , re-engineer , disassemble , delete , decompile and ofcourse play this game without any restrictions .
}

sub _about_parser {
  the parser build in this game is basically a ` verb noun ' parser .
  the game uses two main characters so the parser accepts a actor to which the command
  should be addressed . ` Alice , get the box ' instructs Alice to get the box in
  contrast of ` I get the box ' . ^
  to make the parser a little more intelligent it also supports ` I ask Alice to get the box ' ,
  which changes the actor to Alice after parsing ` I ask ' .

  the game itself doesn't really depend on the advanced features , for most actions in the
  game two to three words are enough . accept for the ` I ask Alice about dollhouse ' type of
  constructions .

  the parser doesn't support counting and plurals , but the game is constucted in such a way
  that those are not needed to complete it .
}

sub _about_engine {
  the game is compiled with a tool called StoryFactory which is implemented as a perl script . it reads a textual descriptions and compiles code for a virtual stack machine ( like FORTH with two stacks ) . it works in much the same way as the Z-machine used for Inform games , but it has different properties . it uses less CPU power but uses more memory . ^
  to run the game you need a runtime system . currently there is a runtime written in C distributed as a win32 executable , a javascript engine for running inside a browser and there exists a interactive debugger written in perl .
  for those interested all tools and source code will be released under the GPL license . this game will be supplied in source code form as an example .
}

sub _about_persons {
  this game is a little special that it has two main characters instead of one :
  Alice a little girl of about seven years old and you . ^
  play , think and explore together and find the goals layout for today . ^
  Alice as little girl has some restrictions on what she can carry and reach . you
  are no superman either and also have some limitations ( or should I say lots of limitations ) .
  ask Alice if you want to know how and why .
}

sub _about_verbs {
  some of the supported verbs are : ^
  ask about , ask to , bite , drop , enter , examine , get , go , look , look at , move , nibble , play with , plug in , pull , push , put , read , tell about , turn on , turn off , wake up . ^ ^
  some of the supported meta verbs are : ^
  about , up , down , north , east , south , west , score , hint , quit . ^ ^
  shortcuts : ^
  d = down ^
  e = east ^
  l = look ^
  n = north ^
  s = south ^
  u = up ^
  w = west ^
  x = examine
}

#
# Parse about
# input
#   word_after_about
# returns
#   0 when only about is parsed
#   1 when extra word is parsed for topic (result is put in $action)
#
sub _parseAbout2 {
  /dup /lit    /ret /eqif /lit _about_about   /to $action /drop /fret /then
  /dup /lit    bugs /eqif /lit _about_bugs    /to $action /drop /tret /then
  /dup /lit  author /eqif /lit _about_author  /to $action /drop /tret /then
  /dup /lit    game /eqif /lit _about_game    /to $action /drop /tret /then
  /dup /lit persons /eqif /lit _about_persons /to $action /drop /tret /then
  /dup /lit  parser /eqif /lit _about_parser  /to $action /drop /tret /then
  /dup /lit  engine /eqif /lit _about_engine  /to $action /drop /tret /then
  /dup /lit   verbs /eqif /lit _about_verbs   /to $action /drop /tret /then
  /drop /fret
}

#
# inputs
#   parse_pos
# outputs
#   new_parse_pos
#
sub parseAbout {
  /dup /fetch
  _parseAbout2
  /if [+1] /then
}

sub showXyzzy {
  you feel a little dizzy . suddenly green characters start falling from the ceiling and walls .
  more and more green rain appears , except for Alice who glows in gold .
  maybe you should not have eaten those yellow pills . ^
  you blink with your eyes and the green rain is gone . everything looks like it should . you
  now know it is only a computer simulation , but somehow it feels strangely reassuring .
}