UNIT COMANDOS;

{ Unidad con las estructuras de datos que almacenan los comandos }

INTERFACE
USES ES, GRAMATIC;

TYPE
    Estados = (mirar, fin, inventario, otro);

    P_Lista = ^Reg_Lista;
    Reg_Lista = RECORD
                      comando :Cadena;
                      turno :WORD;
                      posibilidades, entre :WORD;
                      sig_area :WORD;
                      sig :P_Lista;
                END;
    Comandos_Jugador = ^Reg_Jugador;
    Reg_Jugador = RECORD
                       lista :P_Lista;
                       numl :WORD;
                       sig :Comandos_Jugador;
                  END;

    Objetos = ^Reg_Objetos;
    Reg_Objetos = RECORD
                        nombre :Cadena;
                        sig :Objetos;
                  END;

    Comandos_Ordenador = ARRAY [1..6] OF Cadena;

{*} PROCEDURE Inicializar_Jugador(VAR juga :Comandos_Jugador; fich :STRING;
                                  VAR num_areas :WORD);
{*} PROCEDURE Inicializar_Objetos(VAR obje :Objetos);
{*} PROCEDURE Meter_Objeto(VAR obje :Objetos; nombre :Cadena);
{*} FUNCTION Numero_Objetos(memo :Objetos) :WORD;
{*} FUNCTION Situar_Objeto(obje :Objetos; numero :WORD) :Objetos;
{*} PROCEDURE Memorizar_Objetos(obje :Cadena; VAR memo :Objetos);
{*} PROCEDURE Inicializar_Ordenador(VAR ordenador :Comandos_Ordenador);
{*} FUNCTION Cambiar_Estado(auxi :Cadena; ordenata :Comandos_Ordenador) :Estados;
{*} FUNCTION Situar_Area(punt :Comandos_Jugador;
                     numero :WORD) :Comandos_Jugador;
{*} FUNCTION Situar_Comando(punt :P_Lista; numero :WORD) :P_Lista;

PROCEDURE Mostrar(aoljugador :Comandos_Jugador);
PROCEDURE Mostrar_Objetos(objetito :Objetos);


IMPLEMENTATION

PROCEDURE Crear(VAR juga :Comandos_Jugador);
BEGIN
     juga := NIL;
END; { Crear }

PROCEDURE Meter_Area(VAR punt :Comandos_Jugador; lista :P_Lista;
                     numero :WORD);
VAR
   nuevo :Comandos_Jugador;
   auxi :Comandos_Jugador;
BEGIN
     NEW(nuevo);
     nuevo^.lista := lista;
     nuevo^.numl := numero;
     nuevo^.sig := NIL;
     IF (punt = NIL) THEN
        punt := nuevo
     ELSE BEGIN
         auxi := punt;
         WHILE (auxi^.sig <> NIL) DO BEGIN
               auxi := auxi^.sig;
         END;
         auxi^.sig := nuevo;
     END;
END; { Meter_Area }

PROCEDURE Meter_Comando(VAR punt :P_Lista; comando :STRING;
                        turnos, posibilidades, entre, sig_area :WORD);
VAR
   nuevo :P_Lista;
   auxi :P_Lista;
BEGIN
     NEW(nuevo);
     nuevo^.comando := Asignar(comando);
     nuevo^.turno := turnos;
     nuevo^.posibilidades := posibilidades;
     nuevo^.entre := entre;
     nuevo^.sig_area := sig_area;
     nuevo^.sig := NIL;
     IF (punt = NIL) THEN
        punt := nuevo
     ELSE BEGIN
         auxi := punt;
         WHILE (auxi^.sig <> NIL) DO BEGIN
               auxi := auxi^.sig;
         END;
         auxi^.sig := nuevo;
     END;
END; { Meter_Comando }

PROCEDURE Inicializar_Jugador(VAR juga :Comandos_Jugador; fich :STRING;
                              VAR num_areas:WORD);
VAR
   arch :TEXT;
   cont :WORD;
   nombre :STRING;
   numero :WORD;
   turnos, posibilidades, entre, sig_area :WORD;
   espacio :CHAR;
   auxi :P_Lista;
BEGIN
     Crear(juga);
     Assign(arch, fich);
     Reset(arch);
     num_areas := 0;
     ReadLn(arch, numero);
     WHILE (NOT EOF(arch)) DO BEGIN
           num_areas := num_areas + 1;
           auxi := NIL;
           FOR cont := 1 TO numero DO BEGIN
               Read(arch, turnos);
               Read(arch, posibilidades);
               Read(arch, entre);
               Read(arch, sig_area);
               Read(arch, espacio);
               ReadLn(arch, nombre);
               Meter_Comando(auxi, nombre, turnos, posibilidades, entre,
                             sig_area);
           END;
           Meter_Area(juga, auxi, numero);
           ReadLn(arch, numero);
           Writeln(num_areas);
     END;
END; { Inicializar_Jugador }

PROCEDURE Inicializar_Ordenador(VAR ordenador :Comandos_Ordenador);
BEGIN
     ordenador[1] := Asignar('L');
     ordenador[2] := Asignar('LOOK');
     ordenador[3] := Asignar('I');
     ordenador[4] := Asignar('INVENTARY');
     ordenador[5] := Asignar('QUIT');
     ordenador[6] := Asignar('RESET');
END; { Inicializar_Ordenador }

FUNCTION Cambiar_Estado(auxi :Cadena; ordenata :Comandos_Ordenador) :Estados;
VAR
   elestado :Estados;
BEGIN
     elestado := otro;
     IF ((Iguales(auxi, ordenata[1])) OR (Iguales(auxi, ordenata[2]))) THEN
        elestado := mirar;
     IF ((Iguales(auxi, ordenata[3])) OR (Iguales(auxi, ordenata[4]))) THEN
        elestado := inventario;
     IF ((Iguales(auxi, ordenata[5])) OR (Iguales(auxi, ordenata[6]))) THEN
        elestado := fin;
     Cambiar_Estado := elestado;
END; { Cambiar_Estado }

FUNCTION Situar_Area(punt :Comandos_Jugador;
                     numero :WORD) :Comandos_Jugador;
VAR
   cont :WORD;
   auxi :Comandos_Jugador;
BEGIN                                                                
     auxi := punt;
     FOR cont := 1 TO (numero - 1) DO
         auxi := auxi^.sig;
     Situar_Area := auxi;
END; { Situar_Area }

FUNCTION Situar_Comando(punt :P_Lista; numero :WORD) :P_Lista;
VAR
   cont :WORD;
   auxi :P_Lista;
BEGIN
     auxi := punt;
     FOR cont := 1 TO (numero - 1) DO
         auxi := auxi^.sig;
     Situar_Comando := auxi;
END; { Situar_Comando }

PROCEDURE Inicializar_Objetos(VAR obje :Objetos);
BEGIN
     obje := NIL;
END; { Inicializar_Objetos }

PROCEDURE Meter_Objeto(VAR obje :Objetos; nombre :Cadena);
VAR
   nuevo :Objetos;
   auxi :Objetos;
BEGIN
     NEW(nuevo);
     Copiar(nuevo^.nombre, nombre);
     nuevo^.sig := NIL;
     IF (obje = NIL) THEN
        obje := nuevo
     ELSE BEGIN
         auxi := obje;
         WHILE (auxi^.sig <> NIL) DO BEGIN
               auxi := auxi^.sig;
         END;
         auxi^.sig := nuevo;
     END;
END { Meter_Objeto };

FUNCTION Numero_Objetos(memo :Objetos) :WORD;
VAR
   cont :WORD;
   auxi :Objetos;
BEGIN
     cont := 1;
     auxi := memo;
     WHILE (auxi <> NIL) DO BEGIN
           auxi := auxi^.sig;
           cont := cont + 1;
     END;
     Numero_Objetos := cont - 1;
END; { Numero_Objetos }

FUNCTION Situar_Objeto(obje :Objetos; numero :WORD) :Objetos;
VAR
   cont :WORD;
   auxi :Objetos;
BEGIN
     auxi := obje;
     FOR cont := 1 TO (numero - 1) DO
         auxi := auxi^.sig;
     Situar_Objeto := auxi;
END; { Situar_Objetos }

PROCEDURE Memorizar_Objetos(obje :Cadena; VAR memo :Objetos);

VAR
   auxi :Cadena;
   objeto :Cadena;
BEGIN
     auxi := obje;
     REPEAT
           objeto := Leer_Palabra(auxi);
           IF ((objeto <> NIL) AND (NOT(Es_Articulo(objeto)))) THEN BEGIN
                  Meter_Objeto(memo, objeto);
                  Borrar_Cadena(objeto);
           END;
     UNTIL (auxi = NIL);
END { Memorizar_Objetos };

PROCEDURE Mostrar(aoljugador :Comandos_Jugador);
VAR
   aux :Comandos_Jugador;
   aux2 :P_Lista;
BEGIN
     aux := aoljugador;
     WHILE (aux <> NIL) DO BEGIN
           Writeln(aux^.numl);
           aux2 := aux^.lista;
           WHILE (aux2 <> NIL) DO BEGIN
                 Escribir_Cadena(aux2^.comando);
                 WriteLn;
                 Write(aux2^.turno, ' ');
                 Write(aux2^.posibilidades, ' ');
                 Write(aux2^.entre, ' ');
                 Write(aux2^.sig_area, ' ');
                 WriteLn;
                 aux2 := aux2^.sig;
           END;
           ReadLn;
           aux := aux^.sig;
     END;
END; { Mostrar }

PROCEDURE Mostrar_Objetos(objetito :Objetos);
VAR
   auxi :Objetos;
BEGIN
     auxi := objetito;
     WHILE (auxi <> NIL) DO BEGIN
           Escribir_Cadena(auxi^.nombre); WriteLn;
           auxi := auxi^.sig;
     END;
END; { Mostrar_Objetos }

END. { DATOS }
