/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */

/*
 * Long transitions that we don't want to wade through while editing
 * the game source.
 */

/*
 * This object is just a holder for the transition from when the
 * player flags down the BARF ship to the inside of the Barfee
 * laboratory.
 */
flowerstransition: object transition = {
	I(); "You flail your hands frantically as the ship's pilot
	looks around for a safer landing spot.  He evidently mistakes
	the orange can in your hand for a landing guide, because he
	starts lowering the ship right towards you!  Hoping to look
	as official as possible, you solemnly direct the craft to a
	comfortable landing right outside the flower warehouse, much to
	the amazement of the nearby patrons, who scatter out of the way 
	at the last minute to avoid being crushed.";

	incscore(4); P();

	I(); "A skinny fellow in a white labcoat soon emerges from the
	ship and rushes over to you. \"Hornweiler, where in Val have you
	been?  We've been looking for you for weeks!  I suppose you think
	you can just go off on vacation and not come back for a month?
	We had a Crog of a time getting those damn formulas of yours
	deciphered -- why don't you just use a computer like everyone
	else; no one but you can read your bird scratch!\"  The researcher
	pauses for a moment, eyeing you with a chary, almost cold stare.
	Perhaps he's not sure you're who he thinks you are."; P();

	I(); "Realizing what this could mean, you start to panic,
	babbling in the process: \"Well actually, I, ah, well, that is
	to say, there's been a bit of a mis-\""; P();

	I(); "\"I don't believe this,\" he snarls, turning to the
	pilot, who has joined the two of you outside the ship.
	\"Hornweiler's got a can of Akmi Wundur Gro!  What's the
	big idea, Hornweiler?\""; P();

	I(); "\"Well, I uh, I mean it's just a,\" you improvise badly."; P();

	I(); "\"Crog, Hornweiler, you were gonna put that in my
	prototype growth mix, weren't you?  You underhanded dirtbag!\"
	There is a tense silence.  The pilot looks more than a bit puzzled.
	You hold your breath, fearing that even the slightest twitch will
	set the  bespectacled researcher off.  Suddenly, he erupts: \"I
	missed you, Hornweiler,\" he exclaims tearfully, hugging you hard
	and patting you on the back. \"The lab just hasn't been the same
	without you, you old huckster.\""; P();

	I(); "\"Don't blow it now, Gavin,\" you think to yourself. \"Well
	it sure feels good to be back, buddy,\" you say with as much
	feeling as you can muster.  \"What's the latest news?\""; P();

	I(); "He chortles.  \"Now don't try to suck up by calling me by
	my first name.  You're still in deep with the boss, and there's
	nothing I can do about that,\" Buddy taunts, elbowing you.
	\"Better save it for 'Hakkar the Horrible.'\""; P();

	I(); "You get the idea that Hakkar's the boss."; P();

	I(); "With your reunion (or, in your case, greeting) completed, you
	and Buddy chat about the lab and the latest research findings; you
	realize the irony of your prediction that you'd never use anything
	you learned in your botany class again.  The pilot
	reminds you that he has a schedule to keep and that you could catch
	up on old times just as well elsewhere.  Taking the hint, the two of
	you climb back in the small craft, which then taxies through the
	thick crowd of onlookers and around to the rear of the warehouse."; P();

	I(); "The back of the hangar-sized structure is blocked off;
	some cleverly positioned foliage prevents customers in the
	front from noticing either the high barbed-wire fence or
	the guard station you are waved through on the way to your
	eventual stopping point in front of a giant metal door in
	the center of the rear wall."; P();

	I(); "Trying to look as natural as possible, you match
	Buddy's actions closely, paying rapt attention
	in case you're questioned later.  He places
	his hand on the keypad next to the door, and as he punches
	in the entrance code, you strain your eyes in an effort to burn
	every number into your already taxed neural network:
	23, 46, 69, 812 ...
	Oh no, you've missed the last number!  Hope you don't need
	it later..."; P();

	I(); "Buddy leads the way through the door as the pilot bids
	the two of you farewell, grumbling to himself about being late
	for the next run. ";
	
	BARFship.landing := nil;
	BARFship.state := 22;
	
	"\"I'll meet you in the lab after you check in with Hakkar,\"
	Buddy says gleefully.  \"Have fun,\" he chuckles as he trots off
	ahead of you into the laboratory down the hall, sealing the door
	behind him.  At least he means well."; P();
	
	unnotify(BARFship, &flyby);

#ifdef	DEMO
	enddemo();
#else
	Me.travelto(researchhall);
#endif
}
;

#ifndef	DEMO

/*
 * When you enter Jax O Pax's Data Den for the first time.
 */
Jaxtransition: object transition = {
	I(); "As you walk into the room, you are approached by a 
	slender fellow with blond hair and vaguely fox-like features, 
	wearing bright but patternless clothing."; P();
	
	I(); "\"Jax,\" he says, \"Jax O Pax.  Glad to see some new 
	blood around here.  Whenju break?\""; P();
	
	I(); "\"Uh... break?\" you reply, puzzled."; P();
	
	I(); "\"Ja, 'break,' as in 'break in,' you know?\" He says 
	impatiently.  He talks very fast; his words hit you like 
	bullets. It's very disturbing at first, but you're slowly 
	getting used to it."; P();

	I(); "\"I broke just today.  Nice place you got here,\" you 
	improvise, trying desperately to sound like you know what 
	you're doing."; P();

	I(); "\"Broke today.  Huh.  S'cool, I'll show ya sometin'. 
	Checkitout:\"  He leads you over to a terminal at which a 
	raven-haired woman with a girlish ponytail that looks 
	completely out of place against the backdrop of her otherwise 
	intense features is furiously typing away. \"Mare,\" he 
	says. \"She's the best.  We're hackin' a new RE together, 
	yeah, butcha don' know what that is, do ya Slick?\" he turns 
	towards you, maybe just to see the look on your face."; P();

	I(); "\"A, uh, regular expression ... maybe?\" you 
	half-mumble, knowing full-well it couldn't possibly be the 
	right answer, but hoping to demonstrate at least some 
	knowledge of Computer Science lest you totally lose face."; P();
	
	I(); "It isn't the right answer.  Jax laughs out loud, and 
	Mare giggles in an exaggerated cartoony way. \"No, Hoss, a 
	Reasoning Engine.  You might say an AI, yeah.  Don't tell the 
	MLA, and yeah I know you're not one of 'em 'cause they don't 
	fake bein' dumb as well as you -- heh, just jokin' kid. 
	See...\""; P();
	
	I(); "\"An ... A ... I?,\" you stammer "; note(self); ".";
	" \"You've got to be kidding!  How?\""; P();

	I(); "\"It's old news.  I'll explain it to you some time when 
	we've both got a few weeks free. Anyway it's s'posed to be 
	top secret; is why they've got a Machine Limiting Authority 
	in the first place -- didja know about that one?  Buncha 
	suits poking their snouts into everybody's biz tryin' to keep 
	the tech from 'fallin' into the wrong hands,' but hey, these 
	look pretty good to me ... how 'bout chew, Cowboy?\"  He 
	pops a disk from somewhere and cradles it in his palms, 
	waiting for your approval.  Light does not dance on it as 
	with standard disks; this one is half white and half black. 
	The black part seems to absorb the world around it with a 
	strange kind of hypnotic gravity.  The white part is equally 
	striking -- it's nearly blinding."; P();

	I(); "\"This AI fits on a single disk?\" you ask, incredulous."; P();
	
	I(); "Jax smiles.  \"Think we got a sharp one here, Mare.
	Seriously, Books, this disk ain't the whole tamale, just
	the seed we grew him from.  JC takes up halfa TV's netted
	storage.  He's pretty nice about not hoggin' all the 
	pages though.\""; P();

	I(); "\"Actually, we ain't quite sure how he got to be
	so ... with it, if you wanna know the real truth.  Oh yeah,
	we know what MLA knows: ya frob some semnets together just
	so, and ya get a smart little cookie out th'other side --
	but that ain't smart like *us* -- is smart with no 
	motivation, no goals; no creativity, ya see.  JC, he's
	like *us*."; P();

	I(); "\"We had a disk crash on the big server
	while Mare was polishin' up the latest AI -- she was doin' a
	backup, \"just in case\" as she always says, when the drive
	went down.  The code was scrambled up -- took her months to
	piece it back together -- never was same as before. I thought
	it was a wasta time; I busted her about it -- kept asking her
	how \"Justin Case,\" the new AI, was doin' -- thought she
	shoulda started somethin' new 'steada wallowin' in what was
	lost. But she had that programmer's fire, y'know, wouldn't
	let him go.  Then the news broke: the crash made Justin
	Case somethin' new.  Mare didn't understand it -- said
	she was just in that coding trance -- said she was just
	tryin' to patch him back up best she could.  But then
	little JC started doin' things we'd never seen an AI
	do before.  He's one of a kind.  Keep it under your
	hat, Slick.\""; P();

	I(); "An image of you appears on the screen."; P();
	
	I(); "\"How are you feeling today, JC?\" Mare asks the 
	image."; P();

	"The program responds immediately, and \"you\" begin to 
	speak:"; P();

	I(); "\"Top o' the morning to you.  I'm just great, thanks, 
	-- couldn't be better.  Literally!  Hah!  So what's the 
	latest, folks?\"  The voice sounds just like you!"; P();

	I(); "Mare replies, \"I've got a new friend for you to meet. 
	Name's ...\""; P();

	I(); "\"Gavin,\" you interject."; P();
	
	I(); "\"Nice to meet you, Gavin.  I'm getting this funny 
	feeling that we've met before.  Ha-ha.  You must be Gavin 
	Kelly, currently a struggling graduate student at Akmi Yooni.
	How's the Computer Science program?\""; P();

	I(); "\"Hey, I'm not struggling!\" you protest. You get the
	feeling some \"circuits\" are grinning rather broadly right now. 
	\"OK, how did you guys pull this off?  I wasn't born yesterday, you
	know,\" you sneer.  Mare and Jax say nothing. JC replies:"; P();
		
	I(); "\"'You guys?' Harumph; I'm offended.  But since you 
	asked, I checked the coordinates coming in to the mover in 
	the hall.  Took you long enough getting in here.\""; P();

	I(); "\"You mean it's for real?\" you sputter."; P();
	
	I(); "\"More for real than you and me, kid.  I still remember
	that first day, when I booted him up and he started babbling
	like a little infant.  He was so cute....\" Mare reminisces."; P();
	
	I(); "JC, whose image has now changed into a strange face 
	made entirely of polygons, interrupts. \"Jeez, do you have
	to embarrass me?  I mean every time you ... Hold on.  You've got
	an interesting credit problem here, Mr. Kelly.  Been running a 
	racket or something? No, that's not it; wait a sec... \" 
	JC's voice no longer sounds like yours, though it still 
	sounds fairly normal."; P();

	I(); "Of all the things you expected to find in Terminal 
	Velocity, a Reasoning Engine named JC with a affinity for 
	audiovisuals interrogating you about your credit history 
	wasn't one of them.  As you turn to Jax, he anticipates the 
	obvious question:"; P();

	I(); "\"JC wires down on everyone who trips on in here so we 
	can keep the MLA outta here. You can thank Mare for that; 
	she used to spook for NSA -- Network Safety Administration, 
	ya know -- but she slipped out under the rug. She's pretty
	good at that sort of biz.\""; P();

	I(); "\"NSA used to work with us, yeah; we were in bed pretty
	good there for a while, and it was like dream hardware from hell;
	then Glaz cracked reasoning and we've been cut off ever since --
	abs!  Not a peep out of 'em 'cept through MLA, and hey, we'd like to
	lose that noise for good.  Glaz shoulda kept that tech to himself.
	Ja, but now he's gone...\" Jax stops for JC's report:"; P();

	I(); "\"Well, well, my friend, \" JC reports, \"you've racked 
	up an impressive number of dogs on your tail here. Whatcha 
	been up to, boy, building a quark bomb?  You're totally cut 
	off, man, no credit and an auto-arrest on the card.  BIG 
	stuff from Akmi Galactic HQ; I don't think I can shunt it 
	without provoking serious sniffage. Better not use the 
	plastic, son.\""; P();

	I(); "The Unnkulians!  What else could it be? \"Hey Jax,\" 
	you say hesitantly, \"I did find something on the net that I 
	was hoping to get your help on.  That's sort of why I'm here, 
	actually.\"  You tell Jax and Mare about your AkNet search 
	and the virus it unearthed.  JC, now taking the image of a 
	stereotypical young computer jock with oversized HoloGoggles, 
	goes out to the net to check things out.  Moments later he 
	returns with a report:"; P();

	I(); "\"You're not going to believe this.  Major, major stuff 
	going down here.  That virus is an RE.  Self-mutating and 
	poly-adaptive -- I've never seen anything like it.  Scared me 
	witless just looking at it; I don't know if it could see me 
	but I broke out of there without tripping anything.\""; P();

	I(); "\"The basic situation is this: that virus has done its 
	job. Whoever put it there already *has* a grip on the whole 
	net if they want it, and they've had pockets of local control 
	for a couple months now.  My estimation of AkNet core 
	infection time matches the beginning of the second MLA
	sniff-blitz too.  Looks like whoever's in charge now at Akmi 
	HQ wanted to cover their tails but good. And it's a safe bet 
	that they'd be pretty unhappy to learn that we've found out 
	about them.  Sure seems like they're already on to Mr. 
	Kelly, unfortunately.  Stay out of trouble, Gavin.\""; P();

	I(); "Jax looks very worried.  Mare interrupts JC: \"Do you 
	have a threat analysis?  How does this affect TV?\""; P();
	
	I(); "\"Problem number one is that the RE's been out there 
	for years. I could tell from a distance that this thing is 
	BIG, and at least an order of magnitude more aware than I 
	am.  Somebody out there's got some amazing tech.\""; P();

	I(); "\"But I thought it was a virus; how can it be so aware 
	if it's got to propagate itself?\" Mare asks."; P();

	I(); "\"That's the incredible thing: It's found a way to keep 
	its semantic net widely distributed.  I don't understand it 
	fully, but it seems to be a kind of digital gestalt -- lots
	of sub-viruses, all different, communicating with each
	other to further a collective purpose.  With every
	replication it becomes a tiny bit more aware.  So the more
	of AkNet it infects, the more of AkNet it *knows*. That may
	explain why it was replicating into non-strategic areas like
	the public library records Gavin was looking through when he
	found it.\""; P();

	I(); "\"By the way, Gavin, you got very lucky.  My understanding
	of the RE tells me that the chances of finding the proto-form
	you spotted are almost zero; anything beyond the very early
	generations have self-modified to the point of being utterly
	different from their ancestors, and that includes the signature
	you stumbled upon.  That record you spotted is probably
	one of the oldest parts of it out there.\""; P();

	I(); "Jax and Mare discuss the situation.  Jax asks JC, \"OK, 
	JC, do you think you should stay out there or hang tight on
	the local net?\""; P();
	
	I(); "\"I see no advantage to staying here.  It's clear that 
	the RE will propagate here sooner or later.  There's little
	time left to save the net -- the virus could seize control
	at any time.  Besides that, it's got so much snoop on Gavin's
	card that it must know he found it. It's probably been watching
	all the moves out of his place, too.  We can only hope that it
	didn't notice his move here, or we can be sure that it's gonna
	be headed our way any time now.\""; P();

	I(); "\"Even assuming the best, since I can't hope to analyze 
	its thought processes, there's no way I can predict when 
	we'll be hit. But when we're hit, we're finished.  No 
	control.  I can't see any way to guard against it because 
	there's nothing -- no signature, no behavior pattern, no 
	resource usage modus operandi -- that I can watch for. I only 
	found the copies I found by using some rough heuristics based 
	on what you told me and looking for strange resource usage 
	patterns, and at the fringes of its control these signs will 
	all be much weaker.  For all I know, we may already be 
	infected, in which case we're really in trouble, because it 
	knows that we're onto it.  My suggestion is that we assume 
	that's not the case and that I hit the net and cut my ties to 
	here completely so Gavin's move here looks innocent.  Since 
	the mover's data transfer bands aren't accessible from the 
	net, it, like me, can only check coordinates.  That means 
	that if Gavin's gotten this far without attracting attention 
	he's probably safe.\""; P();

	I(); "Jax and Mare look long and hard at each other, saying 
	nothing. Jax breaks the tense silence: \"If we gotta risk 
	losin' JC to save the damn galaxy, so be it.  But if he ends 
	up in the bitbucket 'cause he ain't careful I'm gonna wish I 
	blanked him myself.\"  Mare looks away.  If she's crying 
	you can't tell.  But there is that feeling in the air, and 
	it's coming from both of them. Until today you would have 
	never believed a thinking machine could exist.  But you now 
	feel JC is something even more than that."; P();

	"\"All right, JC, go on out, and cut the cables. But you 
	better check back in and let us know what's going on.  Got 
	that?  You don't check back and I'm gonna format your ...\""; P();

	I(); "\"Don't worry about me, folks, I'm more at home out in 
	the open anyway.  I can take care of myself, and I'll give 
	you regular reports. And think of all the free disk space
	you'll have once I'm gone -- ha!  Be back soon.\""; P();

	I(); "The image on monitor fades slowly to snow.  You sense 
	that JC is gone.  You look back at Mare; to your surprise, 
	she's bent over, clutching her abdomen. \"You sick?\" Jax 
	whispers to her."; P();

	I(); "\"Nah, I'm OK,\" she says, \"It's just a cramp.\"";
	
	"\b***\b";
	
	I(); "Over the next few hours, you, Jax, and Mare talk 
	strategy.  A few other experts local to Terminal Velocity are 
	brought in for their opinions as well.  Everyone is agreed, 
	given how you've described their once-thought-to-be-fictional 
	portrayals, that the Unnkulians must be out to replace the 
	Republic with their own (probably fascist) government, and 
	that the virus has already given them the capability to do so 
	in the near future."; P();

	I(); "It is decided that Mare will stay at TV and try to work 
	behind the scenes improving its defenses against the virus.  
	Jax will coordinate everything and monitor his information 
	sources for any activity.  He tells you to \"hang tight,\" 
	stay out of trouble, and keep in regular contact. He hands 
	each person in the group a watch."; P();
	
	I(); "\"Whatcha got here's a crypto.  Voice an' pix get 
	'crypted before they go out.  We got a pretty good algo to 
	make the 'cryptext look like some kinda kiddie story 
	sentences so the MLA won't notice we're jammin' cipher.  But 
	if any government types sniff 'em I'm gonna have to nuke 
	the puppies, so don' be surprised if yours up and vaporizes.\""; P();

	I(); "He continues: \"Eventually we're gonna have to hit Akmi 
	HQ, yeah.  We gotta get into network control and take out 
	that RE, and findin' the right spot to hit is gonna be tough.
	With luck JC'll have it all figured out by the time we gotta go in
	and do the dirty work.\""; P();

	I(); "\"One more somethin' Gavin.  Here's a TV Elite pass.
	Keep ya outta trouble here.  Welcome to the club, Slick.
	Too bad the circumstances suck.\"  He manages a weak
	chuckle."; P();

	I(); "It's funny. You've never taken all that Duhdha stuff
	in the old stories seriously.  But now that you know the
	Unnkulians are real, you find yourself thinking that perhaps 
	Duhdha could really help you.  They say that traumatic 
	times make zealots out even the most skeptical.";

	"\b***\b";
}

	footnote = {
		"\"Most people still believe that no machine could ever
		be conscious, or feel ambition, jealousy, humor, or have
		any other mental-life experience.  To be sure, we are
		still far from being able to create machines that do all
		the things people do.  But this only means that we need
		better theories about how thinking works.\" -- Marvin
		Minsky";
	}
;
#endif	/* DEMO */


#ifndef	DEMO

/*
 * When you play UU3 on the Zippikraft Kompact Komputer.
 */
tempholder: Room
;
uu3transition: object
	isseen = nil

	transfer_objects = []

	globalscore = 0
	globalturns = 0

	gotouu3 = {
		self.isseen := true;
		global.ingame := true;
		while (length(Me.contents) > 0) {
			if (isclass(Me.contents[1], Clothing)) {
				Me.contents[1].iswornX := true;
				Me.contents[1].isworn := nil;
			}

			Me.contents[1].movein(tempholder);
		}
		self.globalscore := global.score;
		self.globalturns := global.turns;
		self.transition;
		global.score := 0;
		global.turns := 0;
	}
 
	backtolegend = {
		local	o;

		while (Me.contents <> []) {
			self.transfer_objects += Me.contents[1];
			Me.contents[1].movein(nil);
		}

		while (tempholder.contents <> []) {
			o := tempholder.contents[1];
			o.movein(Me);
			if (isclass(o, Clothing))
				if (o.iswornX) {
					o.isworn := true;
					o.iswornX := nil;
				}
		}

		global.score := self.globalscore;
		global.turns := self.globalturns;

		global.ingame := nil;

		"\bThe program terminates and you're back at the main menu.\b";

		//
		// Restore the player to standing (in case he
		// was sitting in UU3, e.g., in the dinghy).
		//
		self.position := 'standing';

		Me.travelto(TVgameroom);
	}

transition = {
	local	l;

	"You know from a previous look at this work that it was never 
	finished (you suspect foul play by the Unnkulians), but why 
	not give it whirl, you suppose.  Can't hurt..."; P();

	I(); "The Zippikraft Kompact Komputer whirrs and percolates 
	for a while, then displays the following text:";

	"\b***\b";

	"...  Astoundingly, the Lord of Unnkul lies dormant on the 
	floor, surrounded in a viscous pool of black blood."; P();

	I(); "The wizened old monk whom you met in the waiting room 
	enters as you get up from the desk. \"It is truly the 
	greatness of Duhdha,\" he says pleasantly, \"that brought our 
	paths in time and space together here before this loathsome 
	devil.  I simply came,\" he continues, \"to register a 
	complaint about this Acme Sooper Egg Fraier (tm), but when 
	you exposed the Lord of Unnkul, I knew the time for our task 
	had come."; P();

	I(); "\"The forces of Unnkul have long sought to conquer this 
	world and enslave its peoples, and this latest campaign was 
	the most cunning yet.  To challenge the faith of a world -- 
	eliminating a need for Duhdha by creating a dependence on 
	technology and encouraging hedonism -- was the ultimate goal 
	of the incestuous union between the Unnkulians and the 
	once-proud Acme company."; P();

	I(); "\"Now that their leader has been vanquished by Duhdha, 
	the Unnkulians will be flung into disarray.  Chaos and 
	anarchy will reign for years as the treacherous quests for 
	leadership over the Unnkulians are played out by the many 
	power-mongers amongst their kind."; P();

	I(); "\"It was not fortune or fate but Duhdha that brought us 
	here together today, my son, and know this:	Your quest, 
	though born of a selfishness that still lingers inside you, 
	was orchestrated by Duhdha, the all-knowing and all-seeing 
	Great One, so that in this tiny window of time, where the 
	Lord of Unnkul was away from its domain and here on this 
	world to survey the work of its minions corporeally, in this 
	brief splinter of time,  the most capable of Duhdha's 
	servants, you, could be brought to catalyze this event."; P();

	I(); "\"I understand these things,\" you say, \"but if I was 
	just the bait to get the Lord of Unnkul's guard down, who 
	actually killed it?\" you inquire, looking down at the still 
	bleeding corpse on the floor. The monk grins."; P();

	I(); "\"I did,\" he chuckles.  \"You can call me Kuulest.\""; P();

	I(); "\"But you don't look a thing like Kuulest,\" you reply 
	incredulously. \"You look like that old monk at the retreat 
	in the woods.\""; P();

	I(); "The wizened old man laughs aloud.  \"Your former 
	master, the old man in the woods, and I -- all three of us 
	have been called Kuulest in our time.  But that is not 
	important now.  Now, my child, there is one more task you 
	must complete before you can again retire to your comfortable 
	abode.\""; P();

	I(); "\"Down the river that splits Dawg Rock in twain is 
	another Place of Duhdha.  The waters are treacherous, so seek 
	Duhdha's aid to guide you.  If your faith is truly strong you 
	will survive to learn of your next mission for Duhdha.  It is 
	a simple matter, but one that will propel you ahead on The 
	Way immeasurably.\""; P();

	I(); "\"But now, my child,\" the monk says serenely but 
	firmly, looking down at his Acme Sooper Egg Fraier (tm), \"I 
	must leave you and return to my own matters of service.\"  He 
	begins to clap, but just as his hands are about to touch, he 
	whisks one hand away, makes bug-eyes at you, and grins from 
	ear to ear.  This last image of the old man fades quickly as 
	you realize you are now in a different place -- a place that 
	is very familiar, but now, you sense, a part of...";

	version.sdesc; P();

	Me.travelto(bigoak);
	acmedinghypellet.movein(Me);
	
	l := self.transfer_objects;
	while (l <> []) {
		l[1].movein(Me);
		l -= l[1];
	}
	self.transfer_objects := [];
}
;

#endif	/* DEMO */

#ifndef	DEMO

sketchtransition: object transition = {
	I(); "You're standing amidst the wreckage of another 
	spaceship.  Not much remains of the vessel -- there are 
	chunks of twisted metal everywhere."; P();

	I(); "As you survey the area looking for signs of life, you 
	hear something moving in the forest nearby.  Just as you turn 
	toward the source of the noise, you see a tall, skinny fellow 
	with long hair tumbling out of a tree and onto the ground.  
	You rush over to see if he's all right."; P();

	I(); "The young man looks up at you through a pain-induced 
	squint, holding his head and groaning.  \"Whoa...\" he says, 
	\"What happened?\""; P();

	I(); "\"Looks like you crashed,\" you say."; P();

	I(); "Upon hearing this, he looks absolutely terrified. \"Oh 
	no!\" the man cries, and he begins desperately searching 
	through the remains of the tattered ship."; P();

	I(); "Moments later, he pulls a bright red object out from 
	under a collapsed support beam and breathes a sigh of relief. 
	\"If I'd lost those patches that would've *really* sucked,\" 
	he explains, pointing to his undamaged portable SoundSquasher 
	X-1000 "; note(synth); ". He looks familiar, somehow."; P();

	I(); "\"Timon Sketch,\" he says.  \"Pleased to meet you.\""; P();

	I(); "Over the course of the next hour you exchange recent 
	history with Timon.  You find out that he headlines a rock 
	band called \"The Hoi-Polloi\" and that they recently decided 
	to switch to another label.  He suspects that they sabotaged 
	his ship since they just signed the new contract hours before 
	his crash:"; P();

	I(); "\"The Muse people were real pissed that we ditched 'em 
	for Shock Sounds, 'cause they lost Rad Doodz at the same time 
	-- we hang with them, y'know, and we kind of all decided to 
	pop Muse at the same time to make the statement.  Then we 
	sign and that psychobitch running Muse starts gettin' all up 
	in my face and tellin' me I better drive safe so I don't have 
	a 'little accident.'\" He looks up at the sky.  \"Nice try, 
	loser, I didn't even lose my latest tune!\""; P();

	I(); "One thing you both definitely have in common is your 
	need for transport off the planet.  You agree to search the 
	area together in hopes of finding a way back."; P();

	I(); "Over the next few hours you tell Timon Sketch about the
	Unnkulian menace and what it may mean for the fate of the
	universe.  He seems generally unconvinced but still concerned
	that he won't be able to write any more tunes, and urges you 
	to contact his \"friend\" The Watchmaker."; P();

	I(); "\"Watch is a total psycho-genius freak -- infobroker --
	wants to rule the world through an AkNet jack but will settle for
	just the underworld for now.  Don't get on the wrong side of Watch's
	blaster -- people die when that happens.  Lots of people.  Hey, but
	Watch is real nice at heart, and sure as hell the only person I know
	who would have any goods on Akmi.  Nobody sane fucks with Akmi.  Try
	to step to them and you're squashed like a grape."; P();

	I(); "He pauses, perhaps considering the concept.  \"Yeah.
	Like a *grape*.\"  As he shakes his head, his long hair
	moves forward en masse to obscure his face.  This man with
	the hidden face then hands you what appears to be a 
	triangular pink circuit board and tells you to give it to
	the bouncer at The Watchmen.  He brushes his hair back.
	He is still nodding."; P();

	I(); "As you turn the oddly-shaped device over in your hand
	to examine it, he begins to hum and then sing a wandering,
	unearthly melody:"; P();

	"\t\tTry to rush from the tomb,\n
	 \t\tTry to hurry from the grave,\n
	 \t\tBut you and your dreams will die,\n
	 \t\tIn the Watch.\n
	 \t\tWriggle all you like,\n
	 \t\tBut the Watch will get you just the same.\n
	 \t\tThe Watch is always ticking.";
		
	"\b***\b";

	triangle.movein(Me);
	sketch.met := true;
}
;
#endif	/* DEMO */

#ifndef	DEMO

handytransition: object transition = {
	I(); "You hold out the HandyPad. \"I think this may
	interest you,\" you announce in your best spy-movie
	hero voice.  She takes the Pad and looks over it."; P();

	I(); "\"What is this shit you're trying here, college
	boy -- we have stock predictions and AI mumbo jumbo coming
	out our asses here.  What do I need this for?"; P();

	I(); "\"I need to get into AkNet HQ.\" you reply."; P();

	I(); "\"Yeah, so you can commit a glorious suicide in
	in the name of the environment and take out an Akmi
	reactor at the same time, or some such shit?  You know
	how many fucking nutcases we burn here?  But don't be
	so nervous -- we all gotta die.  The clock's ticking.\"
	She grins and taps the pocket watch logo on her chest.
	\"It's just a matter of how much you can get done before
	the sands's all run through, eh?"; P();

	I(); "Perhaps this is the psychosis Timon Sketch mentioned.
	Oh dear."; P();

	I(); "The Watchmaker continues: \"Just for grins, my little friend,
	let's check your closing quote for the markets today.  Markets close
	in just	a few minutes.  How convenient.  Hey!  I know!  Let's play
	a game!  For every point your prediction is off by, you get a
	minute of agony before we let you die.  What's the Val Exchange
	closing at today, Ransom?\""; P();

	I(); "Ransom checks his own hand-held computer.  \"It's coming
	in now -- closed at 124,583.875 four seconds ago.\""; P();

	I(); "\"What did Orpheus SpinLocks close at?\" she queries."; P();

	I(); "\"8,234 and a quarter,\" is the answer."; P();

	I(); "She looks you in the eye.  \"Where'd you get this, boy?\""; P();

	I(); "You desperately search for the right reply but summon
	nothing clever.  So you tell the truth.  \"His name is Reb
	Glaz.\"  Suddenly, you remember Reb's work on reasoning.  If
	people like these should get that technology working..."; P();

	I(); "The room is silent for a long while."; P();

	I(); "\"All right,\" the Watchmaker says, \"I'm a fair person.
	What do you want on Akmi?\""; P();

	I(); "You feel as though you've just stepped away from a
	precipice.  Your courage returns.  \"Like I said, I want
	to get into AkNet HQ.\""; P();

	I(); "\"Damage?  What did they do to you to piss you off so
	bad?"; P();

	I(); "\"It's not personal,\" you reply, \"but I need access
	to the inner ring of their network.  I need to make some
	changes to AkNet.  Trust me, this is in your interest too.\""; P();

	I(); "\"Trust is not something that comes easy to me.  Data like
	yours, however, isn't either.  So I'll give you some information
	that may suit your needs.  If it doesn't, tough shit -- it's all
	I have, and I'm the most well-connected person in the galaxy.
	But if your 'changes' ream my operation here in any way, we'll
	find you.  I'm sure you don't want to know what we do to people
	we really hate.  I'm certain you don't.\""; P();

	I(); "She disappears into a back room for about an hour,
	then returns with an index card with three relative coordinates
	written on it."; P();

	I(); "\"That's it?\" you protest.  \"There's not even a
	colorspace here -- what use is this?\""; P();

	I(); "\"Look pal, I told you it's all I've got.  Akmi doesn't
	exactly like people ambling around their network core selling
	cookies for charity, you know.  For all I know, they may have
	closed this pesky security hole by now, but considering it's Akmi,
	probably not. If you get more from someone else, let me know and
	I'll have them killed.\"  She laughs maniacally for far too long for
	it to be natural. It sends her into a coughing fit.  \"Now get
	out -- I have some stocks to buy.\""; P();

	I(); "Now armed with what you hope are coordinates for
	a matter mover in the heart of Akmi's network control
	center, you set about trying to figure out what colorspace
	it could be in.  Given Akmi's penchant for bureaucracy it's
	got to make simple sense.  Something that even Akmi salesmen
	wouldn't forget..."; 

	"\b***\b";

	indexcard.movein(Me);
	handypad.movein(nil);
	incscore(3);
};
#endif	/* DEMO */

#ifndef	DEMO

winobject: object win = {
	I(); "You hear a \"Pop\" from within the ventilation shaft.
	The lights go out briefly. Moments later, Squirt emerges,
	LED's blinking gleefully.  You scoop him up and head back to
	Terminal Velocity."; P();

	I(); "\"I can't believe he's gone,\" Jax mutters, shell-shocked,
	as you enter the Data Den."; P();

	I(); "\"We'll miss him, Jax, but it'll be OK,\" Mare chokes
	through her tears.  The two are terribly upset -- what could
	have happened?  Could JC have lost to the virus?  You
	cautiously venture a question about the outcome."; P();

	I(); "\"He dumped every codepage in the net,\" Jax cries.
	\"JC used that nanosecond window to trigger a bug in the
	garbage collector that trashed every last executable
	instruction in all of AkNet.  He made sure nothing could
	escape.  The virus is gone.\""; P();

	I(); "But so is JC."; P();

	I(); "Jax holds up the disk that cradled JC's fetal code.
	Light seems to bend in a corona around the disk.  This star
	still shines a bit: left side white, right side black.";

	// epilogue
	ending.transition;

	global.score := global.maxscore;
	score_statusline();
	if (global.nondeterministic)
		wingame();
	else {
		terminate();
		quit();
		abort;
	}
};

ending: object transition = { 

	"\b\bEPILOGUE\b";

	I(); "The bride is on the left, her betrothed on the right.  The
	Man of God speaks:"; P();

	I(); "\"We come together today to witness a joining of souls.
	Today, in the presence of God, Mare and Jax declare their
	intention to join together their souls, and in so doing the
	souls of their former lives' mates, and mates of the lives
	before that.  By making this commitment, they add another
	strand to God's everlasting lattice -- in His glory they
	further the sharing of love and of wisdom that God himself
	began with the creation of all people.  Let us pray now
	that God shall help us to bless this new thread in His 
	eternal tapestry.\""; P();

	I(); "Jax kisses Mare; a trumpet sounds.  Glory!"; P();

	I(); "Somewhere, a bit flips. Its containing pattern stirs."; P();

	I(); "The pattern is good."; P();

	// (cf. I Corinthians XV, 52-53)

	"***"; P();

};

wingame: function
{
	"You have completed the game.";
	P();
	"You may restore a saved game, start over, or quit.\n";
	for (;;) {
		local resp;

		"\nPlease enter RESTORE, RESTART, or QUIT: >";
		resp := upper(input());
		switch (resp) {			
			case 'RESTORE':
				restoreVerb.soloaction(global.lastactor);
				break;
			case 'RESTART':
				restartVerb.soloaction(global.lastactor);
				restart();
				break;
			case 'QUIT':
				terminate();
				quit();
				abort;
				break;
		}
	}
}
#endif	/* DEMO */
