From cbmvax!cs!phillips Thu Aug  1 07:44 EDT 1991
Received: by blekko.commodore.com; Thu,  1 Aug 1991 07:44 EDT
Received: by cbmvax.cbm.commodore.com (5.57/UUCP-Project/Commodore 2/8/91)
	id AA00101; Thu, 1 Aug 91 07:35:06 EDT
Received: from grolsch.cs.ubc.ca by rutgers.edu (5.59/SMI4.0/RU1.4/3.08) 
	id AA10265; Thu, 1 Aug 91 06:06:00 EDT
Received: by grolsch.cs.ubc.ca id AA17760
  (5.65c/IDA-1.3.5 for skrenta@blekko.commodore.com); Tue, 30 Jul 1991 14:52:31 -0700
Date: 30 Jul 91 14:52 -0700
From: George Phillips <cbmvax!cs.ubc.ca!phillips>
To: Rich Skrenta <blekko!skrenta>
Message-Id: <2603*phillips@cs.ubc.ca>
Subject: a2.shar.2
Content-Type: text
Content-Length: 31108
Status: RO

#! /bin/sh
# This is a shell archive, meaning:
# 1. Remove everything above the #! /bin/sh line.
# 2. Save the resulting text in a file.
# 3. Execute the file with /bin/sh (not csh) to create the files:
#	screen.c
#	main.c
#	cli.h
#	a2.readme
# This archive created: Tue Jul 30 14:43:09 1991
export PATH; PATH=/bin:$PATH
echo shar: extracting "'screen.c'" '(23865 characters)'
if test -f 'screen.c'
then
	echo shar: will not over-write existing file "'screen.c'"
else
cat << \SHAR_EOF > 'screen.c'
/*
 *  a2, an Apple II emulator in C
 *  (c) Copyright 1990 by Rich Skrenta
 *
 *  Command line interface written by Tom Markson
 *
 *  Distribution agreement:
 *
 *	You may freely copy or redistribute this software, so long
 *	as there is no profit made from its use, sale, trade or
 *	reproduction.  You may not change this copyright notice,
 *	and it must be included prominently in any copy made.
 *
 *  Send emulator related mail to:  skrenta@blekko.commodore.com
 *				    skrenta@blekko.uucp
 */

/* hacked from the original screen.c to have X window support */

/* as a note, here are the lo-res colours (from 0 to 15)
	0	black
	1	magenta
	2	dark blue
	3	purple
	4	dark green
	5	grey 1
	6	medium blue
	7	light blue
	8	brown
	9	orange
	10	grey 2
	11	pink
	12	light green
	13	yellow
	14	aquamarine
	15	white
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <memory.h>
#include <stdlib.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <sys/types.h>
#include <sys/time.h>
#include <signal.h>

#include "charset.h"
#include "greypat.h"
#include "hgr.h"
#include "a2.h"

extern int map_to_upper;

/* Apple ][ Display Hardware state */

static int	text_mode = 1;
static int	mixed_mode = 0;
static int	disp_page = 0;
static int	graph_res = 0;

/* high level display state */
enum disp_mode { Text0, Text1, Low0, Low1, High0, High1,
	Mixlow0, Mixlow1, Mixhigh0, Mixhigh1 };
enum disp_mode screen_mode;

enum disp_mode from_hardware[16] = {
	/* G P M T 		high level mode */
	/* 0 0 0 0 */	Low0,
	/* 0 0 0 1 */	Text0,
	/* 0 0 1 0 */	Mixlow0,
	/* 0 0 1 1 */	Text0,
	/* 0 1 0 0 */	Low1,
	/* 0 1 0 1 */	Text1,
	/* 0 1 1 0 */	Mixlow1,
	/* 0 1 1 1 */	Text1,
	/* 1 0 0 0 */	High0,
	/* 1 0 0 1 */	Text0,
	/* 1 0 1 0 */	Mixhigh0,
	/* 1 0 1 1 */	Text0,
	/* 1 1 0 0 */	High1,
	/* 1 1 0 1 */	Text1,
	/* 1 1 1 0 */	Mixhigh1,
	/* 1 1 1 1 */	Text1
};

int flashon;
int display_small = 1;

#define calc_mode()	from_hardware[(graph_res << 3) | (disp_page << 2) | (mixed_mode << 1) | text_mode]

/* X stuff */

Display*	display;
int			screen;
Colormap	colormap;

struct applescreen {
	Display*	disp;
	Window		dwin;
	XImage*		image;
	GC			gc;
	int			(*text)();
	int			(*gr)();
	int			(*hgr)();
	int			width;
	int			height;
};

/* colour indicies for hgr mode */
int black, white, violet, green, blue, red;
/* colour indicies for gr mode */
int gr_clr[16];

struct applescreen aps;

Visual*		visual;

int			monochrome;

/* not currently used font stuff */
unsigned long	fcol;
unsigned long	bcol;
Font			mfont;
XFontStruct*	mfinfo;

/* not currently used stuff... */
int           theScreen, dispcells;
int           bitmap_bit_order;

extern char screen_map[];		/* at the bottom of this file */
extern int text1[];
int text2[24];
int hgr0_addr[192];
int hgr1_addr[192];
unsigned char reverse_cpl[256];
unsigned char textflashon[8 * 256];
unsigned char textflashoff[8 * 256];
unsigned char grseteven[8 * 256];
unsigned char grsetodd[8 * 256];

unsigned char charset_8[64 * 7 * 8];
unsigned char invcharset_8[64 * 7 * 8];
unsigned char* textfon_8[256];
unsigned char* textfoff_8[256];

int line1[0x400];
int col1[0x400];


info(s)
char *s;
{
/*	printf("%s\n", s);*/
}

show_screen_mode()
{
/*	switch (screen_mode) {
	case Text0:	printf("page 0 text\n"); break;
	case Text1: printf("page 1 text\n"); break;
	case Low0:	printf("page 0 lowres\n"); break;
	case Low1:	printf("page 1 lowres\n"); break;
	case High0:	printf("page 0 highres\n"); break;
	case High1:	printf("page 1 highres\n"); break;
	case Mixlow0:	printf("page 0 mixed lowres\n"); break;
	case Mixlow1:	printf("page 1 mixed lowres\n"); break;
	case Mixhigh0:	printf("page 0 mixed highres\n"); break;
	case Mixhigh1:	printf("page 1 mixed highres\n"); break;
	}
*/
}

void eloop();
int poll_interval = 100 * 1000; /* 1/10 th of a second */

screen_setup()
{
	extern int set_text1f();
	int line, col;
	int addr, base;
	int i;
	int j;
	unsigned char* p;
	unsigned char* q;

	flashon = 0;

	for (i = 0; i < 0x400; i++) {
		line1[i] = -1;
		col1[i] = -1;
	}

/*	mem_set[0x04] = set_text1f;
	mem_set[0x05] = set_text1f;
	mem_set[0x06] = set_text1f;
	mem_set[0x07] = set_text1f;*/

	for (line = 0; line < 24; line++) {
		base = text1[line];
		for (col = 0; col < 40; col++) {
			addr = base + col;
			mem[addr] = 0xA0;
			line1[addr - 0x400] = line;
			col1[addr - 0x400] = col;
		}
	}

	for (line = 0; line < 24; line++)
		text2[line] = text1[line] + 0x400;

	for (line = 0; line < 192; line++) {
		int	line_off = (text1[line / 8] - 0x400) + (line % 8) * 0x400;
		hgr0_addr[line] = 0x2000 + line_off;
		hgr1_addr[line] = 0x4000 + line_off;
	}

	for (i = 0; i < 256; i++) {
		int	r, sb, db;
		r = 0;
		for (sb = 1, db = 64; sb != 128; sb <<= 1, db >>= 1)
			if (i & sb)
				r |= db;
		reverse_cpl[i] = r ^ 127;
	}

	for (i = 0; i < 64 * 8; i++)
		textflashon[i] = textflashoff[i] = charset[i];
	for (i = 0; i < 64 * 8; i++) {
		textflashon[i + 64 * 8] = charset[i];
		textflashoff[i + 64 * 8] = ~charset[i];
	}
	for (i = 0; i < 64 * 8; i++)
		textflashon[i + 128 * 8] = textflashoff[i + 128 * 8] =
		textflashon[i + 192 * 8] = textflashoff[i + 192 * 8] = ~charset[i];
	
	for (i = 0; i < 256; i++) {
		int	pat;
		int c = i & 0xf;

		for (j = 0; j < 4; j++) {
			pat = greypat[c * 4 + j];
			grseteven[i * 8 + j] = ((pat << 4) | pat) & 0x7f;
			grsetodd[i * 8 + j] = ((pat << 4) | pat) >> 1;
		}
		c = i >> 4;
		for (j = 0; j < 4; j++) {
			pat = greypat[c * 4 + j];
			grseteven[i * 8 + j + 4] = ((pat << 4) | pat) & 0x7f;
			grsetodd[i * 8 + j + 4] = ((pat << 4) | pat) >> 1;
		}
	}

	buildtable();

	screen_mode = calc_mode();
	show_screen_mode();

	open_display();

	cbuildtable(black, white, violet, green, blue, red);
 
	p = charset_8;
	q = invcharset_8;
	for (i = 0; i < 64 * 8; i++) {
		for (j = 64; j > 0; j >>= 1) {
			if (charset[i] & j) {
				*p++ = white;
				*q++ = black;
			}
			else {
				*p++ = black;
				*q++ = white;
			}
		}
	}

	for (i = 0; i < 64; i++)
		textfon_8[i] = textfoff_8[i] = invcharset_8 + i * 7 * 8;

	for (i = 0; i < 64; i++) {
		textfon_8[i + 64] = invcharset_8 + i * 7 * 8;
		textfoff_8[i + 64] = charset_8 + i * 7 * 8;
	}
	for (i = 0; i < 64; i++)
		textfon_8[i + 128] = textfoff_8[i + 128] =
		textfon_8[i + 192] = textfoff_8[i + 192] = charset_8 + i * 7 * 8;
	
	if (display_small)
		makewin(280, 192, &aps);
	else
		makewin(560, 384, &aps);

	/* we'll use an alarm to poll the event loop.  Not pretty, but it is
	 * a cheap hack that will work.
	 */
	signal(SIGALRM, eloop);
	ualarm(poll_interval, 0);
}

screen_switch(c0_loc)
int	c0_loc;
{
	switch (c0_loc) {
	case 0x50:	text_mode = 0; break;
	case 0x51:	text_mode = 1; break;
	case 0x52:	mixed_mode = 0; break;
	case 0x53:	mixed_mode = 1; break;
	case 0x54:	disp_page = 0; break;
	case 0x55:	disp_page = 1; break;
	case 0x56:	graph_res = 0; break;
	case 0x57:	graph_res = 1; break;
	}
}

int last_line = -1;
int last_col = -1;


#define appleout(n)	if (n >= 0x80) putchar(screen_map[n]); else { StartInverse(); putchar(screen_map[n]); EndInverse(); }


/* this shouldn't be called anymore */
set_text1f(addr, n)
unsigned short addr;
unsigned char n;
{
int line, col;
unsigned char c;
int	sigm;

	if (mem[addr] == n)		/* no change, don't do anything */
		return;

	mem[addr] = n;
	line = line1[addr - 0x400];
	col = col1[addr - 0x400];

	if (line == -1)
		return;

	c = screen_map[n];

	/* show re-calculate screen mode... */
	switch (screen_mode) {
		case Mixlow0:
		case Mixhigh0:
			if (line < 21)
				break;
		case Text0:
			/*
			sigm = sigblock(sigmask(SIGALRM));
			XDrawImageString(disp, dwin, gc, col * 7, line * 8 + 8, &c, 1);
			sigsetmask(sigm);
			*/
			break;
		default:
			break;
	}
}

redraw_screen() {
int i, j;
unsigned short base;
unsigned char c;

/*
	ClearScreen();
	for (i = 0; i < 24; i++) {
		base = text1[i];
		for (j = 0; j < 40; j++) {
			c = mem[base + j];
			appleout(c);
		}
		if (i < 23)
			putchar('\n');
	}

	last_line = -1;
	last_col = -1;

	fflush(stdout);
*/
}


/*
 *  Screen display mapping table
 */

char screen_map[] = {

	'@', 'A', 'B', 'C', 'D', 'E', 'F', 'G',		/* $00	*/
	'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',		/* $08	*/
	'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',		/* $10	*/
	'X', 'Y', 'Z', '[', '\\',']', '^', '_',		/* $18	*/
	' ', '!', '"', '#', '$', '%', '&', '\'',	/* $20	*/
	'(', ')', '*', '+', ',', '-', '.', '/',		/* $28	*/
	'0', '1', '2', '3', '4', '5', '6', '7',		/* $30	*/
	'8', '9', ':', ';', '<', '=', '>', '?',		/* $38	*/

	'@', 'A', 'B', 'C', 'D', 'E', 'F', 'G',		/* $40	*/
	'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',		/* $48	*/
	'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',		/* $50	*/
	'X', 'Y', 'Z', '[', '\\',']', '^', '_',		/* $58	*/
	' ', '!', '"', '#', '$', '%', '&', '\'',	/* $60	*/
	'(', ')', '*', '+', ',', '-', '.', '/',		/* $68	*/
	'0', '1', '2', '3', '4', '5', '6', '7',		/* $70	*/
	'8', '9', ':', ';', '<', '=', '>', '?',		/* $78	*/

	'@', 'a', 'b', 'c', 'd', 'e', 'f', 'g',		/* $80	*/
	'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',		/* $88	*/
	'p', 'q', 'r', 's', 't', 'u', 'v', 'w',		/* $90	*/
	'x', 'y', 'z', '[', '\\',']', '^', '_',		/* $98	*/
	' ', '!', '"', '#', '$', '%', '&', '\'',	/* $A0	*/
	'(', ')', '*', '+', ',', '-', '.', '/',		/* $A8	*/
	'0', '1', '2', '3', '4', '5', '6', '7',		/* $B0	*/
	'8', '9', ':', ';', '<', '=', '>', '?',		/* $B8	*/

	'@', 'A', 'B', 'C', 'D', 'E', 'F', 'G',		/* $C0	*/
	'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',		/* $C8	*/
	'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',		/* $D0	*/
	'X', 'Y', 'Z', '[', '\\',']', '^', '_',		/* $D8	*/
	' ', '!', '"', '#', '$', '%', '&', '\'',	/* $E0	*/
	'(', ')', '*', '+', ',', '-', '.', '/',		/* $E8	*/
	'0', '1', '2', '3', '4', '5', '6', '7',		/* $F0	*/
	'8', '9', ':', ';', '<', '=', '>', '?',		/* $F8	*/

};

int text1[] = {
	0x400, 0x480, 0x500, 0x580, 0x600, 0x680, 0x700, 0x780,
	0x428, 0x4A8, 0x528, 0x5A8, 0x628, 0x6A8, 0x728, 0x7A8,
	0x450, 0x4D0, 0x550, 0x5D0, 0x650, 0x6D0, 0x750, 0x7D0,
	0x478, 0x4F8, 0x578, 0x5F8, 0x678, 0x6F8, 0x778, 0x7F8
};

open_display()
{
	if (!(display = XOpenDisplay(0)))
		err("Can't open display");

	screen = DefaultScreen(display);
	monochrome = DisplayCells(display, screen) < 256;
	colormap = DefaultColormap(display, screen);

	gr_clr[0] = black = getcolour(0, 0, 0);
	gr_clr[1] = getcolour(255, 0, 255);			/* Magenta */
	gr_clr[2] = getcolour(0, 0, 100);			/* Dark Blue */
	gr_clr[3] = getcolour(160, 32, 240);		/* Purple */
	gr_clr[4] = getcolour(0, 100, 0);			/* Dark Green */
	gr_clr[5] = getcolour(100, 100, 100);		/* Grey 1 (dark?) */
	gr_clr[6] = getcolour(0, 0, 205);			/* Medium Blue */
	gr_clr[7] = getcolour(173, 216, 230);		/* Light Blue */
	gr_clr[8] = getcolour(165, 42, 42);			/* Brown */
	gr_clr[9] = getcolour(255, 165, 0);			/* Orange */
	gr_clr[10] = getcolour(211, 211, 211);		/* Grey 2 (light?) */
	gr_clr[11] = getcolour(255, 192, 203);		/* Pink */
	gr_clr[12] = getcolour(50, 205, 50);		/* Light Green */
	gr_clr[13] = getcolour(255, 255, 0);		/* Yellow */
	gr_clr[14] = getcolour(127, 255, 212);		/* Aquamarine */
	gr_clr[15] = white = getcolour(255, 255, 255);

	/* there are prob. better (or more accurate) RGB values for these */
	/* (maybe they correspond to one of the low-res colours? */
	green = getcolour(0, 255, 0);
	blue = getcolour(0, 0, 255);
	red = getcolour(255, 0, 0);
	violet = getcolour(238, 130, 238);
}

int getcolour(r, g, b)
int r,g,b;
{
	XColor	c;

	c.red = r * 256;
	c.green = g * 256;
	c.blue = b * 256;
	if (!XAllocColor(display, colormap, &c))
		err("can't get a colour");
	
	return c.pixel;
}

int text_mono_sm();
int gr_mono_sm();
int hgr_mono_sm();

int hgr_mono_big();

int text_color_sm();
int gr_color_sm();
int hgr_color_sm();

makewin(width, height, scrn)
int					width;
int					height;
struct applescreen*	scrn;
{
	unsigned char*	imdata;
	Window		root;
	int			image_format;
	int			image_datasize;
	int			image_depth;

	scrn->disp = display;
    root = RootWindow(display, screen);
    scrn->gc = DefaultGC(display, screen);
    fcol = WhitePixel(display, screen);
    bcol = BlackPixel(display, screen);
    visual = DefaultVisual(display, screen);

	if (monochrome) {
		image_format = XYPixmap;
		image_datasize = ((width + 7) / 8) * height;
		image_depth = 1;

		if (display_small) {
			scrn->text = text_mono_sm;
			scrn->gr = gr_mono_sm;
			scrn->hgr = hgr_mono_sm;
		}
		else {
			scrn->text = 0;
			scrn->gr = 0;
			scrn->hgr = hgr_mono_big;
		}
	}
	else {
		image_format = ZPixmap;
		image_datasize = width * height;
		image_depth = 8;
		if (display_small) {
			scrn->text = text_color_sm;
			scrn->gr = gr_color_sm;
			scrn->hgr = hgr_color_sm;
		}
		else {
			scrn->text = 0;
			scrn->gr = 0;
			scrn->hgr = 0;
		}
	}
	scrn->width = width;
	scrn->height = height;

	/* I should use this and the black and white pixel colours in my
	 * table initialization...
	 */
/*    bitmap_bit_order = BitmapBitOrder(theDisp); */

	if (!(mfinfo = XLoadQueryFont(display, "5x8")))
		err("couldn't open 5x8\n");

    mfont = mfinfo->fid;
    XSetFont(display, scrn->gc, mfont);

    XSetForeground(display, scrn->gc, fcol);
    XSetBackground(display, scrn->gc, bcol);
    XSetFunction(display, scrn->gc, GXcopy);

	XSetGraphicsExposures(display, scrn->gc, 0);

    scrn->dwin = XCreateSimpleWindow(display, root, 0, 0,
		width, height, 0, 0, bcol);

	if (!(imdata = (unsigned char*)malloc(image_datasize)))
		err("no memory");


    scrn->image = XCreateImage(display, visual, image_depth,
		image_format, 0, imdata, width, height, 8, 0);

	if (!scrn->dwin || !scrn->image)
		err("Unable to create display window");

	XSelectInput(display, scrn->dwin,
		ExposureMask | KeyPressMask | ButtonPressMask |
		ButtonReleaseMask | StructureNotifyMask);
	XMapWindow(display, scrn->dwin);
}

/*
winset(n)
int	n;
{
	int	i;
	int	j;
	char*	q;

	q = image->data;

	for (i = 0; i < height; i++)
		for (j = 0; j < image->bytes_per_line; j++)
			*q++ = n;
	
	XPutImage(disp, dwin, gc, image, 0, 0, 0, 0, width, height);
}
*/

void eloop()
{
	XEvent event;
	enum disp_mode old_mode = screen_mode;
	KeySym	keysym;
	static XComposeStatus composestatus;
	char str[2];
	int	len;
	int	key;

	screen_mode = calc_mode();
	if (screen_mode != old_mode)
		show_screen_mode();
	
	switch (screen_mode) {
	case Text0:		text(&aps, text1, 0, 23); break;
	case Text1:		text(&aps, text2, 0, 23); break;
	case Low0:		gr(&aps, text1, 0, 23); break;
	case Low1:		gr(&aps, text2, 0, 23); break;
	case Mixlow0:	gr(&aps, text1, 0, 19); text(&aps, text1, 20, 23); break;
	case Mixlow1:	gr(&aps, text2, 0, 19); text(&aps, text2, 20, 23); break;
	case High0:		hgr(&aps, hgr0_addr, 192); break;
	case High1:		hgr(&aps, hgr1_addr, 192); break;
	case Mixhigh0:	hgr(&aps, hgr0_addr, 160); text(&aps, text1, 20, 23); break;
	case Mixhigh1:	hgr(&aps, hgr1_addr, 160); text(&aps, text2, 20, 23); break;
	}

	XPutImage(display, aps.dwin, aps.gc, aps.image,
		0, 0, 0, 0, aps.width, aps.height);

	XFlush(display);
	while (XEventsQueued(display, QueuedAfterReading)) {
		XNextEvent(display, &event);
		if (event.type == KeyPress) {
			len = XLookupString(&event, str, 1, &keysym, &composestatus);
			key = str[0];
			if (key == 127)
				key = 8;
			else if (key == '\n')
				key == '\r';
			else if (key == '[')
				key = 8;
			else if (key == ']')
				key = 21;
			if (map_to_upper)
				key = toupper(key);
			mem[0xc000] = key | 0x80;
		}
	}
	flashon = !flashon;
	ualarm(poll_interval, 0);
}

text(scrn, text_addr, l0, l1)
struct applescreen*	scrn;
int					text_addr[];
int					l0;
int					l1;
{
	if (scrn->text)
		(*scrn->text)(scrn, text_addr, l0, l1);
}

gr(scrn, text_addr, l0, l1)
struct applescreen*	scrn;
int					text_addr[];
int					l0;
int					l1;
{
	if (scrn->gr)
		(*scrn->gr)(scrn, text_addr, l0, l1);
}

hgr(scrn, line_addr, lines)
struct applescreen*	scrn;
int	line_addr[];
int	lines;
{
	if (scrn->hgr)
		(*scrn->hgr)(scrn, line_addr, lines);
}

hgr_mono_sm(scrn, line_addr, lines)
struct applescreen* scrn;
int	line_addr[];
int	lines;
{
	unsigned char*	q = scrn->image->data;
	unsigned char*	p;
	unsigned char	c0,c1,c2,c3,c4,c5,c6,c7;
	int	i;
	int	j;

#define G(x)	reverse_cpl[x]

	for (i = 0; i < lines; i++) {
		p = mem + line_addr[i];
		for (j = 0; j < 5; j++) {
			c0 = G(*p++); c1 = G(*p++); c2 = G(*p++); c3 = G(*p++);
			c4 = G(*p++); c5 = G(*p++); c6 = G(*p++); c7 = G(*p++);
			*q++ = (c0 << 1) | (c1 >> 6);
			*q++ = (c1 << 2) | (c2 >> 5);
			*q++ = (c2 << 3) | (c3 >> 4);
			*q++ = (c3 << 4) | (c4 >> 3);
			*q++ = (c4 << 5) | (c5 >> 2);
			*q++ = (c5 << 6) | (c6 >> 1);
			*q++ = (c6 << 7) | c7;
		}
	}
}

text_mono_sm(scrn, line_addr, line0, line1)
struct applescreen*	scrn;
int					line_addr[];
int					line0;
int					line1;
{
	unsigned char* cset;

	cset = flashon ? textflashon : textflashoff;
	text_gr_mono_sm(&aps, line_addr, line0, line1, cset, cset);
}

gr_mono_sm(scrn, line_addr, line0, line1)
struct applescreen*	scrn;
int					line_addr[];
int					line0;
int					line1;
{
	text_gr_mono_sm(&aps, line_addr, line0, line1, grseteven, grsetodd);
}

text_gr_mono_sm(scrn, line_addr, line0, line1, even_cset, odd_cset)
struct applescreen* scrn;
int	line_addr[];
int	line0;
int	line1;
unsigned char even_cset[];
unsigned char odd_cset[];
{
	unsigned char*	q;
	unsigned char*	p;
	unsigned char*	r;
	int				i;
	unsigned char	p0,p1,p2,p3,p4,p5,p6,p7;

#define ln(x)	q[(x) * scrn->image->bytes_per_line]
#define l0	ln(0)
#define l1	ln(1)
#define l2	ln(2)
#define l3	ln(3)
#define l4	ln(4)
#define l5	ln(5)
#define l6	ln(6)
#define l7	ln(7)
#define l_prevorcur_p_newr(exp1, exp2)	\
	l0 = p0 | exp1; p0 = exp2;	\
	l1 = p1 | exp1; p1 = exp2;	\
	l2 = p2 | exp1; p2 = exp2;	\
	l3 = p3 | exp1; p3 = exp2;	\
	l4 = p4 | exp1; p4 = exp2;	\
	l5 = p5 | exp1; p5 = exp2;	\
	l6 = p6 | exp1; p6 = exp2;	\
	l7 = p7 | exp1; p7 = exp2

	q = scrn->image->data + line0 * 8 * scrn->image->bytes_per_line;

	for (; line0 <= line1; line0++) {
		p = mem + line_addr[line0];
		for (i = 0; i < 5; i++) {
			/* 1 of 8 */
			r = even_cset + *p++ * 8;
			p0 = (*r++ << 1);
			p1 = (*r++ << 1);
			p2 = (*r++ << 1);
			p3 = (*r++ << 1);
			p4 = (*r++ << 1);
			p5 = (*r++ << 1);
			p6 = (*r++ << 1);
			p7 = (*r++ << 1);
			/* 2 of 8 */
			r = odd_cset + *p++ * 8;
			l_prevorcur_p_newr((*r >> 6), (*r++ << 2));
			q++;
			/* 3 of 8 */
			r = even_cset + *p++ * 8;
			l_prevorcur_p_newr((*r >> 5), (*r++ << 3));
			q++;
			/* 4 of 8 */
			r = odd_cset + *p++ * 8;
			l_prevorcur_p_newr((*r >> 4), (*r++ << 4));
			q++;
			/* 5 of 8 */
			r = even_cset + *p++ * 8;
			l_prevorcur_p_newr((*r >> 3), (*r++ << 5));
			q++;
			/* 6 of 8 */
			r = odd_cset + *p++ * 8;
			l_prevorcur_p_newr((*r >> 2), (*r++ << 6));
			q++;
			/* 7 of 8 */
			r = even_cset + *p++ * 8;
			l_prevorcur_p_newr((*r >> 1), (*r++ << 7));
			q++;
			/* 8 of 8 */
			r = odd_cset + *p++ * 8;
			l0 = p0 | *r++;
			l1 = p1 | *r++;
			l2 = p2 | *r++;
			l3 = p3 | *r++;
			l4 = p4 | *r++;
			l5 = p5 | *r++;
			l6 = p6 | *r++;
			l7 = p7 | *r++;
			q++;
		}
		q += scrn->image->bytes_per_line * 7;
	}
}

hgr_mono_big(scrn, line_addr, lines)
struct applescreen* scrn;
int	line_addr[];
int	lines;
{
	unsigned char*	q = scrn->image->data;
	unsigned char*	r;
	unsigned char*	p;
	unsigned char	aprev, a0, a1, a2, a3, a4;
	int	i;
	int	j;
	int	l;

#define do4()	\
			*q++ = b1_tab[l = (a0 & 0x9f) | (aprev & 0x40)];		\
			*r++ = b1_tab_2[l];										\
			*q++ = b2_tab[l = ((a0 >> 1) & 0x7c) | (a1 & 0x83)];	\
			*r++ = b2_tab_2[l];										\
			*q++ = b3_tab[a1];										\
			*r++ = b3_tab_2[a1];									\
			*q++ = b4_tab[l = ((a1 >> 1) & 0x78) | (a2 & 0x87)];	\
			*r++ = b4_tab_2[l];										\
			*q++ = b5_tab[a2];										\
			*r++ = b5_tab_2[a2];									\
			*q++ = b6_tab[l = ((a2 >> 1) & 0x70) | (a3 & 0x8f)];	\
			*r++ = b6_tab_2[l];										\
			*q++ = b7_tab[l = (a3 & 0xfc) | (a4 & 0x01)];			\
			*r++ = b7_tab_2[l]

	r = q + scrn->image->bytes_per_line;
	for (i = 0; i < lines; i++) {
		p = mem + line_addr[i];
		aprev = '\0';
		for (j = 0; j < 9; j++) {
			a0 = *p++; a1 = *p++; a2 = *p++; a3 = *p++; a4 = *p;
			do4();
			aprev = a3;
		}
		a0 = *p++; a1 = *p++; a2 = *p++; a3 = *p++; a4 = '\0';
		do4();

		q += scrn->image->bytes_per_line;
		r += scrn->image->bytes_per_line;
	}
}

hgr_color_sm(scrn, line_addr, lines)
struct applescreen* scrn;
int	line_addr[];
int	lines;
{
	int*	q = (int*)scrn->image->data;
	unsigned char*	p;
	unsigned char	aprev, a0, a1, a2, a3, a4;
	int	i;
	int	j;
	int	l;

#define cdo4()	\
			*q++ = cb1_tab[l = (a0 & 0x9f) | (aprev & 0x40)];		\
			*q++ = cb2_tab[l = ((a0 >> 1) & 0x7c) | (a1 & 0x83)];	\
			*q++ = cb3_tab[a1];										\
			*q++ = cb4_tab[l = ((a1 >> 1) & 0x78) | (a2 & 0x87)];	\
			*q++ = cb5_tab[a2];										\
			*q++ = cb6_tab[l = ((a2 >> 1) & 0x70) | (a3 & 0x8f)];	\
			*q++ = cb7_tab[l = (a3 & 0xfc) | (a4 & 0x01)]

	for (i = 0; i < lines; i++) {
		p = mem + line_addr[i];
		aprev = '\0';
		for (j = 0; j < 9; j++) {
			a0 = *p++; a1 = *p++; a2 = *p++; a3 = *p++; a4 = *p;
			cdo4();
			aprev = a3;
		}
		a0 = *p++; a1 = *p++; a2 = *p++; a3 = *p++; a4 = '\0';
		cdo4();
	}
}

text_color_sm(scrn, line_addr, line0, line1)
struct applescreen*	scrn;
int					line_addr[];
int					line0;
int					line1;
{
	unsigned char** cset;
	unsigned char*	p;
	unsigned char*	q;
	unsigned char	*r0, *r1, *r2, *r3, *r4, *r5, *r6, *r7;
	int				i, j;

	cset = flashon ? textfon_8 : textfoff_8;

	r0 = scrn->image->data + line0 * 8 * scrn->image->bytes_per_line;
	r1 = r0 + scrn->image->bytes_per_line;
	r2 = r1 + scrn->image->bytes_per_line;
	r3 = r2 + scrn->image->bytes_per_line;
	r4 = r3 + scrn->image->bytes_per_line;
	r5 = r4 + scrn->image->bytes_per_line;
	r6 = r5 + scrn->image->bytes_per_line;
	r7 = r6 + scrn->image->bytes_per_line;
	for (; line0 <= line1; line0++) {
		p = mem + line_addr[line0];
		for (i = 0; i < 40; i++) {
			q = cset[*p++];
			for (j = 0; j < 7; j++) *r0++ = *q++;
			for (j = 0; j < 7; j++) *r1++ = *q++;
			for (j = 0; j < 7; j++) *r2++ = *q++;
			for (j = 0; j < 7; j++) *r3++ = *q++;
			for (j = 0; j < 7; j++) *r4++ = *q++;
			for (j = 0; j < 7; j++) *r5++ = *q++;
			for (j = 0; j < 7; j++) *r6++ = *q++;
			for (j = 0; j < 7; j++) *r7++ = *q++;
		}
		r0 += scrn->image->bytes_per_line * 7;
		r1 += scrn->image->bytes_per_line * 7;
		r2 += scrn->image->bytes_per_line * 7;
		r3 += scrn->image->bytes_per_line * 7;
		r4 += scrn->image->bytes_per_line * 7;
		r5 += scrn->image->bytes_per_line * 7;
		r6 += scrn->image->bytes_per_line * 7;
		r7 += scrn->image->bytes_per_line * 7;
	}
}

gr_color_sm(scrn, line_addr, line0, line1)
struct applescreen*	scrn;
int					line_addr[];
int					line0;
int					line1;
{
	unsigned char*	p;
	unsigned char*	q;
	unsigned char	*r0, *r1, *r2, *r3, *r4, *r5, *r6, *r7;
	int				i, j;
	int				colour;

	r0 = scrn->image->data + line0 * 8 * scrn->image->bytes_per_line;
	r1 = r0 + scrn->image->bytes_per_line;
	r2 = r1 + scrn->image->bytes_per_line;
	r3 = r2 + scrn->image->bytes_per_line;
	r4 = r3 + scrn->image->bytes_per_line;
	r5 = r4 + scrn->image->bytes_per_line;
	r6 = r5 + scrn->image->bytes_per_line;
	r7 = r6 + scrn->image->bytes_per_line;
	for (; line0 <= line1; line0++) {
		p = mem + line_addr[line0];
		for (i = 0; i < 40; i++) {
			colour = gr_clr[*p & 0x0f];
			for (j = 0; j < 7; j++) *r0++ = colour;
			for (j = 0; j < 7; j++) *r1++ = colour;
			for (j = 0; j < 7; j++) *r2++ = colour;
			for (j = 0; j < 7; j++) *r3++ = colour;
			colour = gr_clr[*p++ >> 4];
			for (j = 0; j < 7; j++) *r4++ = colour;
			for (j = 0; j < 7; j++) *r5++ = colour;
			for (j = 0; j < 7; j++) *r6++ = colour;
			for (j = 0; j < 7; j++) *r7++ = colour;
		}
		r0 += scrn->image->bytes_per_line * 7;
		r1 += scrn->image->bytes_per_line * 7;
		r2 += scrn->image->bytes_per_line * 7;
		r3 += scrn->image->bytes_per_line * 7;
		r4 += scrn->image->bytes_per_line * 7;
		r5 += scrn->image->bytes_per_line * 7;
		r6 += scrn->image->bytes_per_line * 7;
		r7 += scrn->image->bytes_per_line * 7;
	}
}

err(s) char* s; { fprintf(stderr, "%s\n", s); exit(1); }
SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'main.c'" '(4684 characters)'
if test -f 'main.c'
then
	echo shar: will not over-write existing file "'main.c'"
else
cat << \SHAR_EOF > 'main.c'
/*
 *  a2, an Apple II emulator in C
 *  (c) Copyright 1990 by Rich Skrenta
 *
 *  Command line interface written by Tom Markson
 *
 *  Distribution agreement:
 *
 *	You may freely copy or redistribute this software, so long
 *	as there is no profit made from its use, sale, trade or
 *	reproduction.  You may not change this copyright notice,
 *	and it must be included prominently in any copy made.
 *
 *  Send emulator related mail to:  skrenta@blekko.commodore.com
 *				    skrenta@blekko.uucp
 */



#include	<stdio.h>
#include	<signal.h>
#include	<fcntl.h>
#include	"a2.h"


int save_flags;			/* terminal flags */
char escape_char = '~';

unsigned short Pc;
unsigned char Sp = 0xFF;	/* stack pointer 	*/
unsigned int  A = 0;		/* accumulator		*/
unsigned char X = 0;		/* X register		*/
unsigned char Y = 0;		/* Y register		*/

unsigned int N = 0;		/* 7 - sign		*/
unsigned int V = 0;		/* 6 - Overflow		*/
				/* 5 - Unused		*/
unsigned int B = 1;		/* 4 - Break		*/
unsigned int D = 0;		/* 3 - Decimal		*/
unsigned int I = 0;		/* 2 - Interrupt	*/
unsigned int NZ = 1;		/* 1 - Zero		*/
unsigned int C = 0;		/* 0 - Carry		*/

int term_lines, term_cols;
int running = TRUE;
int tracing = FALSE;

int disk[] = {-1, -1};
int write_prot[2];
int drive = 0;

extern int display_small;

main(argc, argv)
int argc;
char **argv;
{
int c;
int errflag = 0;
char *f8rom, *d0rom;
int cli_first = FALSE;
int jumps = TRUE;

	safety_check();
	f8rom = "AUTOSTART.ROM";
	d0rom = "APPLESOFT.ROM";

	while ((c = getopt(argc, argv, "cimjbs")) != -1) {
		switch (c) {
		case 'c':
			cli_first = TRUE;
			break;

		case 'i':
			d0rom = "INTEGER.ROM";
			break;
		
		case 'j':
			jumps = FALSE;
			break;

		case 'm':
			f8rom = "MONITOR.ROM";
			break;
		
		case 's':
			display_small = 1;
			break;
		case 'b':
			display_small = 0;
			break;

		case '?':
		default:
			errflag++;
		}
	}

	if (errflag) {
		fprintf(stderr, "usage:  %s\n", argv[0]);
fprintf(stderr, "\t-m\tLoad MONITOR.ROM instead of AUTOSTART.ROM at $F800\n");
fprintf(stderr, "\t-i\tLoad INTEGER.ROM instead of APPLESOFT.ROM at $D000\n");
fprintf(stderr, "\t-c\tEnter command mode before executing any instructions\n");
		exit(1);
	}

	printf("a2 -- Apple II emulator.  Escape character is %c\n",
								escape_char);

	if (!bload(f8rom, 0xF800))
		exit(1);
	bload(d0rom, 0xD000);
	bload("DISK.PROM", 0xC600);

	if (!InitScreen())
		exit(1);
	ScreenSize(&term_lines, &term_cols);

	memory_setup();
	set_special_jumps(jumps);
	Pc = join(mem[0xFFFC], mem[0xFFFD]);

	if (cli_first)
		cli();
	else
		ClearScreen();
	while (1) {
		set_term();
		run();
		cli();
	}
}


restore_term() {

/*	SetNormal();				/* Turn off inverse video */
	Raw(FALSE);
	fcntl(0, F_SETFL, save_flags);
	signal(SIGINT, SIG_DFL);
}


set_term() {
int catch_intr();
int cleanup();

	signal(SIGINT, catch_intr);
	signal(SIGQUIT, cleanup);
	signal(SIGTERM, cleanup);
	save_flags = fcntl(0, F_GETFL, 0);
	Raw(TRUE);
}


cleanup() {

	restore_term();
	exit(0);
}


catch_intr() {

	signal(SIGINT, catch_intr);
	running = FALSE;
	tracing = FALSE;
}


bload(fnam, addr)
char *fnam;
unsigned short addr;
{
int fd;
long len;

	fd = open(fnam, O_RDONLY);
	if (fd < 0) {
		fprintf(stderr, "can't open %s: ", fnam);
		perror("");
		return(FALSE);
	}

	len = 65536 - addr;

	if (len == 65536) {		/* stupid $%!*&#~ 16 bit systems */
		if (read(fd, &mem[addr], 4096) < 0) {
			fprintf(stderr, "bad read of %s: ", fnam);
			perror("");
			return(FALSE);
		}

		addr += 4096;
		len -= 4096;
	}

	if (read(fd, &mem[addr], len) < 0) {
		fprintf(stderr, "bad read of %s: ", fnam);
		perror("");
		return(FALSE);
	}

	close(fd);
	return(TRUE);
}

bsave(fnam, addr, size)
char *fnam;
unsigned short addr,size;
{
	int fd;
	unsigned sizel;
	int x;
	sizel=size;
	if (sizel==0) sizel=65535;
	fd=open(fnam,O_WRONLY|O_CREAT,0644);
	if (fd < 0) {
		printf("can't open %s: ", fnam);
		perror("");
		return;
	}
	x=write(fd,&mem[addr],sizel);
	if (size == 0)
		x=write(fd,&mem[65535],1);
	if (x==-1) perror("write");
	close(fd);
}


/*
 *  I make certain assumptions about rollover so that I can do
 *  things like X++ and know that if X is 0xFF it will rollover
 *  to 0x00.  If I didn't know this I'd have to do X = (X+1) & 0xFF
 *  If your machine assert fails on the code below you'll have to
 *  rewrite the code that depends on rollover
 */

safety_check() {
unsigned char c;
unsigned short s;

	c = 0xFF;
	assert(++c == 0x00);
	assert(--c == 0xFF);

	s = 0xFFFF;
	assert(++s == 0x0000);
	assert(--s == 0xFFFF);
}


asfail(file, line, cond)
char	*file;
int	line;
char	*cond;
{
	fprintf(stderr, "assertion failure: %s (%d): %s\n", file, line, cond);
	restore_term();
	abort();
	exit(1);
}

SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'cli.h'" '(1202 characters)'
if test -f 'cli.h'
then
	echo shar: will not over-write existing file "'cli.h'"
else
cat << \SHAR_EOF > 'cli.h'
/*
 *  a2, an Apple II emulator in C
 *  (c) Copyright 1990 by Rich Skrenta
 *
 *  Command line interface written by Tom Markson
 *
 *  Distribution agreement:
 *
 *	You may freely copy or redistribute this software, so long
 *	as there is no profit made from its use, sale, trade or
 *	reproduction.  You may not change this copyright notice,
 *	and it must be included prominently in any copy made.
 *
 *  Send emulator related mail to:  skrenta@blekko.commodore.com
 *				    skrenta@blekko.uucp
 */



/*
 *  Return codes for match(), find_box(), and parse()
 */

#define		NO_MATCH	-1	/* strings are different */
#define		PARTIAL		-3	/* partial match */
#define		IDENTICAL	-4	/* strings matched perfectly */

#define		AMBIGUOUS	-2	/* amiguous match */
#define		OK		-5	/* command executed ok */
#define		NOT_IMPLEMENTED	-6	/* haven't written this one yet */
#define		DISPLAY		-7	/* redisplay the diss & flags line */

#define MAXSTACK 100

struct cmdtbl {
	char *name;
	int (*func)();
};

extern long breakpoint;
extern struct cmdtbl first_tbl[];
extern int in_cli;
extern long trace_lo, trace_hi;
extern long get_hex_number();
extern FILE *logging_fp;
extern char *getenv();
extern char *split();

SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'a2.readme'" '(162 characters)'
if test -f 'a2.readme'
then
	echo shar: will not over-write existing file "'a2.readme'"
else
cat << \SHAR_EOF > 'a2.readme'
run the emulator:

	./a2

interrupt with ~, and insert the sample disk

>>> insert Samp.disk
>>> c

Then type 6 ctrl-P to boot the sample disk from the monitor.

SHAR_EOF
fi # end of overwriting check
#	End of shell archive
exit 0

From cbmvax!cs!phillips Thu Aug  1 07:44 EDT 1991
Received: by blekko.commodore.com; Thu,  1 Aug 1991 07:44 EDT
Received: by cbmvax.cbm.commodore.com (5.57/UUCP-Project/Commodore 2/8/91)
	id AA00195; Thu, 1 Aug 91 07:35:26 EDT
Received: from grolsch.cs.ubc.ca by rutgers.edu (5.59/SMI4.0/RU1.4/3.08) 
	id AA10481; Thu, 1 Aug 91 06:09:19 EDT
Received: by grolsch.cs.ubc.ca id AA17766
  (5.65c/IDA-1.3.5 for skrenta@blekko.commodore.com); Tue, 30 Jul 1991 14:52:40 -0700
Date: 30 Jul 91 14:52 -0700
From: George Phillips <cbmvax!cs.ubc.ca!phillips>
To: Rich Skrenta <blekko!skrenta>
Message-Id: <2604*phillips@cs.ubc.ca>
Subject: a2.shar.3
Content-Type: text
Content-Length: 31408
Status: O

#! /bin/sh
# This is a shell archive, meaning:
# 1. Remove everything above the #! /bin/sh line.
# 2. Save the resulting text in a file.
# 3. Execute the file with /bin/sh (not csh) to create the files:
#	commands.c
#	table.c
#	a2.h
#	mapper.c
#	hex.c
# This archive created: Tue Jul 30 14:43:10 1991
export PATH; PATH=/bin:$PATH
echo shar: extracting "'commands.c'" '(13825 characters)'
if test -f 'commands.c'
then
	echo shar: will not over-write existing file "'commands.c'"
else
cat << \SHAR_EOF > 'commands.c'
/*
 *  a2, an Apple II emulator in C
 *  (c) Copyright 1990 by Rich Skrenta
 *
 *  Command line interface written by Tom Markson
 *
 *  Distribution agreement:
 *
 *	You may freely copy or redistribute this software, so long
 *	as there is no profit made from its use, sale, trade or
 *	reproduction.  You may not change this copyright notice,
 *	and it must be included prominently in any copy made.
 *
 *  Send emulator related mail to:  skrenta@blekko.commodore.com
 *				    skrenta@blekko.uucp
 */


#include	<stdio.h>
#include	<ctype.h>
#include	<signal.h>
#include	"a2.h"
#include	"cli.h"


extern unsigned short lpoint;
extern long phantom_location;
extern char *getcwd();
extern int map_to_upper;
extern char escape_char;
long get_hex_number();

char diskname[2][200];		/* disk names stored here */

struct point_stack {
	unsigned short data[MAXSTACK];
	int sp;
} pstack;

init_point(){
	pstack.sp = -1;
}

pop_point(rest)
char *rest;
{
	if (pstack.sp < 0 ) {
		printf("stack empty\n");
		return OK;
	}
	switch (*rest){
		case 'l':
		case 'L':
			printf("%x\n", lpoint = pstack.data[pstack.sp--]);
			break;
		case 'p':
		case 'P':
			printf("%x\n", lpoint = pstack.data[pstack.sp--]);
			break;
		default : 
			printf("pop [lp]\n");
			break;
	}
	return(OK);
}

dup_point(rest)
char *rest;
{
	if (pstack.sp < 0 ) {
		printf("stack empty\n");
		return OK;
	}
	switch (*rest){
		case 'l':
		case 'L':
			lpoint = pstack.data[pstack.sp];
			break;
		case 'p':
		case 'P':
			lpoint = pstack.data[pstack.sp];
			break;
		default : 
			printf("dup [lp]\n");
			break;
	}
	return(OK);
}

push_point(rest)
char *rest;
{
	long value;
	char *addr;

	assert (pstack.sp < MAXSTACK);
	switch (*rest){
		case 'l':
		case 'L':
			pstack.data[++pstack.sp] = lpoint;
			break;
		case 'p':
		case 'P':
			pstack.data[++pstack.sp] = Pc;
			break;
		default:
			addr = rest;
			rest = split(rest);
			value = get_hex_number(addr);
			if (value == -1L) 
				printf("push [l|p|<addr>]\n");
			else 
				pstack.data[++pstack.sp]=(unsigned short)value;
			break;
	}
	return(OK);
}


clb(junk)
char *junk;
{

	B = 0;
	return(DISPLAY);
}


seb(junk)
char *junk;
{

	B = 1;
	return(DISPLAY);
}


clc(junk)
char	*junk;
{
	C = 0;
	return(DISPLAY);
}


sec(junk)
char	*junk;
{
	C = 1;
	return(DISPLAY);
}


sev(junk)
char	*junk;
{
	V = 1;
	return(DISPLAY);
}


clv(junk)
char	*junk;
{
	V = 0;
	return(DISPLAY);
}


sed(junk)
char	*junk;
{
	D = 1;
	return(DISPLAY);
}


cld(junk)
char	*junk;
{
	D = 0;
	return(DISPLAY);
}


sei(junk)
char	*junk;
{
	I = 1;
	return(DISPLAY);
}


clri(junk)
char	*junk;
{
	I = 0;
	return(DISPLAY);
}


sen(junk)
char	*junk;
{
	N = 1;
	return(DISPLAY);
}


cln(junk)
char	*junk;
{
	N = 0;
	return(DISPLAY);
}


sez(junk)
char	*junk;
{
	NZ = 0;
	return(DISPLAY);
}


clz(junk)
char	*junk;
{
	NZ = 1;
	return(DISPLAY);
}


quit_emulator(junk)
char	*junk;
{
	exit(0);
}



ver(junk)
char	*junk;
{
	printf("a2 - Apple II emulator  (c) Copyright 1990 by Rich Skrenta & Tom Markson\n");
	return(OK);
}


refresh(junk)
char	*junk;
{

	in_cli = FALSE;
	return(OK);
}


shell_escape(rest)
char	*rest;
{
	char	line[100];
	char *s;

	s = getenv("SHELL");
	if (s == NULL)
		s = "/bin/sh";

	strcpy(line, s);

	if (*rest != '\0') {
		strcat(line, " -c '");
		strcat(line, rest);
		strcat(line, "'");
	}
	system(line);

	printf("\n");
	return(OK);
}


do_soft_reset(rest)
char	*rest;
{

	Pc = mem[0xFFFC] | (mem[0xFFFD] << 8);
	return(DISPLAY);
}


do_bload(rest)
char	*rest;
{
	char	*first;
	char	*file;
	unsigned short	start;
	long	foo;

	file = rest;
	rest = split(rest);
	first = rest;
	rest = split(rest);
	foo = get_hex_number(first);
	if (foo == -1) {
		printf("usage: bload file hex-address\n");
		return(OK);
	}
	start = (unsigned int) foo;
	bload(file, start);

	return(OK);
}


do_bsave(rest)
char	*rest;
{
	char	*startc, *sizec, *file;
	unsigned short	start, size;
	long	istart, iend;
	file = rest;
	rest = split(rest);
	startc = rest;
	rest = split(rest);
	sizec = rest;
	rest = split(rest);
	istart = get_hex_number(startc);
	iend = get_hex_number(sizec);
	if ((istart == -1) || (iend == -1))
		printf("usage: bsave file hex-address hex-length\n");
	else {
		start = (unsigned short) istart;
		size  = (unsigned short) iend;
		bsave(file, start, size);
	}

	return(OK);
}



show_point(rest)
char	*rest;
{

	lpoint = Pc;
	return(DISPLAY);
}


hack(rest)
char *rest;
{
extern int cur_track;

	cur_track = get_hex_number(rest);
	return(OK);
}


do_jump(rest)
char	*rest;
{
	char	*start;
	long	istart;
	start = rest;
	rest = split(rest);
	istart = get_hex_number(start);

	if (istart == -1) {
		printf("usage: jmp <hex address>\n");
		return(OK);
	} else {
		Pc = istart & 0xFFFF;
		return(DISPLAY);
	}
}



trace(rest)
char	*rest;
{
	char	*addr1, *addr2, *file;
	long	addr1i, addr2i;

	addr1 = rest;
	rest = split(rest);
	addr2 = rest;
	rest = split(rest);
	file = rest;
	rest = split(rest);
	addr1i = get_hex_number(addr1);
	addr2i = get_hex_number(addr2);
	if (addr1i == -1 && addr2i == -1) {
		if (trace_lo == -1)
			printf("No trace region set\n");
		else
			printf("Tracing between $%.4X and $%.4x\n",
							trace_lo, trace_hi);
		return(OK);
	}

	if (addr1i == -1 || addr2i == -1) {
		printf("usage: trace [low high]\n");
		return(OK);
	}

	if (logging_fp == NULL) {
		if (*file == '\0' || file == NULL) {
			printf("Trace log will go to file 'trace'.\n");
			file = "trace";
		}
		logging_fp = fopen(file, "w");
		if (logging_fp == NULL) {
			perror("can't open trace file");
			trace_lo = -1;
			return(OK);
		}
	}

	trace_lo = addr1i & 0xFFFF;
	trace_hi = addr2i & 0xFFFF;

	return(OK);
}


ldx(rest)
char	*rest;
{
	long	number;
	char	*first;

	first = rest;
	rest = split(rest);
	number = get_hex_number(first);

	number &= 0xFF;
	if (number < 0) {
		printf("usage: ldx <hex number>\n");
		return(OK);
	}

	X = number & 0xFF;
	return(DISPLAY);
}


ldy(rest)
char	*rest;
{
	long	number;
	char	*first;
	first = rest;
	rest = split(rest);
	number = get_hex_number(first);

	if (number < 0) {
		printf("usage: ldy <hex number>\n");
		return(OK);
	}

	Y = number & 0xFF;
	return(DISPLAY);
}


lda(rest)
char	*rest;
{
	long	number;
	char	*first;
	first = rest;
	rest = split(rest);
	number = get_hex_number(first);
	if (number < 0) {
		printf("usage: lda <hex number>\n");
		return(OK);
	}

	A = number & 0xFF;
	return(DISPLAY);
}


lds(rest)
char	*rest;
{
	long	number;
	char	*first;
	first = rest;
	rest = split(rest);
	number = get_hex_number(first);
	if (number < 0) {
		printf("usage: lds <hex number>\n");
		return(OK);
	}

	Sp = number & 0xFF;
	return(DISPLAY);
}


set_break_point(rest)
char	*rest;
{	
	long	addr;
	char	*first;
	first = rest;
	rest = split(rest);
	addr = get_hex_number(first);
	if (addr == -1)
		if (breakpoint == -1)
			printf("no breakpoint set\n");
			else
			printf("break point set at %x\n",
			    (unsigned short)breakpoint);
			else
		breakpoint = addr;
	running = FALSE;
	return(OK);
}


clear_break_point(rest)
char	*rest;
{
	breakpoint = -1;
	return(OK);
}


notrace(junk)
char	*junk;
{

	trace_lo = -1;
	if (logging_fp == NULL)
		return(OK);
	else
		fclose(logging_fp);
	logging_fp = NULL;
	return(OK);
}


insert_disk(rest)
char	*rest;
{
	char	*name;
	char	*which;
	int	fd;
	int	read_only = 0;

	name = rest;
	rest = split(rest);
	which = rest;
	rest = split(rest);

	if (name == NULL || *name == '\0') {
		printf("usage: insert <file name> [drive]\n");
		return(OK);
	}

	fd = open(name, 2);		/* attempt open for read/write */
	if (fd >= 0)
		read_only = 0;
	else  {				/* attempt open read only */
		read_only = 1;
		fd = open(name, 0);
	}
	if (fd < 0) {
		fprintf(stderr, "can't open %s: ", name);
		perror("");
		return(OK);
	}

	if (*which == '2')
		drive = 1;
	else
		drive = 0;

	if (disk[drive] >= 0)
		close(disk[drive]);

	strcpy(diskname[drive], name);

	disk[drive] = fd;
	write_prot[drive] = read_only;

	printf("disk %d inserted, %swrite protected\n", drive + 1,
				read_only ? "" : "not ");

	return(OK);
}


dissassemble(rest)
char *rest;
{
	unsigned short start,end;
	long istart;
	long iend;
	int count = 0;
	char *first,*last;

	first = rest;
	rest = split(rest);
	last = rest;
	rest = split(rest);

	istart = get_hex_number(first);
	iend   = get_hex_number(last);
	if (istart != -1)
		lpoint = istart;
	if (iend == -1)
		iend=65537;
	while ( (long) lpoint < iend) {
		lpoint += diss(lpoint, stdout);
		printf("\n");
		count++;
		if (iend == 65537)
			if (count > term_lines-3)
				break;
	}
	return OK;
}

ascii_dump(l,h)
unsigned short l,h;
{
	while (l < h) {
		if (isprint(mem[l]))
			printf("%c",mem[l]);
		else 
			printf(".");
		l++;
	}
}

hex_dump(rest)
char *rest;
{
	char *start,*end;
	unsigned short last, addr,oaddr;
	long iaddr1,iaddr2;
	int count;

	start = rest;
	rest = split(rest);
	end = rest;
	rest = split(rest);
	iaddr1 = get_hex_number( start );
	iaddr2 = get_hex_number( end );

	if (iaddr2 != -1 && iaddr1 > iaddr2)
		return(OK);

	if (iaddr1 != -1)
		lpoint = (unsigned short) iaddr1;
	if (iaddr2 == -1)
		last = lpoint + 1;
	else
		last = (unsigned short) iaddr2 + 1;

	last &= 0xFFFF;

	addr = lpoint;
	count = 0;
	printf("%.4X:  ", addr);
	oaddr = addr;
	do {
		if (count % 16 == 0 && count != 0) {
			ascii_dump(oaddr,addr);
			oaddr = addr;
			printf("\n%.4X:  ", addr);
		}
		printf("%.2X ", mem[addr]);
		addr++;
		count++;
	} while (addr != last);
	while ((count % 16) != 0) {
		printf("   ");  /* 3 spaces dd_ */
		count++;
	}
	ascii_dump(oaddr,addr);
	printf("\n");
	return(OK);
}

deposit(rest)
char *rest;
{
	char *addr;
	char *value;
	unsigned short location;
	long iloc;
	unsigned char val;
	int fired_once;

	addr = rest;
	rest = split(rest);
	fired_once = 0;
	iloc = get_hex_number(addr);
	if (iloc == -1) {
		printf("usage: deposit <addr> <value> [<value>...]\n");
		return(OK);
	}

	location = (unsigned short) iloc;
	do {
		value = rest;
		rest = split(rest);
		val = get_hex_number(value);
		if (val == -1) {
			if (!fired_once)
				printf("Invalid or Missing Hex address\n");
			return OK;
		}
		mem[location++] = val;
		fired_once = 1;
	} while (*rest != '\0');

	return(OK);
}

phantom_trace(rest)
char *rest;
{
	char *phantoms;
	char *addr1s;
	char *addr2s;
	char *file;
	long  phantom;
	long low_val,high_val;
	int err = 0;

	phantoms = rest;
	rest = split(rest);
	addr1s = rest;
	rest = split(rest);
	addr2s = rest;
	rest = split(rest);
	file = rest;
	rest = split(rest);

	phantom = (unsigned short)get_hex_number(phantoms);
	low_val = get_hex_number(addr1s);
	high_val = get_hex_number(addr2s);
	if (*phantoms == '\0') {
		if (phantom_location == -1) {
			printf("The phantom sleeps.");
			if (trace_lo != -1 && trace_hi != -1)
				printf("however, a trace is active.");
			printf("\n");
		} else 
		printf("the phantom waits until Pc = %.4X and then traces from %.4X to %.4X\n",phantom_location,trace_lo,trace_hi);
		return(OK);
	}
	if (low_val == -1 || high_val == -1 || phantom == -1) {
		printf("usage: phantom <addr> <addr> <addr> [file]\n");
		return OK;
	} phantom_location = phantom; trace_lo = low_val; trace_hi = high_val; if (logging_fp == NULL) {
		if (*file == '\0' || file == NULL) {
			printf("the phantom will trace to file 'trace'.\n");
			file = "trace";
		}
		logging_fp = fopen(file, "w");
		if (logging_fp == NULL) {
			perror("can't open trace file");
			trace_lo = -1;
			return(OK);
		}
	}
	return OK;
}

no_phantom_trace(rest)
char *rest;
{
	phantom_location = -1;
	trace_lo = -1;
	printf("the phantom goes to sleep.\n");
	if (logging_fp == NULL)
		return OK;
	fclose(logging_fp);
	logging_fp = NULL;
	return OK;
}

cd(rest)
char *rest;
{

	char *first;
	char path[200];

	first = rest;
	rest = split(rest);
	if (*first != '\0') {
		if (chdir(first)) {
			perror("cd");
			printf("CWD remains ");
		}
	}
	printf("%s\n",getcwd(path,198));
	return OK;
}

map(rest)
char *rest;
{
	map_to_upper = !map_to_upper;
	printf("Uppercase Mapping is %s\n",(map_to_upper)?"On":"Off");
	return OK;
}

sex(rest)
char *rest;
{
	printf("You'll need a real Apple for that sort of thing\n");
	return OK;
}


help(rest)
char *rest;
{
	printf("![command]		Escape to Unix\n");
	printf(".			Display Current Pc Point\n");
	printf("bload file addr		load binary file into mem at addr\n");
	printf("breakpoint [addr]	Set the Breakpoint to addr\n");
	printf("bsave file start end	Save Memory from start to end in file\n");
	printf("cd [directory]		Set/Show Current Working Directory\n");
	printf("cl[cdinvz]		Clear appropriate Status Bit\n");
	printf("continue		Resume Execution of Emulator\n");
	printf("deposit addr [val]+	Put val(s) into addr\n");
	printf("dup [l|p]		duplicate top of stack into l or p\n");
	printf("escape char		set escape char to be char \n");
	printf("examine addr		Display Value in addr\n");
	printf("insert file drive#	Make file disk in drive#\n");
	printf("jmp addr		Make Pc=addr\n");
	printf("ld[asxy] val		Load Register with val\n");
	printf("list [addr] [addr]	Dissassemble at point or addr\n");
	printf("map			Toggle lower -> upper case mapping\n");
	printf("nobreak			Turn off breakpoint\n");
	printf("pop [l|p]		get p or l from top of stack\n");
	printf("push [l|p|<addr>	push l,p, or hex addr on stack\n");
	printf("reset			Pc = Apple Reset Vector\n");
	printf("se[cdinvz]		Set appropriate Status Flag\n");
	printf("trace [addr] [addr]	Trace Between addresses/display trace point\n");
	return OK;
}

set_escape_char(rest)
char *rest;
{
	char c;
	if (*rest != '\0')
		escape_char = *rest;
	printf("escape character is ");
	if (isprint(escape_char))
		printf("%c",(int)escape_char);
	else 
		printf("^%c",(char)escape_char+64);
	printf(" (0x%.2X)",(int)escape_char);
	printf("\n");
	return(OK);
}

disk_names(rest)
char *rest;
{

	printf("drive 1: %s\n", disk[0] >= 0 ? diskname[0] : "empty");
	printf("drive 2: %s\n", disk[1] >= 0 ? diskname[1] : "empty");
	return(OK);
}
SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'table.c'" '(10418 characters)'
if test -f 'table.c'
then
	echo shar: will not over-write existing file "'table.c'"
else
cat << \SHAR_EOF > 'table.c'
/*
 *  a2, an Apple II emulator in C
 *  (c) Copyright 1990 by Rich Skrenta
 *
 *  Command line interface written by Tom Markson
 *
 *  Distribution agreement:
 *
 *	You may freely copy or redistribute this software, so long
 *	as there is no profit made from its use, sale, trade or
 *	reproduction.  You may not change this copyright notice,
 *	and it must be included prominently in any copy made.
 *
 *  Send emulator related mail to:  skrenta@blekko.commodore.com
 *				    skrenta@blekko.uucp
 */



#include	<stdio.h>
#include	"a2.h"



struct op_info opcode[] = {
	{"brk",	M_NONE},	/* 0x0 */
	{"ora",	M_INDX},	/* 0x1 */
	{"",	M_NONE},	/* 0x2 */
	{"",	M_NONE},	/* 0x3 */
	{"tsb",	M_ZP},		/* 0x4 */	/* 65C02 */
	{"ora",	M_ZP},		/* 0x5 */
	{"asl",	M_ZP},		/* 0x6 */
	{"",	M_NONE},	/* 0x7 */
	{"php",	M_NONE},	/* 0x8 */
	{"ora",	M_IMM},		/* 0x9 */
	{"asl",	M_NONE},	/* 0xa */
	{"",	M_NONE},	/* 0xb */
	{"tsb",	M_ABS},		/* 0xc */	/* 65C02 */
	{"ora",	M_ABS},		/* 0xd */
	{"asl",	M_ABS},		/* 0xe */
	{"",	M_NONE},	/* 0xf */
	{"bpl",	M_REL},		/* 0x10 */
	{"ora",	M_INDY},	/* 0x11 */
	{"ora",	M_ZIND},	/* 0x12 */	/* 65C02 */
	{"",	M_NONE},	/* 0x13 */
	{"trb",	M_ZP},		/* 0x14 */	/* 65C02 */
	{"ora",	M_ZPX},		/* 0x15 */
	{"asl",	M_ZPX},		/* 0x16 */
	{"",	M_NONE},	/* 0x17 */
	{"clc",	M_NONE},	/* 0x18 */
	{"ora",	M_ABSY},	/* 0x19 */
	{"ina",	M_NONE},	/* 0x1a */	/* 65C02 */
	{"",	M_NONE},	/* 0x1b */
	{"trb",	M_ABS},		/* 0x1c */	/* 65C02 */
	{"ora",	M_ABSX},	/* 0x1d */
	{"asl",	M_ABSX},	/* 0x1e */
	{"",	M_NONE},	/* 0x1f */
	{"jsr",	M_ABS},		/* 0x20 */
	{"and",	M_INDX},	/* 0x21 */
	{"",	M_NONE},	/* 0x22 */
	{"",	M_NONE},	/* 0x23 */
	{"bit",	M_ZP},		/* 0x24 */
	{"and",	M_ZP},		/* 0x25 */
	{"rol",	M_ZP},		/* 0x26 */
	{"",	M_NONE},	/* 0x27 */
	{"plp",	M_NONE},	/* 0x28 */
	{"and",	M_IMM},		/* 0x29 */
	{"rol",	M_NONE},	/* 0x2a */
	{"",	M_NONE},	/* 0x2b */
	{"bit",	M_ABS},		/* 0x2c */
	{"and",	M_ABS},		/* 0x2d */
	{"rol",	M_ABS},		/* 0x2e */
	{"",	M_NONE},	/* 0x2f */
	{"bmi",	M_REL},		/* 0x30 */
	{"and",	M_INDY},	/* 0x31 */
	{"and",	M_ZIND},	/* 0x32 */	/* 65C02 */
	{"",	M_NONE},	/* 0x33 */
	{"bit",	M_ZPX},		/* 0x34 */	/* 65C02 */
	{"and",	M_ZPX},		/* 0x35 */
	{"rol",	M_ZPX},		/* 0x36 */
	{"",	M_NONE},	/* 0x37 */
	{"sec",	M_NONE},	/* 0x38 */
	{"and",	M_ABSY},	/* 0x39 */
	{"dey",	M_NONE},	/* 0x3a */	/* 65C02 */
	{"",	M_NONE},	/* 0x3b */
	{"bit",	M_ABSX},	/* 0x3c */	/* 65C02 */
	{"and",	M_ABSX},	/* 0x3d */
	{"rol",	M_ABSX},	/* 0x3e */
	{"",	M_NONE},	/* 0x3f */
	{"rti",	M_NONE},	/* 0x40 */
	{"eor",	M_INDX},	/* 0x41 */
	{"",	M_NONE},	/* 0x42 */
	{"",	M_NONE},	/* 0x43 */
	{"",	M_NONE},	/* 0x44 */
	{"eor",	M_ZP},		/* 0x45 */
	{"lsr",	M_ZP},		/* 0x46 */
	{"",	M_NONE},	/* 0x47 */
	{"pha",	M_NONE},	/* 0x48 */
	{"eor",	M_IMM},		/* 0x49 */
	{"lsr",	M_NONE},	/* 0x4a */
	{"",	M_NONE},	/* 0x4b */
	{"jmp",	M_ABS},		/* 0x4c */
	{"eor",	M_ABS},		/* 0x4d */
	{"lsr",	M_ABS},		/* 0x4e */
	{"",	M_NONE},	/* 0x4f */
	{"bvc",	M_REL},		/* 0x50 */
	{"eor",	M_INDY},	/* 0x51 */
	{"eor",	M_ZIND},	/* 0x52 */	/* 65C02 */
	{"",	M_NONE},	/* 0x53 */
	{"",	M_NONE},	/* 0x54 */
	{"eor",	M_ZPX},		/* 0x55 */
	{"lsr",	M_ZPX},		/* 0x56 */
	{"",	M_NONE},	/* 0x57 */
	{"cli",	M_NONE},	/* 0x58 */
	{"eor",	M_ABSY},	/* 0x59 */
	{"phy",	M_NONE},	/* 0x5a */	/* 65C02 */
	{"",	M_NONE},	/* 0x5b */
	{"",	M_NONE},	/* 0x5c */
	{"eor",	M_ABSX},	/* 0x5d */
	{"lsr",	M_ABSX},	/* 0x5e */
	{"",	M_NONE},	/* 0x5f */
	{"rts",	M_NONE},	/* 0x60 */
	{"adc",	M_INDX},	/* 0x61 */
	{"",	M_NONE},	/* 0x62 */
	{"",	M_NONE},	/* 0x63 */
	{"stz",	M_ZP},		/* 0x64 */	/* 65C02 */
	{"adc",	M_ZP},		/* 0x65 */
	{"ror",	M_ZP},		/* 0x66 */
	{"",	M_NONE},	/* 0x67 */
	{"pla",	M_NONE},	/* 0x68 */
	{"adc",	M_IMM},		/* 0x69 */
	{"ror",	M_NONE},	/* 0x6a */
	{"",	M_NONE},	/* 0x6b */
	{"jmp",	M_IND},		/* 0x6c */
	{"adc",	M_ABS},		/* 0x6d */
	{"ror",	M_ABS},		/* 0x6e */
	{"",	M_NONE},	/* 0x6f */
	{"bvs",	M_REL},		/* 0x70 */
	{"adc",	M_INDX},	/* 0x71 */
	{"adc",	M_ZIND},	/* 0x72 */	/* 65C02 */
	{"",	M_NONE},	/* 0x73 */
	{"stz",	M_ZPX},		/* 0x74 */	/* 65C02 */
	{"adc",	M_ZPX},		/* 0x75 */
	{"ror",	M_ZPX},		/* 0x76 */
	{"",	M_NONE},	/* 0x77 */
	{"sei",	M_NONE},	/* 0x78 */
	{"adc",	M_ABSY},	/* 0x79 */
	{"ply",	M_NONE},	/* 0x7a */	/* 65C02 */
	{"",	M_NONE},	/* 0x7b */
	{"jmp",	M_ABINDX},	/* 0x7c */	/* 65C02 */
	{"adc",	M_ABSX},	/* 0x7d */
	{"ror",	M_ABSX},	/* 0x7e */
	{"",	M_NONE},	/* 0x7f */
	{"bra",	M_REL},		/* 0x80 */	/* 65C02 */
	{"sta",	M_INDX},	/* 0x81 */
	{"",	M_NONE},	/* 0x82 */
	{"",	M_NONE},	/* 0x83 */
	{"sty",	M_ZP},		/* 0x84 */
	{"sta",	M_ZP},		/* 0x85 */
	{"stx",	M_ZP},		/* 0x86 */
	{"",	M_NONE},	/* 0x87 */
	{"dey",	M_NONE},	/* 0x88 */
	{"",	M_NONE},	/* 0x89 */
	{"txa",	M_NONE},	/* 0x8a */
	{"",	M_NONE},	/* 0x8b */
	{"sty",	M_ABS},		/* 0x8c */
	{"sta",	M_ABS},		/* 0x8d */
	{"stx",	M_ABS},		/* 0x8e */
	{"",	M_NONE},	/* 0x8f */
	{"bcc",	M_REL},		/* 0x90 */
	{"sta",	M_INDY},	/* 0x91 */
	{"sta",	M_ZIND},	/* 0x92 */	/* 65C02 */
	{"",	M_NONE},	/* 0x93 */
	{"sty",	M_ZPX},		/* 0x94 */
	{"sta",	M_ZPX},		/* 0x95 */
	{"stx",	M_ZPX},		/* 0x96 */
	{"",	M_NONE},	/* 0x97 */
	{"tya",	M_NONE},	/* 0x98 */
	{"sta",	M_ABSY},	/* 0x99 */
	{"txs",	M_NONE},	/* 0x9a */
	{"",	M_NONE},	/* 0x9b */
	{"stz",	M_ABS},		/* 0x9c */	/* 65C02 */
	{"sta",	M_ABSX},	/* 0x9d */
	{"stz",	M_ABSX},	/* 0x9e */	/* 65C02 */
	{"",	M_NONE},	/* 0x9f */
	{"ldy",	M_IMM},		/* 0xa0 */
	{"lda",	M_INDX},	/* 0xa1 */
	{"ldx",	M_IMM},		/* 0xa2 */
	{"",	M_NONE},	/* 0xa3 */
	{"ldy",	M_ZP},		/* 0xa4 */
	{"lda",	M_ZP},		/* 0xa5 */
	{"ldx",	M_ZP},		/* 0xa6 */
	{"",	M_NONE},	/* 0xa7 */
	{"tay",	M_NONE},	/* 0xa8 */
	{"lda",	M_IMM},		/* 0xa9 */
	{"tax",	M_NONE},	/* 0xaa */
	{"",	M_NONE},	/* 0xab */
	{"ldy",	M_ABS},		/* 0xac */
	{"lda",	M_ABS},		/* 0xad */
	{"ldx",	M_ABS},		/* 0xae */
	{"",	M_NONE},	/* 0xaf */
	{"bcs",	M_REL},		/* 0xb0 */
	{"lda",	M_INDY},	/* 0xb1 */
	{"lda",	M_ZIND},	/* 0xb2 */	/* 65C02 */
	{"",	M_NONE},	/* 0xb3 */
	{"ldy",	M_ZPX},		/* 0xb4 */
	{"lda",	M_ZPX},		/* 0xb5 */
	{"ldx",	M_ZPY},		/* 0xb6 */
	{"",	M_NONE},	/* 0xb7 */
	{"clv",	M_NONE},	/* 0xb8 */
	{"lda",	M_ABSY},	/* 0xb9 */
	{"tsx",	M_NONE},	/* 0xba */
	{"",	M_NONE},	/* 0xbb */
	{"ldy",	M_ABSX},	/* 0xbc */
	{"lda",	M_ABSX},	/* 0xbd */
	{"ldx",	M_ABSY},	/* 0xbe */
	{"",	M_NONE},	/* 0xbf */
	{"cpy",	M_IMM},		/* 0xc0 */
	{"cmp",	M_INDX},	/* 0xc1 */
	{"",	M_NONE},	/* 0xc2 */
	{"",	M_NONE},	/* 0xc3 */
	{"cpy",	M_ZP},		/* 0xc4 */
	{"cmp",	M_ZP},		/* 0xc5 */
	{"dec",	M_ZP},		/* 0xc6 */
	{"",	M_NONE},	/* 0xc7 */
	{"iny",	M_NONE},	/* 0xc8 */
	{"cmp",	M_IMM},		/* 0xc9 */
	{"dex",	M_NONE},	/* 0xca */
	{"",	M_NONE},	/* 0xcb */
	{"cpy",	M_ABS},		/* 0xcc */
	{"cmp",	M_ABS},		/* 0xcd */
	{"dec",	M_ABS},		/* 0xce */
	{"",	M_NONE},	/* 0xcf */
	{"bne",	M_REL},		/* 0xd0 */
	{"cmp",	M_INDY},	/* 0xd1 */
	{"cmp",	M_ZIND},	/* 0xd2 */	/* 65C02 */
	{"",	M_NONE},	/* 0xd3 */
	{"",	M_NONE},	/* 0xd4 */
	{"cmp",	M_ZPX},		/* 0xd5 */
	{"dec",	M_ZPX},		/* 0xd6 */
	{"",	M_NONE},	/* 0xd7 */
	{"cld",	M_NONE},	/* 0xd8 */
	{"cmp",	M_ABSY},	/* 0xd9 */
	{"phx",	M_NONE},	/* 0xda */	/* 65C02 */
	{"",	M_NONE},	/* 0xdb */
	{"",	M_NONE},	/* 0xdc */
	{"cmp",	M_ABSX},	/* 0xdd */
	{"dec",	M_ABSX},	/* 0xde */
	{"",	M_NONE},	/* 0xdf */
	{"cpx",	M_IMM},		/* 0xe0 */
	{"sbc",	M_INDX},	/* 0xe1 */
	{"",	M_NONE},	/* 0xe2 */
	{"",	M_NONE},	/* 0xe3 */
	{"cpx",	M_ZP},		/* 0xe4 */
	{"sbc",	M_ZP},		/* 0xe5 */
	{"inc",	M_ZP},		/* 0xe6 */
	{"",	M_NONE},	/* 0xe7 */
	{"inx",	M_NONE},	/* 0xe8 */
	{"sbc",	M_IMM},		/* 0xe9 */
	{"nop",	M_NONE},	/* 0xea */
	{"",	M_NONE},	/* 0xeb */
	{"cpx",	M_ABS},		/* 0xec */
	{"sbc",	M_ABS},		/* 0xed */
	{"inc",	M_ABS},		/* 0xee */
	{"",	M_NONE},	/* 0xef */
	{"beq",	M_REL},		/* 0xf0 */
	{"sbc",	M_INDY},	/* 0xf1 */
	{"sbc",	M_ZIND},	/* 0xf2 */	/* 65C02 */
	{"",	M_NONE},	/* 0xf3 */
	{"",	M_NONE},	/* 0xf4 */
	{"sbc",	M_ZPX},		/* 0xf5 */
	{"inc",	M_ZPX},		/* 0xf6 */
	{"",	M_NONE},	/* 0xf7 */
	{"sed",	M_NONE},	/* 0xf8 */
	{"sbc",	M_ABSY},	/* 0xf9 */
	{"plx",	M_NONE},	/* 0xfa */	/* 65C02 */
	{"",	M_NONE},	/* 0xfb */
	{"",	M_NONE},	/* 0xfc */
	{"sbc",	M_ABSX},	/* 0xfd */
	{"inc",	M_ABSX},	/* 0xfe */
	{"",	M_NONE},	/* 0xff */
};


diss(pc, fp)
unsigned short pc;
FILE *fp;
{
char *s;
int count;
int tmp;
unsigned short addr;
unsigned char one, two, three;

	fprintf(fp, "%.4X:  ", pc);

	addr = pc;
	one = mem[pc++];
	two = mem[pc++];
	three = mem[pc++];

	s = opcode[one].name;

	if (s == NULL || *s == '\0')
		s = "???";

	switch (opcode[one].add_mode) {
		case 0:
			fprintf(fp, "%.2x        %s           ", one, s);
			count = 1;
			break;

		case M_ZP:
			fprintf(fp, "%.2x %.2x     %s  $%.2x      ",
							one, two, s, two);
			count = 2;
			break;

		case M_ZPX:
			fprintf(fp, "%.2x %.2x     %s  $%.2x,X    ",
							one, two, s, two);
			count = 2;
			break;

		case M_ZPY:
			fprintf(fp, "%.2x %.2x     %s  $%.2x,Y    ",
							one, two, s, two);
			count = 2;
			break;

		case M_IND:
			fprintf(fp, "%.2x %.2x %.2x  %s  ($%.4x)  ",
						one, two, three, s,
						join(two, three));
			count = 3;
			break;

		case M_INDX:
			fprintf(fp, "%.2x %.2x     %s  ($%.2x,X)  ",
						one, two, s, two);
			count = 2;
			break;

		case M_INDY:
			fprintf(fp, "%.2x %.2x     %s  ($%.2x),Y  ",
						one, two, s, two);
			count = 2;
			break;

		case M_ABS:
			fprintf(fp, "%.2x %.2x %.2x  %s  $%.4x    ",
						one, two, three, s,
						join(two, three));
			count = 3;
			break;

		case M_ABSX:
			fprintf(fp, "%.2x %.2x %.2x  %s  $%.4x,X  ",
						one, two, three, s,
						join(two, three));
			count = 3;
			break;

		case M_ABSY:
			fprintf(fp, "%.2x %.2x %.2x  %s  $%.4x,Y  ",
						one, two, three, s,
						join(two, three));
			count = 3;
			break;

		case M_IMM:
			fprintf(fp, "%.2x %.2x     %s  #$%.2x     ",
						one, two, s, two);
			count = 2;
			break;

		case M_REL:
			tmp = two;
			if (tmp > 127)
				tmp = tmp - 256;
			tmp += addr + 2;
			tmp &= 0xFFFF;

			fprintf(fp, "%.2x %.2x     %s  $%.4x    ",
						one, two, s, tmp);
			count = 2;
			break;

		case M_ZIND:
			fprintf(fp, "%.2x %.2x     %s  ($%.2x)    ",
						one, two, s, two);
			count = 2;
			break;

		case M_ABINDX:
			fprintf(fp, "%.2x %.2x %.2x  %s  ($%.4x,X)",
						one, two, three, s,
						join(two, three));
			count = 3;
			break;

		default:
			fprintf(fp, "%.2x        %s             ", "???", one);
			count = 1;
	}

	return(count);
}

flags(fp)
FILE *fp;
{
	fprintf(fp, " A=%.2X X=%.2X Y=%.2X SP=%.2X", A, X, Y, Sp);
	fprintf(fp, "  N%d V%d B%d D%d I%d Z%d C%d\n",
				!!N, !!V, !!B, !!D, !!I, !NZ, !!C);
}

SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'a2.h'" '(4526 characters)'
if test -f 'a2.h'
then
	echo shar: will not over-write existing file "'a2.h'"
else
cat << \SHAR_EOF > 'a2.h'
/*
 *  a2, an Apple II emulator in C
 *  (c) Copyright 1990 by Rich Skrenta
 *
 *  Command line interface written by Tom Markson
 *
 *  Distribution agreement:
 *
 *	You may freely copy or redistribute this software, so long
 *	as there is no profit made from its use, sale, trade or
 *	reproduction.  You may not change this copyright notice,
 *	and it must be included prominently in any copy made.
 *
 *  Send emulator related mail to:  skrenta@blekko.commodore.com
 *				    skrenta@blekko.uucp
 */



#define		TRUE		1
#define		FALSE		0

extern FILE	*sfp;

/*
 *  Assertion verifier
 */
#define	assert(p)	if(! (p)) asfail(__FILE__, __LINE__, "p"); else


#define		join(low, high)		((low) | ((high) << 8))
#define		low(x)			((x) & 0xFF)
#define		high(x)			((x) >> 8)

#define		tobinary(v)		((v >> 4) * 10 + (v & 0xF))
#define		tobcd(v)		((v % 10) | ((v / 10) << 4))

#define		push(s)			mem[0x100 | Sp--] = s;
#define		pop()			mem[0x100 | ++Sp]

#define		SIGN(x)			N = ((x) & 0x80)
#define		ZERO(x)			NZ = (x)
#define		CARRY(x)		C = ((x) > 0xFF)
#define		dCARRY(x)		C = ((x) > 99)


#define	REF(a)		((a & 0xF000) == 0xC000 ? mem_map(a) : mem[a])
#define	REFptr		((ptr & 0xF000) == 0xC000 ? mem_map(ptr) : mem[ptr])
#define	REFzero		mem[ptr]
#define	REFimm		mem[Pc++]

#define	SET(a,v)	if (mem_set[a >> 8]) (*mem_set[a >> 8])(a,v); else mem[a] = v;
#define	SETptr(v)	if (mem_set[ptr >> 8]) (*mem_set[ptr >> 8])(ptr,v); else mem[ptr] = v;
#define	SETzero(v)	mem[ptr] = v;

#define	PCINC		Pc++;

#define	ABSOL		ptr = mem[Pc++]; ptr |= mem[Pc++] << 8;
#define	ABSX		ptr = mem[Pc++]; ptr |= mem[Pc++] << 8; ptr += X;
#define	ABSY		ptr = mem[Pc++]; ptr |= mem[Pc++] << 8; ptr += Y;
#define	ZEROP		ptr = mem[Pc++];
#define	ZEROX		ptr = (mem[Pc++] + X) & 0xFF;
#define	ZEROY		ptr = (mem[Pc++] + Y) & 0xFF;
#define	INDX	stmp = mem[Pc++] + X; ptr = mem[stmp++]; ptr |= mem[stmp] << 8;
#define	INDY	stmp = mem[Pc++]; ptr = mem[stmp++]; ptr |= mem[stmp] << 8; ptr += Y;

#define	rZEROP		mem[ mem[Pc++] ]
#define	rZEROX		mem[ (mem[Pc++] + X) & 0xFF ]
#define	rZEROY		mem[ (mem[Pc++] + Y) & 0xFF ]
#define	sZEROP(v)	mem[ mem[Pc++] ] = v;
#define	sZEROX(v)	mem[ (mem[Pc++] + X) & 0xFF ] = v;
#define	sZEROY(v)	mem[ (mem[Pc++] + Y) & 0xFF ] = v;

#define	ZIND		ptr = mem[ mem[Pc++] ];
#define	ABINDX		stmp = mem[Pc++]; stmp |= mem[Pc++] << 8; ptr = mem[stmp++]; ptr |= mem[stmp] << 8; ptr += X;


/*
 *  Since we store flags as 0/nonzero instead of 0/1, we need to turn
 *  nonzero back into 1.  Thus, "!!" is not a no-op.
 */

#define	get_status()   ((!!N << 7)|(!!V << 6)|(!!B << 4)|(!!D << 3)|(!!I << 2)|(!NZ << 1)|(!!C))

extern unsigned char mem[];		   /* 64K memory image */
extern unsigned char jmp_tbl[];		   /* jmp & jsr interceptor functions */
extern int (*mem_set[])();		   /* memory store interceptors */

extern unsigned char mem_map();


extern unsigned short Pc;
extern unsigned char Sp;	/* stack pointer 	*/
extern unsigned int A;		/* accumulator		*/
extern unsigned char X;		/* X register		*/
extern unsigned char Y;		/* Y register		*/

extern unsigned int N;		/* 7 - sign		*/
extern unsigned int V;		/* 6 - Overflow		*/
				/* 5 - Unused		*/
extern unsigned int B;		/* 4 - Break		*/
extern unsigned int D;		/* 3 - Decimal		*/
extern unsigned int I;		/* 2 - Interrupt	*/
extern unsigned int NZ;		/* 1 - inverse of Zero  */
extern unsigned int C;		/* 0 - Carry		*/


/*
 *  Note:
 *	Flags are stored as zero/nonzero instead of 0/1, except for
 *	N which is stored 0/0x80.  NZ is "not Z"; use !NZ to get
 *	the zero flag.
 *
 *	The flags code is tight, especially around overflow set on ADC
 *	and SBC.  Integer basic is a good test to see if it still works.
 */


#define		M_NONE		0
#define		M_ZP		1
#define		M_ZPX		2
#define		M_ZPY		3
#define		M_IND		4
#define		M_INDX		5
#define		M_INDY		6
#define		M_ABS		7
#define		M_ABSX		8
#define		M_ABSY		9
#define		M_IMM		10
#define		M_REL		11
#define		M_ZIND		12	/* zero page indirect, 65C02 */
#define		M_ABINDX	13	/* for jmp $7C in 65C02 */


extern int ram_read;
extern int ram_write;
extern int bank2_enable;

struct op_info {
	char *name;
	int add_mode;
};

extern struct op_info opcode[];
extern int running;
extern int tracing;
extern char *my_malloc();
extern int term_lines, term_cols;

extern int text1[];		/* base addresses for text page 1 */
extern int last_line;		/* line the cursor is on now */
extern int last_col;		/* current column of cursor */

extern int disk[2];
extern int write_prot[2];
extern int drive;

#define	DO_RTS	Pc = pop(); Pc |= pop() << 8; Pc++;

SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'mapper.c'" '(785 characters)'
if test -f 'mapper.c'
then
	echo shar: will not over-write existing file "'mapper.c'"
else
cat << \SHAR_EOF > 'mapper.c'

#include	<stdio.h>


/*
 *  Map a disk image in Prodos block ordering to DOS 3.3 block ordering
 *	usage:  mapper < old_image > new_image
 */

main() {
unsigned char buf[4096];
int track;

	for (track = 0; track < 35; track++) {
		if (read(0, buf, 4096) != 4096) {
			perror("bad read");
			exit(1);
		}

		write(1, buf, 256);
		write(1, &buf[0xE00], 256);
		write(1, &buf[0xD00], 256);
		write(1, &buf[0xC00], 256);
		write(1, &buf[0xB00], 256);
		write(1, &buf[0xA00], 256);
		write(1, &buf[0x900], 256);
		write(1, &buf[0x800], 256);
		write(1, &buf[0x700], 256);
		write(1, &buf[0x600], 256);
		write(1, &buf[0x500], 256);
		write(1, &buf[0x400], 256);
		write(1, &buf[0x300], 256);
		write(1, &buf[0x200], 256);
		write(1, &buf[0x100], 256);
		write(1, &buf[0xF00], 256);
	}
}


SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'hex.c'" '(443 characters)'
if test -f 'hex.c'
then
	echo shar: will not over-write existing file "'hex.c'"
else
cat << \SHAR_EOF > 'hex.c'

/*
 *  Turn an Apple II monitor ROM hex dump back into binary data
 *	usage:  hex < hex_data > bin_data
 */


#include	<stdio.h>

main() {
char buf[100];
int i, j;
int addr;
int m[8];
unsigned char c;

	while (fgets(buf, 100, stdin) != NULL) {
		i = sscanf(buf, "%x- %x %x %x %x %x %x %x %x",
			&addr, &m[0], &m[1], &m[2], &m[3], &m[4], &m[5],
						&m[6], &m[7]);

		for (j = 1; j < i; j++) {
			c = m[j - 1];
			write(1, &c, 1);
		}
	}
}

SHAR_EOF
fi # end of overwriting check
#	End of shell archive
exit 0

From cbmvax!cs!phillips Thu Aug  1 12:06 EDT 1991
Received: by blekko.commodore.com; Thu,  1 Aug 1991 12:06 EDT
Received: by cbmvax.cbm.commodore.com (5.57/UUCP-Project/Commodore 2/8/91)
	id AA16222; Thu, 1 Aug 91 11:57:37 EDT
Received: from grolsch.cs.ubc.ca by rutgers.edu (5.59/SMI4.0/RU1.4/3.08) 
	id AA25672; Thu, 1 Aug 91 11:08:40 EDT
Received: by grolsch.cs.ubc.ca id AA17777
  (5.65c/IDA-1.3.5 for skrenta@blekko.commodore.com); Tue, 30 Jul 1991 14:53:50 -0700
Date: 30 Jul 91 14:52 -0700
From: George Phillips <cbmvax!cs.ubc.ca!phillips>
To: Rich Skrenta <blekko!skrenta>
Message-Id: <2605*phillips@cs.ubc.ca>
Subject: a2.shar.4
Content-Type: text
Content-Length: 31611
Status: O

#! /bin/sh
# This is a shell archive, meaning:
# 1. Remove everything above the #! /bin/sh line.
# 2. Save the resulting text in a file.
# 3. Execute the file with /bin/sh (not csh) to create the files:
#	jump.c
#	disk.c
#	hgr.c
#	curses.c
#	poster
#	char.conv
# This archive created: Tue Jul 30 14:43:11 1991
export PATH; PATH=/bin:$PATH
echo shar: extracting "'jump.c'" '(8294 characters)'
if test -f 'jump.c'
then
	echo shar: will not over-write existing file "'jump.c'"
else
cat << \SHAR_EOF > 'jump.c'
/*
 *  a2, an Apple II emulator in C
 *  (c) Copyright 1990 by Rich Skrenta
 *
 *  Command line interface written by Tom Markson
 *
 *  Distribution agreement:
 *
 *	You may freely copy or redistribute this software, so long
 *	as there is no profit made from its use, sale, trade or
 *	reproduction.  You may not change this copyright notice,
 *	and it must be included prominently in any copy made.
 *
 *  Send emulator related mail to:  skrenta@blekko.commodore.com
 *				    skrenta@blekko.uucp
 */


#include	<stdio.h>
#include	<fcntl.h>
#include	"a2.h"

#define		jump_check(a,b,c,d)	(mem[Pc]==a && mem[Pc+1]==b && mem[Pc+2]==c && mem[Pc+3]==d)

/*
 *  In order to improve performance, we intercept the PC on JSR's
 *  and JMP's to certain locations and handled the intented function
 *  in C instead of letting the emulator interpret 6502.
 *
 *  This is done for video output, to produce an acceptable scroll;
 *  for the boot prom, so it crashes if there is no disk in the drive;
 *  and for other miscellaneous routines such as WAIT for speed.
 *
 *  In most cases the interceptor routine checks to see if the code it's
 *  intercepting looks like what it thinks should be there; it doesn't
 *  snatch the PC if the first four bytes of the routine don't match.
 */


#define		I_WAIT		1	/* defeat ROM WAIT routine           */
#define		I_PRODOS	2	/* Prodos high level intercept       */
#define		I_RWTS		3	/* DOS 3.3 high-level intercept      */
#define		I_BELL		4	/* don't toggle C030, output a bell  */
#define		I_VIDOUT	5	/* speeds up scrolling tremendously  */
#define		I_BOOT		6	/* crash if no disk on boot          */
#define		I_BOOTWAIT	7	/* defeat delay loops in DOS boot    */
#define		I_BOOTPATCH	8	/* patch dos for fast raw access     */


extern int map_to_upper;
extern unsigned char disk_ref();


set_special_jumps(dojumps)
int dojumps;
{
extern int set_c0();
extern int set_writep();

	mem[0x43] = 0x60;			/* for ProDos boot */

	if (dojumps) {
		jmp_tbl[0xBD00] = I_RWTS;
		jmp_tbl[0xC600] = I_BOOT;
		jmp_tbl[0xC680] = I_PRODOS;	/* patched into boot prom below */
		jmp_tbl[0x9D84] = I_BOOTPATCH;	/* fast raw dos access */
		jmp_tbl[0xFBD9] = I_BELL;
		jmp_tbl[0xFBFD] = I_VIDOUT;
		jmp_tbl[0xFCA8] = I_WAIT;

		jmp_tbl[0x3A00] = I_BOOTWAIT;
	}

	mem_set[0xC0] = set_c0;
	mem_set[0xC6] = set_writep;	/* write protect disk prom */

#if 0
	mem[0xC600] = 0;		/* flag for boot interception */
	mem[0xC601] = 0x20;		/* disk prom magic number */
	mem[0xC603] = 0x00;
	mem[0xC605] = 0x03;
	mem[0xC607] = 0x3C;
#endif

/*
 *  Patch boot rom for fake Prodos driver
 */

	mem[0xC6FF] = 0x80;		/* C680 is driver address */
	mem[0xC6FE] = 0x1F;		/* info about device */

	screen_setup();
}


jump(key)
int key;
{
int i;

	switch (key) {
	case I_WAIT:					/* FCA8 */
		if (jump_check(0x38, 0x48, 0xE9, 0x01)) {
			A = 0;
			N = 0;
			V = 0;
			C = 1;
			DO_RTS;
		}
		break;

	case I_PRODOS:					/* C680 */
		prodos();
		break;

	case I_RWTS:					/* BD00 */
		if (jump_check(0x84, 0x48, 0x85, 0x49))
			rwts();
		break;

	case I_BELL:					/* FBD9 */
		if (jump_check(0x60, 0x87, 0xD0, 0x12)) {
			putchar(7);
			fflush(stdout);
			DO_RTS;
		}
		break;

	case I_VIDOUT:					/* FBFD */
		if (jump_check(0xC9, 0xA0, 0xB0, 0xEF))
			vidout();
		break;

	case I_BOOT:					/* C600 */
		if (disk[0] < 0) {
			info("boot: no disk");
			PCINC;			/* BRK into the monitor */
			push(high(Pc));
			push(low(Pc));
			B = 1;
			push(get_status());
			Pc = mem[0xFFFE] | (mem[0xFFFF] << 8);
			return;
		}
		info("boot");

/* 
 *  We read the second half of a 512 byte block in case we're
 *  booting something that depends on this being a newer boot prom
 */

		drive = 0;
		read_disk(0, 14, &mem[0x900]);
		break;

/*
 *  Standard DOS 3.3 has some pretty gross delay loops in its
 *  boot code.  The following patches defeat two of them.
 *  This could be dangerous; it seems to work, but DOS's original
 *  side effects are not maintained.  Comment out the jmp_tbl assignment
 *  of I_BOOTWAIT above if you are distrustful.
 *
 *  Interesting.  Dos relocates the patches when it moves into higher
 *  memory.  If you boot with a fast-booting dos that doesn't have the
 *  delays at 3A00, but still has them at BA00 & BD9E when it starts
 *  up, it will be slow if you turn off RWTS interception and use the
 *  raw interface.  However, slow-booting real DOS that gets patched
 *  while it's booting will have a faster raw interface, since it
 *  relocated the patches...
 */

	case I_BOOTWAIT:				/* 3A00 */
		if (jump_check(0xA2, 0x11, 0xCA, 0xD0)) {
			mem[0x3A00] = 0x60;		/* RTS */
			if (mem[0x3D9E] == 0xA0
			&&  mem[0x3D9F] == 0x12
			&&  mem[0x3DA0] == 0x88) {
				mem[0x3D9E] = 0x4C;	/* JMP past it */
				mem[0x3D9F] = 0xAB;
				mem[0x3DA0] = 0x3D;	/* gets relocated */
			}
		}
		break;

/*
 *  This one is unnecessary since we do high-level RWTS interception
 */

	case I_BOOTPATCH:				/* 9D84 */
		if (jump_check(0xAD, 0xE9, 0xB7, 0x4A)) {
			if (mem[0xBA00] == 0xA2
			&&  mem[0xBA01] == 0x11
			&&  mem[0xBA02] == 0xCA) {
				mem[0xBA00] = 0x60;		/* RTS */
				if (mem[0xBD9E] == 0xA0
				&&  mem[0xBD9F] == 0x12
				&&  mem[0xBDA0] == 0x88) {
					mem[0xBD9E] = 0x4C;
					mem[0xBD9F] = 0xAB;
					mem[0xBDA0] = 0xBD;
				}
			}
		}
		break;

	default:
		fprintf(stderr, "bad jump intercept key: %d\n", key);
		assert(FALSE);
	}
}


#ifdef OLD
static int key_clear = TRUE;
static unsigned char last_key = 0;
static unsigned char temp_key;
#endif

extern int save_flags;

unsigned char
mem_map(a)
unsigned short a;
{

	switch (a) {
	/* new version just has a key in mem[0xc000]; */
#ifdef OLD
	case 0xC000:
		if (key_clear) {
			fcntl (0, F_SETFL, save_flags | O_NDELAY);
	  
			if (read (0, &temp_key, 1) == 1) {
				key_clear = FALSE;
				if (temp_key == '\n')
					temp_key = '\r';
				else if (temp_key == 127)
					temp_key = 8;
				/* GWP arrow key kludge */
				if (temp_key == '[') temp_key = 8;
				if (temp_key == ']') temp_key = 21;
				if (map_to_upper)
					temp_key = toupper(temp_key);
				last_key = temp_key | 0x80;
			}
	  
			fcntl (0, F_SETFL, save_flags);
		}
		return(last_key);
#endif

	case 0xC010:
#ifdef OLD
		key_clear = TRUE;
		last_key &= 0x7F;
#else
		mem[0xc000] &= 0x7f;
#endif
		return(0);			/* what should this be? */

	case 0xC011:
		if (bank2_enable)
			return(0xFF);
		return(0x00);

	case 0xC012:
		if (ram_read)
			return(0xFF);
		return(0x00);
	
	/* speaker */
	case 0xC030:
		break;

	case 0xC050: case 0xC051: case 0xC052: case 0xC053:
	case 0xC054: case 0xC055: case 0xC056: case 0xC057:
		screen_switch(a & 0xff);
		break;


	case 0xC080: case 0xC081: case 0xC082: case 0xC083:
	case 0xC088: case 0xC089: case 0xC08A: case 0xC08B:
		ram_card(a);
		return(0x00);

/*
 *  Slot 6 Disk II memory map 
 */

	case 0xC0E0: case 0xC0E1: case 0xC0E2: case 0xC0E3:
	case 0xC0E4: case 0xC0E5: case 0xC0E6: case 0xC0E7:
	case 0xC0E8: case 0xC0E9: case 0xC0EA: case 0xC0EB:
	case 0xC0EC: case 0xC0ED: case 0xC0EE: case 0xC0EF:
		return( disk_ref(a, 0) );

#if 0
/*
 *  Keep the boot prom magic number from appearing if there is
 *  no disk in the drive
 */

	case 0xC600:
	case 0xC601:
		if (disk[0] < 0)
			return(0);
		break;
#endif
	default:
/*		{ char s[64]; sprintf(s, "0x%x read", a); info(s); }*/
		break;

	}

	return(mem[a]);		/* default */
}


set_c0(a, n)
unsigned short a;
unsigned char n;
{

	switch (a & 0xFF) {
	case 0x10: case 0x11: case 0x12: case 0x13: case 0x14: case 0x15:
	case 0x16: case 0x17: case 0x18: case 0x19: case 0x1A: case 0x1B:
	case 0x1C: case 0x1D: case 0x1E: case 0x1F:
#ifdef OLD
		key_clear = TRUE;
		last_key &= 0x7F;
#else
		mem[0xc000] &= 0x7f;
#endif
		break;

	case 0x80: case 0x81: case 0x82: case 0x83:
	case 0x88: case 0x89: case 0x8A: case 0x8B:
		ram_card(a);
		break;

/*
 *  Slot 6 Disk II memory map 
 */

	case 0xC0E0: case 0xC0E1: case 0xC0E2: case 0xC0E3:
	case 0xC0E4: case 0xC0E5: case 0xC0E6: case 0xC0E7:
	case 0xC0E8: case 0xC0E9: case 0xC0EA: case 0xC0EB:
	case 0xC0EC: case 0xC0ED: case 0xC0EE: case 0xC0EF:
		disk_ref(a, n);
		break;

/* speaker */
	case 0x30:
		break;
	
	case 0x50: case 0x51: case 0x52: case 0x53:
	case 0x54: case 0x55: case 0x56: case 0x57:
		screen_switch(a & 0xff);
		break;

	default:
/*		{ char s[64]; sprintf(s, "0x%x set", a); info(s); }*/
		mem[a] = n;
	}
}
SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'disk.c'" '(7662 characters)'
if test -f 'disk.c'
then
	echo shar: will not over-write existing file "'disk.c'"
else
cat << \SHAR_EOF > 'disk.c'
/*
 *  a2, an Apple II emulator in C
 *  (c) Copyright 1990 by Rich Skrenta
 *
 *  Command line interface written by Tom Markson
 *
 *  Distribution agreement:
 *
 *	You may freely copy or redistribute this software, so long
 *	as there is no profit made from its use, sale, trade or
 *	reproduction.  You may not change this copyright notice,
 *	and it must be included prominently in any copy made.
 *
 *  Send emulator related mail to:  skrenta@blekko.commodore.com
 *				    skrenta@blekko.uucp
 */


#include	<stdio.h>
#include	"a2.h"


#define		GAP	0x7F;		/* data gap byte */


/*
 *  4 by 4 nibble encoding macros
 */

#define		nib1(a)	(((a) >> 1) | 0xAA)
#define		nib2(a)	((a) | 0xAA)
#define		denib(a,b)	(((((a) & 0x55) << 1) & 0xFF) | ((b) & 0x55))


int cur_track[2] = {0, 0};
int sect_pos[2];		/* current sector within track */

extern unsigned char tab1[];	/* For nibblizing.  At end of this file */
extern unsigned char tab2[];	/* Disk byte translation table. */
extern unsigned char phys[];	/* DOS 3.3 to physical sector mapping */

unsigned char sect_buf[2][1024];
unsigned char *sectp = NULL;
unsigned char *sect_point[2] = {NULL, NULL};
unsigned char write_reg;	/* write data register */
int write_mode = FALSE;



unsigned char
disk_ref(a, n)
unsigned short a;
unsigned char n;
{

	switch (a) {
	case 0xC0E0:	/* Phase 0 off */
	case 0xC0E1:	/* Phase 0 on */
	case 0xC0E2:	/* Phase 1 off */
	case 0xC0E3:	/* Phase 1 on */
	case 0xC0E4:	/* Phase 2 off */
	case 0xC0E5:	/* Phase 2 on */
	case 0xC0E6:	/* Phase 3 off */
	case 0xC0E7:	/* Phase 3 on */
		step_motor(a);
		break;

	case 0xC0E8:	/* Drive off */
		break;

	case 0xC0E9:	/* Drive on */
		break;

	case 0xC0EA:	/* Select drive 1 */
		sect_point[drive] = sectp;
		drive = 0;
		sectp = sect_point[0];
		break;

	case 0xC0EB:	/* Select drive 2 */
		sect_point[drive] = sectp;
		drive = 1;
		sectp = sect_point[1];
		break;

	case 0xC0EC:	/* Shift data register */
		if (disk[drive] < 0)
			return(0xFF);

		if (write_mode) {
			raw_disk_write();
			return(0);
		}

		if (sectp == NULL || *sectp == '\0') {
			sect_pos[drive]--;
			if (sect_pos[drive] < 0)
				sect_pos[drive] = 15;
			setup_sector(cur_track[drive], sect_pos[drive]);
		}

		return(*sectp++);

	case 0xC0ED:	/* Load data register */
		write_reg = n;
		break;

	case 0xC0EE:	/* Read mode */
		write_mode = FALSE;
		return(write_prot[drive] ? 0xFF : 0);
		break;

	case 0xC0EF:	/* Write mode */
		write_mode = TRUE;
		break;
	}

	return(0);
}



/*
 *  Determine what track the disk head is over by watching toggles to
 *  the four stepper motor magnets.
 */

step_motor(a)
unsigned short a;
{
static	int mag[2][4] = {{0, 0, 0, 0}, {0, 0, 0, 0}},
	pmag[2][4] = {{0, 0, 0, 0}, {0, 0, 0, 0}},	/* previous */
	ppmag[2][4] = {{0, 0, 0, 0}, {0, 0, 0, 0}},	/* previous previous */
	pnum[2] = {0, 0},
	ppnum[2] = {0, 0},
	track_pos[2] = {0, 0};

static int prev_track[2] = {0, 0};
int magnet_number;

	a &= 7;
	magnet_number = a >> 1;

	ppmag[drive][ppnum[drive]] = pmag[drive][ppnum[drive]];
	ppnum[drive] = pnum[drive];

	pmag[drive][pnum[drive]] = mag[drive][pnum[drive]];
	pnum[drive] = magnet_number;

	if ((a & 1) == 0)
		mag[drive][magnet_number] = FALSE;
	else {
		if (ppmag[drive][(magnet_number + 1) & 3]) {
			track_pos[drive]--;
			if (track_pos[drive] < 0) {
				track_pos[drive] = 0;
				if (drive)
					info("recal d2");
				else
					info("recal");
			}
		}

		if (ppmag[drive][(magnet_number - 1) & 3]) {
			track_pos[drive]++;
			if (track_pos[drive] > 140)
				track_pos[drive] = 140;

		}
		mag[drive][magnet_number] = TRUE;
	}

	cur_track[drive] = (track_pos[drive] + 1) / 2;
	if (cur_track[drive] != prev_track[drive]) {
#if 0
		sprintf(s, "step to %d%s", cur_track[drive],
						drive ? " d2" : "");
		info(s);
#endif
		sectp[drive] = NULL;	/* recompute sector if head moves */
		sect_pos[drive] = 0;
		prev_track[drive] = cur_track[drive];
	}
}



setup_sector(track, sector)
int track;
int sector;
{
int checksum;
int physical_sector;
char s[50];
int i;

	physical_sector = phys[sector];

	sprintf(s, "raw t=%d s=%d%s", track, sector, drive ? " d2" : "");
	info(s);

	sectp = sect_buf[drive];

	for (i = 0; i < 16; i++)
		*sectp++ = GAP;

	*sectp++ = 0xD5;			/* address header */
	*sectp++ = 0xAA;
	*sectp++ = 0x96;

	*sectp++ = 0xFF;			/* disk volume 254 */
	*sectp++ = 0xFE;

	*sectp++ = nib1(track);
	*sectp++ = nib2(track);

	*sectp++ = nib1(physical_sector);
	*sectp++ = nib2(physical_sector);

	checksum = 254 ^ track ^ physical_sector;
	*sectp++ = nib1(checksum);
	*sectp++ = nib2(checksum);

	*sectp++ = 0xDE;			/* address trailer */
	*sectp++ = 0xAA;

	for (i = 0; i < 8; i++)
		*sectp++ = GAP;

	*sectp++ = 0xD5;			/* data header */
	*sectp++ = 0xAA;
	*sectp++ = 0xAD;

	encode_data(track, sector);		/* nibblized data */

	*sectp++ = 0xDE;			/* data trailer */
	*sectp++ = 0xAA;
	*sectp++ = 0xEB;

	*sectp = '\0';				/* ending mark for our use */
	sectp = sect_buf[drive];		/* start reading at beginning */
}


/*
 *  Take a normal 256 byte sector and nibblize it into 342 bytes
 *  Checksum it with itself; this yields one more byte.
 *  Translate the resulting 343 bytes into "disk bytes".
 *  Insert them into the sector buffer.
 *
 *  See a reference such as _Beneath Apple Prodos_ for an explanation
 *  of why & how this is done.
 */

encode_data(track, sector)
int track;
int sector;
{
unsigned char buf[344];
unsigned char *one;
unsigned char *bump;
unsigned char *two;
unsigned char *three;
unsigned char *dest;
int i;

	read_disk(track, sector, &buf[86]);
	buf[342] = 0;
	buf[343] = 0;

	dest = buf;
	one = &buf[86];
	two = &buf[86 + 0x56];
	bump = two;
	three = &buf[86 + 0xAC];

	do {
		i = (*one++ & 0x03) |
			((*two++ & 0x03) << 2) | ((*three++ & 0x03) << 4);

		*dest++ = tab1[i];
	} while (one != bump);

	sectp[0] = buf[0];
	for (i = 1; i <= 342; i++)
		sectp[i] = buf[i - 1] ^ buf[i];

	for (i = 0; i <= 342; i++)
		sectp[i] = tab2[ sectp[i] >> 2 ];

	sectp = &sectp[343];
}


raw_disk_write() {

	printf("raw write %.2X\n", write_reg);
}


read_disk(track, sector, buf)
int track;
int sector;
unsigned char *buf;
{
long block;

	block = track * 16 + sector;

	lseek(disk[drive], block * 256, 0);
	if (read(disk[drive], buf, 256) != 256)
		perror("bad read");
}


write_disk(track, sector, buf)
int track;
int sector;
unsigned char *buf;
{
long block;

	block = track * 16 + sector;

	lseek(disk[drive], block * 256, 0);
	if (write(disk[drive], buf, 256) != 256)
		perror("bad write");
}


/*
 *  Helps with the bit fiddling necessary to extract the bottom
 *  two bits during the 256 - 342 byte nibblize.
 */

unsigned char tab1[] = {
	0x00, 0x08, 0x04, 0x0C, 0x20, 0x28, 0x24, 0x2C,
	0x10, 0x18, 0x14, 0x1C, 0x30, 0x38, 0x34, 0x3C,
	0x80, 0x88, 0x84, 0x8C, 0xA0, 0xA8, 0xA4, 0xAC,
	0x90, 0x98, 0x94, 0x9C, 0xB0, 0xB8, 0xB4, 0xBC,
	0x40, 0x48, 0x44, 0x4C, 0x60, 0x68, 0x64, 0x6C,
	0x50, 0x58, 0x54, 0x5C, 0x70, 0x78, 0x74, 0x7C,
	0xC0, 0xC8, 0xC4, 0xCC, 0xE0, 0xE8, 0xE4, 0xEC,
	0xD0, 0xD8, 0xD4, 0xDC, 0xF0, 0xF8, 0xF4, 0xFC,
};


/*
 *  Translates to "disk bytes"
 */

unsigned char tab2[] = {
	0x96, 0x97, 0x9A, 0x9B, 0x9D, 0x9E, 0x9F, 0xA6, 
	0xA7, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, 0xB2, 0xB3, 
	0xB4, 0xB5, 0xB6, 0xB7, 0xB9, 0xBA, 0xBB, 0xBC, 
	0xBD, 0xBE, 0xBF, 0xCB, 0xCD, 0xCE, 0xCF, 0xD3, 
	0xD6, 0xD7, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 
	0xDF, 0xE5, 0xE6, 0xE7, 0xE9, 0xEA, 0xEB, 0xEC, 
	0xED, 0xEE, 0xEF, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 
	0xF7, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF, 
};


/*
 *  Dos 3.3 to physical sector conversion
 */

unsigned char phys[] = {
	0x00, 0x0D, 0x0B, 0x09, 0x07, 0x05, 0x03, 0x01,
	0x0E, 0x0C, 0x0A, 0x08, 0x06, 0x04, 0x02, 0x0F,
};

SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'hgr.c'" '(6665 characters)'
if test -f 'hgr.c'
then
	echo shar: will not over-write existing file "'hgr.c'"
else
cat << \SHAR_EOF > 'hgr.c'
/*
 * hgr.c -- hi-res graphic mode byte translator
 *
 *	w	for white
 *	k	for black
 *	v	for violet
 *	g	for green
 *	b	for blue
 *	r	for red
 *
 * At the very least, HGR weird and wonderfulness is mostly
 * restricted to this routine.
 */

#include "hgr.h"

/* b0 must be on an even column */

char* hgrinterp(lclr, lbit, b0, b1, rbit, rclr)
int	lclr, lbit, b0, b1, rbit, rclr;
{
	if (b0 && b1)
		return "ww";
	
	if (lbit && b0)
		return "wk";
	
	if (b1 && rbit)
		return "kw";
	
	if (b0)
		return lclr ? "bb" : "vv";
	
	if (b1)
		return rclr ? "rr" : "gg";
	
	return "kk";
}

/*
I want to convert the 280 x 192 Apple ][ screen into a 560 x 384 mono screen.
The pixels are therefore doubled with the following patterns:

white   black   violet  green   blue    red		spare pattern
  **      ..      *.      .*     *.      **        ..
  **      ..      .*      **     *.      ..		   .*

To accomplish this, the loop will process 4 Apple ][ bytes at a time
which will be translated into 2 rows of 7 bytes each (4 * 7 * 2 = 7 * 8).

I plan on using 7 steps which each step producing one of the new bytes.
This will involve getting 4 Apple ][ pixels along with colour and
neighbour information (another 4 bits).  A lookup table (or maybe 7
of them) should make this simple enough; just a matter of building
the right lookup tables.  Using some bigger lookup tables could
make this faster, but this solution should be pretty straightforward.

   a0         a1         a2         a3
c0123.456 c0.1234.56 c01.2345.6 c012.3456
  b1     b2   b3    b4    b5    b6    b7

b1 = a0(c) + a-1(6) + a0(0..4)
b2 = a0(c) + a1(c) + a0(3..6) + a1(0..1)
b3 = a1(c) + a1(0..5)
b4 = a1(c) + a2(c) + a1(4..6) + a2(0..2)
b5 = a2(c) + a2(1..6)
b6 = a2(c) + a3(c) + a2(5..6) + a3(0..3)
b7 = a3(c) + a3(2..6) + a4(0)

Noting that a(c) is really a(7), the following set of C bit expressions
should be fairly minimal (I'll use 8 bits even if I don't need them
in order to save a shift).

b1: (a0 & 0x9f) | (aprev & 0x40)
b2: ((a0 >> 1) & 0x7c) | (a1 & 0x83)
b3: a1
b4: ((a1 >> 1) & 0x78) | (a2 & 0x87)
b5: a2
b6: ((a2 >> 1) & 0x70) | (a3 & 0x8f)
b7: (a3 & 0xfc) | (a4 & 0x01)

Now, to build the tables we merely need to zip through all combinations
of colour, neighbour and internal bits, call hgrinterp() to give us
colour codes, change the colour codes into monochrome bit patterns
and put the bit patterns at the appropriate point in the table.

*/

grey(pixel)
char pixel;
{
	switch (pixel) {
	case 'w':	return 0;	/* 0 */
	case 'k':	return 3;	/* 3 */
	case 'v':	return 1;	/* 2 */
	case 'g':	return 2;	/* 0 */
	case 'b':	return 1;	/* 1 */
	case 'r':	return 0;	/* 3 */
	}
	return 3;
}

greylow(pixel)
char pixel;
{
	switch (pixel) {
	case 'w':	return 0;
	case 'k':	return 3;
	case 'v':	return 2;
	case 'g':	return 0;
	case 'b':	return 1;
	case 'r':	return 3;
	}
	return 3;
}

monoit(pix)
char*	pix;
{
	return (grey(pix[0]) << 2) | grey(pix[1]);
}

monolow(pix1, pix2)
char* pix1;
char* pix2;
{
	return (greylow(pix1[0]) << 6) | (greylow(pix1[1]) << 4) |
		(greylow(pix2[0]) << 2) | greylow(pix2[1]);
}

unsigned char b1_tab[256], b2_tab[256], b3_tab[256], b4_tab[256],
	b5_tab[256], b6_tab[256], b7_tab[256];

unsigned char b1_tab_2[256], b2_tab_2[256], b3_tab_2[256], b4_tab_2[256],
	b5_tab_2[256], b6_tab_2[256], b7_tab_2[256];

#define permute(lc, lb, x0, x1, x2, x3, rb, rc)				\
	(lclr << lc) | (lbit << lb) | (b0 << x0) | (b1 << x1) |	\
	(b2 << x2) | (b3 << x3) | (rbit << rb) | (rclr << rc)

#define mono(clrleft2, clrleftright, clrright2)	\
	(monoit(h1 = hgrinterp(lclr, lbit, b0, b1, b2, clrleft2)) << 4) | \
	monoit(h2 = hgrinterp(clrleftright, b1, b2, b3, rbit, clrright2))

void buildtable()
{
	int lclr, lbit, b0, b1, b2, b3, b4, rbit, rclr, p;
	char *h1, *h2;

	for (lclr = 0; lclr < 2; lclr++)
	for (lbit = 0; lbit < 2; lbit++)
	for (b0 = 0; b0 < 2; b0++)
	for (b1 = 0; b1 < 2; b1++)
	for (b2 = 0; b2 < 2; b2++)
	for (b3 = 0; b3 < 2; b3++)
	for (rbit = 0; rbit < 2; rbit++)
	for (rclr = 0; rclr < 2; rclr++) {
		b1_tab[p = permute(7, 6, 0, 1, 2, 3, 4, 5)] = mono(lclr, lclr, lclr);
		b1_tab_2[p] = monolow(h1, h2);
		b2_tab[p = permute(6, 2, 3, 4, 5, 0, 1, 7)] = mono(lclr, lclr, rclr);
		b2_tab_2[p] = monolow(h1, h2);
		b3_tab[p = permute(7, 0, 1, 2, 3, 4, 5, 6)] = mono(lclr, lclr, lclr);
		b3_tab_2[p] = monolow(h1, h2);
		b4_tab[p = permute(6, 3, 4, 5, 0, 1, 2, 7)] = mono(lclr, rclr, rclr);
		b4_tab_2[p] = monolow(h1, h2);
		b5_tab[p = permute(7, 1, 2, 3, 4, 5, 6, 0)] = mono(lclr, lclr, lclr);
		b5_tab_2[p] = monolow(h1, h2);
		b6_tab[p = permute(6, 4, 5, 0, 1, 2, 3, 7)] = mono(rclr, rclr, rclr);
		b6_tab_2[p] = monolow(h1, h2);
		b7_tab[p = permute(7, 2, 3, 4, 5, 6, 0, 1)] = mono(lclr, lclr, lclr);
		b7_tab_2[p] = monolow(h1, h2);
	}
}

int cb1_tab[256], cb2_tab[256], cb3_tab[256], cb4_tab[256],
	cb5_tab[256], cb6_tab[256], cb7_tab[256];

#define permute(lc, lb, x0, x1, x2, x3, rb, rc)				\
	(lclr << lc) | (lbit << lb) | (b0 << x0) | (b1 << x1) |	\
	(b2 << x2) | (b3 << x3) | (rbit << rb) | (rclr << rc)

#define clr(clrleft2, clrleftright, clrright2)	\
	colour(hgrinterp(lclr, lbit, b0, b1, b2, clrleft2),			\
		hgrinterp(clrleftright, b1, b2, b3, rbit, clrright2))

int colour(l2, r2)
char*	l2;
char*	r2;
{
	return (tomap(l2[0]) << 24) | (tomap(l2[1]) << 16) |
		(tomap(r2[0]) << 8) | tomap(r2[1]);
}

static int g_black, g_white, g_red, g_green, g_blue, g_violet;

tomap(pix)
char	pix;
{
	switch (pix) {
	case 'k': return g_black;
	case 'w': return g_white;
	case 'r': return g_red;
	case 'g': return g_green;
	case 'b': return g_blue;
	case 'v': return g_violet;
	}
	return g_black;
}

void cbuildtable(black, white, violet, green, blue, red)
int black, white, violet, green, blue, red;
{
	int lclr, lbit, b0, b1, b2, b3, b4, rbit, rclr, p;
	int i;

	g_black = black;
	g_white = white;
	g_violet = violet;
	g_green = green;
	g_blue = blue;
	g_red = red;

	for (lclr = 0; lclr < 2; lclr++)
	for (lbit = 0; lbit < 2; lbit++)
	for (b0 = 0; b0 < 2; b0++)
	for (b1 = 0; b1 < 2; b1++)
	for (b2 = 0; b2 < 2; b2++)
	for (b3 = 0; b3 < 2; b3++)
	for (rbit = 0; rbit < 2; rbit++)
	for (rclr = 0; rclr < 2; rclr++) {
		p = permute(7, 6, 0, 1, 2, 3, 4, 5);
		cb1_tab[p] = clr(lclr, lclr, lclr);

		p = permute(6, 2, 3, 4, 5, 0, 1, 7);
		cb2_tab[p] = clr(lclr, lclr, rclr);

		p = permute(7, 0, 1, 2, 3, 4, 5, 6);
		cb3_tab[p] = clr(lclr, lclr, lclr);

		p = permute(6, 3, 4, 5, 0, 1, 2, 7);
		cb4_tab[p] = clr(lclr, rclr, rclr);

		p = permute(7, 1, 2, 3, 4, 5, 6, 0);
		cb5_tab[p] = clr(lclr, lclr, lclr);

		p = permute(6, 4, 5, 0, 1, 2, 3, 7);
		cb6_tab[p] = clr(rclr, rclr, rclr);

		p = permute(7, 2, 3, 4, 5, 6, 0, 1);
		cb7_tab[p] = clr(lclr, lclr, lclr);
	}
}
SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'curses.c'" '(6302 characters)'
if test -f 'curses.c'
then
	echo shar: will not over-write existing file "'curses.c'"
else
cat << \SHAR_EOF > 'curses.c'
/*
 *  a2, an Apple II emulator in C
 *  (c) Copyright 1990 by Rich Skrenta
 *
 *  Command line interface written by Tom Markson
 *
 *  Distribution agreement:
 *
 *	You may freely copy or redistribute this software, so long
 *	as there is no profit made from its use, sale, trade or
 *	reproduction.  You may not change this copyright notice,
 *	and it must be included prominently in any copy made.
 *
 *  Send emulator related mail to:  skrenta@blekko.commodore.com
 *				    skrenta@blekko.uucp
 */

/*
**  This a screen management library borrowed with permission from the
**  Elm mail system (a great mailer--I highly recommend it!).
**
**  I've hacked this library to only provide what I need.
**
**  Original copyright follows:
*/
/*******************************************************************************
 *  The Elm Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 * 			Copyright (c) 1986 Dave Taylor
 ******************************************************************************/

#ifndef M_XENIX
#include <sys/termio.h>
#endif

#include <stdio.h>
#include <curses.h>
#include <ctype.h>

#define DEFAULT_term_lines	24
#define DEFAULT_COLUMNS	80
#define TTYIN	0


#define		VERY_LONG_STRING	2500

int term_lines = DEFAULT_term_lines - 1;
int term_cols  = DEFAULT_COLUMNS;
extern char escape_char;

#ifdef SHORTNAMES
# define _cleartoeoln	_clrtoeoln
# define _cleartoeos	_clr2eos
#endif

#ifndef BSD
struct termio raw_tty, 
              orig_tty;
#else
#define TCGETA	TIOCGETP
#define TCSETAW	TIOCSETP

struct sgttyb raw_tty,
	      orig_tty;
#endif

static int inraw = 0;                  /* are we IN rawmode?    */


static int _memory_locked = 0;		/* are we IN memlock??   */

static int _intransmit;			/* are we transmitting keys? */

static
char *_clearscreen, *_moveto, *_cleartoeoln, *_cleartoeos,
	*_setinverse, *_clearinverse;


static
int _lines,_columns;

static char _terminal[1024];              /* Storage for terminal entry */
static char _capabilities[1024];           /* String for cursor motion */

static char *ptr = _capabilities;	/* for buffering         */

int    outchar();			/* char output for tputs */
char  *tgetstr(),     		       /* Get termcap capability */
      *tgoto();				/* and the goto stuff    */

InitScreen()
{
int  tgetent(),      /* get termcap entry */
     err;
char termname[40];
char *strcpy(), *getenv();
	
	if (getenv("TERM") == NULL) {
		fprintf(stderr,
		  "TERM variable not set; Screen capabilities required\n");
		return(FALSE);
	}
	if (strcpy(termname, getenv("TERM")) == NULL) {
		fprintf(stderr,"Can't get TERM variable\n");
		return(FALSE);
	}
	if ((err = tgetent(_terminal, termname)) != 1) {
		fprintf(stderr,"Can't get entry for TERM\n");
		return(FALSE);
	}

	/* load in all those pesky values */
	_clearscreen       = tgetstr("cl", &ptr);
	_moveto            = tgetstr("cm", &ptr);
	_cleartoeoln       = tgetstr("ce", &ptr);
	_cleartoeos        = tgetstr("cd", &ptr);
	_setinverse        = tgetstr("so", &ptr);
	_clearinverse      = tgetstr("se", &ptr);
	_lines	      	   = tgetnum("li");
	_columns	   = tgetnum("co");

	if (!_clearscreen) {
		fprintf(stderr,
			"Terminal must have clearscreen (cl) capability\n");
		return(FALSE);
	}
	if (!_moveto) {
		fprintf(stderr,
			"Terminal must have cursor motion (cm)\n");
		return(FALSE);
	}
	if (!_cleartoeoln) {
		fprintf(stderr,
			"Terminal must have clear to end-of-line (ce)\n");
		return(FALSE);
	}
	if (!_cleartoeos) {
		fprintf(stderr,
			"Terminal must have clear to end-of-screen (cd)\n");
		return(FALSE);
	}
	if (_lines == -1)
		_lines = DEFAULT_term_lines;
	if (_columns == -1)
		_columns = DEFAULT_COLUMNS;
	return(TRUE);
}

ScreenSize(lines, columns)
int *lines, *columns;
{
	/** returns the number of lines and columns on the display. **/

	if (_lines == 0) _lines = DEFAULT_term_lines;
	if (_columns == 0) _columns = DEFAULT_COLUMNS;

	*lines = _lines - 1;		/* assume index from zero*/
	*columns = _columns;		/* assume index from one */
}

ClearScreen()
{
	/* clear the screen: returns -1 if not capable */

	tputs(_clearscreen, 1, outchar);
	fflush(stdout);      /* clear the output buffer */
}

MoveCursor(row, col)
int row, col;
{
	/** move cursor to the specified row column on the screen.
            0,0 is the top left! **/

	char *stuff, *tgoto();

	stuff = tgoto(_moveto, col, row);
	tputs(stuff, 1, outchar);
/*	fflush(stdout);	*/
}

CleartoEOLN()
{
	/** clear to end of line **/

	tputs(_cleartoeoln, 1, outchar);
	fflush(stdout);  /* clear the output buffer */
}

CleartoEOS()
{
	/** clear to end of screen **/

	tputs(_cleartoeos, 1, outchar);
	fflush(stdout);  /* clear the output buffer */
}

Raw(state)
int state;
{
	/** state is either TRUE or FALSE, as indicated by call **/

	if (state == FALSE && inraw) {
	  (void) ioctl(TTYIN, TCSETAW, &orig_tty);
	  inraw = 0;
	}
	else if (state == TRUE && ! inraw) {

	  (void) ioctl(TTYIN, TCGETA, &orig_tty);	/** current setting **/

	  (void) ioctl(TTYIN, TCGETA, &raw_tty);    /** again! **/
#ifdef BSD
/*	  raw_tty.sg_flags &= ~(ECHO | CRMOD);	/* echo off */
	  raw_tty.sg_flags &= ~ECHO;		/* echo off */
	  raw_tty.sg_flags |= CBREAK;	/* raw on    */
#else
	  raw_tty.c_lflag &= ~(ICANON | ECHO);	/* noecho raw mode        */

	  raw_tty.c_cc[VMIN] = '\01';	/* minimum # of chars to queue    */
	  raw_tty.c_cc[VTIME] = '\0';	/* minimum time to wait for input */

#endif
	  raw_tty.c_cc[VINTR]= escape_char;
	  (void) ioctl(TTYIN, TCSETAW, &raw_tty);
	  inraw = 1;
	}
}

int
ReadCh()
{
	/** read a character with Raw mode set! **/

	register int result;
	char ch;
	result = read(0, &ch, 1);
        return((result <= 0 ) ? EOF : ch);
}


outchar(c)
char c;
{
	/** output the given character.  From tputs... **/
	/** Note: this CANNOT be a macro!              **/

	putc(c, stdout);
}


#if 0
static int inverse = FALSE;

SetInverse() {

	if (!inverse) {
		StartInverse();
		inverse = TRUE;
	}
}

SetNormal() {

	if (inverse) {
		EndInverse();
		inverse = FALSE;
	}
}
#endif


StartInverse()
{
	/** set inverse video mode **/

	if (!_setinverse)
		return(-1);

	tputs(_setinverse, 1, outchar);
/*	fflush(stdout);	*/
	return(0);
}


EndInverse()
{
	/** compliment of startinverse **/

	if (!_clearinverse)
		return(-1);

	tputs(_clearinverse, 1, outchar);
/*	fflush(stdout);	*/
	return(0);
}

SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'poster'" '(713 characters)'
if test -f 'poster'
then
	echo shar: will not over-write existing file "'poster'"
else
cat << \SHAR_EOF > 'poster'
>From blekko!skrenta@cbmvax.cbm.commodore.com Wed Apr 17 16:16:35 1991
Return-Path: <blekko!skrenta@cbmvax.cbm.commodore.com>
Received: from rutgers.edu by helios (4.1/SMI-4.1)
	id AA14666; Wed, 17 Apr 91 16:16:09 PDT
Received: from cbmvax.UUCP by rutgers.edu (5.59/SMI4.0/RU1.4/3.08) with UUCP 
	id AA25964; Wed, 17 Apr 91 18:08:37 EDT
Received: by cbmvax.cbm.commodore.com (5.57/UUCP-Project/Commodore 2/8/91)
	id AA11014; Wed, 17 Apr 91 18:00:12 EDT
To: terry@helios.UCSC.EDU
Subject: Apple II emulator, Part 1/2
From: blekko!skrenta@cbmvax.cbm.commodore.com (Rich Skrenta)
Date: Wed, 17 Apr 1991 17:36 EDT
Message-Id: <671924187.AA5085@blekko.commodore.com>
Content-Type: text
Content-Length: 58877
Status: R

SHAR_EOF
fi # end of overwriting check
echo shar: extracting "'char.conv'" '(329 characters)'
if test -f 'char.conv'
then
	echo shar: will not over-write existing file "'char.conv'"
else
cat << \SHAR_EOF > 'char.conv'
#!/cs/local/bin/perl

print "unsigned char charset[512] = {";

$comma = "";

while (<>) {
	chop;
	next if $_ eq "";
	if (/\|(.)/) {
		print "$comma\n/* $1 */ 0x00,";
		$comma = "";
	}
	$_ = substr($_, 0, 5);
	s/\./0/g;
	s/[^0]/1/g;
	print "$comma 0x", unpack("H2", pack("B8", "00" . $_ . "0"));
	$comma = ",";
}

print "\n};\n";
SHAR_EOF
chmod +x 'char.conv'
fi # end of overwriting check
#	End of shell archive
exit 0

