/*
 * unbit.c
 *
 * By Marcel J.E. Mol               duteca!marcel
 *                                  marcel@duteca.tudelft.nl
 *
 * I hereby place this program into public domain ...
 *  ...  all those all those if and whats etc....
 * I'm completely unresponsible for any damage this program may cause you,
 * anyone, or anything else.
 *
 *
 * Unbit expects a 6 bit encoding scheme of executioner output.
 * Remove all stuff from the 'call -151' to 'F00G', and the last 
 * few lines containing the 'BSAVE ...' stuff. Fed the resulting 
 * ascii encoded data through unbit resulting in the binaru data.
 * Thus each line in the input file should look something like this:
 *
 *     0A474CE30600AC02030053B2320F54B21E15020099030006444154452E430000
 *
 * Usage: The program reads from a file or stdin, and outputs to
 *        stdout. I usually use the program as follows:
 *
 *           unbit  file.ex  > file.blu
 */

#include <stdio.h>
#if defined(MSDOS)
# include <fcntl.h>
#endif

char * copyright = "@(#) unbit.c  2.2 26/03/90  (c) M.J.E. Mol";

main(argc, argv)
int argc;
char **argv;
{
    FILE *fp;

    if ((argc == 1) || (!strcmp(argv[1], "-"))) {
#if defined(MSDOS)
        setmode(fileno(stdout), O_BINARY);
#endif
        fp = stdin;
    }
    else {
#if defined(MSDOS)
        if ((fp = fopen(argv[1], "rb")) == NULL) {
#else
	if ((fp = fopen(argv[1], "r")) == NULL) {
#endif
	    perror(argv[1]);
	    exit(1);
	}
    }

    unbit(fp);

    exit(0);

} /* main */



unbit(fp)
FILE *fp;
{
	int c, co;

	while ((c = getc(fp)) != EOF) {
		if ((c != ' ') && (c != '\n')) {
			if ((c>='0') && (c<='9')) c-= '0';
			else if ((c>='a') && (c<='f')) c = c - 'a' + 10;
			else if ((c>='A') && (c<='F')) c = c - 'A' + 10;
			else fprintf(stderr, "illegal char %c\n",c);
			co = c << 4;
			c = getc(fp);
			if ((c>='0') && (c<='9')) c-= '0';
			else if ((c>='a') && (c<='f')) c = c - 'a' + 10;
			else if ((c>='A') && (c<='F')) c = c - 'A' + 10;
			else fprintf(stderr, "illegal char %c\n",c);
			co += c;
			putchar(co);
		}
	}

} /* unbit */

