/*
// Abstract:
//	TA.C
//
// Author:
//	Derek S. Nickel
//
// Creation date:
//	25 October 1990
//
// History:
// V01-001	Derek S. Nickel		25-OCT-1990
//	Original.
//
*/

#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>

#include "memory.h"
#include "commands.h"
#include "modes.h"
#include "objects.h"
#include "instruct.h"
#include "ports.h"

/***********************************************************************
	unany
***********************************************************************/

void unany(char *subcmds)
{
	int i, stop = 0;
	int limit;
	int ua_limit;
	int ut_limit;

	/*
	// Set up unassemble/unthread limits.
	*/

	ua_limit = modes.limit;
	ut_limit = 1;
	limit = (modes.unmode ? ua_limit : ut_limit);

	/*
	// Unassemble or unthread, switching as needed.
	*/

	i = 0;

	while (i < limit && !(stop && modes.stop)) {

		i++;

		if (modes.unmode) {
			/*
			// Unassemble the current instruction.
			*/

			unassem1instr(&stop);

			/*
			// If switching to unthread mode...
			*/

			if (!modes.unmode) {
				limit = ut_limit;
				i = 0;
			}

		} else {
			/*
			// Display the current RPL object.
			*/

			modes.unmode = display_current_object(&stop);

			/*
			// If switching to unassemble mode...
			*/

			if (modes.unmode) {
				limit = ua_limit;
				i = 0;
			}
		}
	}
}
