#if !defined(memory_included)
#define memory_included
/*
// Abstract:
//	MEMORY.H---Memory Operations
//
//	The Memory Operations C include file defines the interface to
/	Memory Operaetions routines.
//
// Author:
//	Derek S. Nickel
//
// Creation date:
//	28 October 1990
//
// History:
// V01-001	Derek S. Nickel		28-OCT-1990
//	Original.
//
*/

#include <stdlib.h>

#include "voyager.h"
#include "index.h"

typedef signed long bin5_t;

typedef struct _port_info_t port_info_t;

struct _port_info_t {
	int loaded;
	bin5_t mem_ptr;
	bin5_t min_adr;
	bin5_t max_adr;
	char *module;
	FILE *mem_file;
	text_file_t *ca_file;
	text_file_t *cc_file;
};

extern port_info_t ports[3];
extern bin5_t WorkPtr;

extern char GetNibble(void);
extern void GetNNibbles(char *ans, int n);
extern void SetWorkPtr(bin5_t adr);
extern bin5_t str2adr(char *s, char **wp);

extern char *get_address_comment(bin5_t adr);
extern bin5_t get_bin5(void);
extern char *get_code_comment(bin5_t adr);
extern int xlate_adr(bin5_t adr, int *port_no, bin5_t *port_adr);

#define hexval(ch) ((isdigit(ch)) ? ch-'0' : ch-'A'+10)

#endif
