#if !defined(index_included)
#define index_included
/*
// Abstract:
//	INDEX.H---Comment File Indexing
//
//	The Comment File Index C include file defines the interface to
//	the Comment File Indexing routines.
//
// Author:
//	Derek S. Nickel
//
// Creation date:
//	12 November 1990
//
// History:
// V01-001	Derek S. Nickel		12-NOV-1990
//	Original.
//
*/

#include <stdio.h>
#include <stdlib.h>

#include "voyager.h"

typedef struct _node_t node_t;

struct _node_t {
	node_t *llink;
	node_t *rlink;
	short b;
	bin5_t key;
	long value;
	char deleted;
};

typedef struct _text_file_t text_file_t;
typedef struct _text_file_t TextFile;

typedef struct _text_file_t {
	node_t *root;
	char fnmap[_MAX_PATH];
	char fninx[_MAX_PATH];
	FILE *f;
	int count;
	int changes;
};

extern char *GetTextLine(text_file_t *, bin5_t);
extern void AddTextLine(text_file_t *, bin5_t, char *);
extern void DelTextLine(text_file_t *, bin5_t);

extern void close_text_file(text_file_t *);
extern void merge_text_file(text_file_t *, char *, char *);
extern void open_text_file(text_file_t *, char *, char *);
extern void sort_text_file(text_file_t *, char *, char *, char *, int *);

extern void close_memory_file(FILE *xfile);
extern void open_memory_file(FILE **xfile, char *filename);

#endif
