/*
// Abstract:
//	DUMP---Dump Memory
//
//	The Dump Memory module provides for the display of the HP 48SX's
//	memory in various formats.
//
// Author:
//	Derek S. Nickel
//
// Creation date:
//	28 October 1990
//
// History:
// V01-001	Derek S. Nickel		28-OCT-1990
//	Original.
//
*/

#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "dump.h"
#include "memory.h"
#include "modes.h"
#include "pager.h"

#define vgr__intlogerr \
"%%VOYAGER-E-INTLOGERR, internal logic error\n"

/***********************************************************************
	dump_hex_part
***********************************************************************/

void dump_hex_part(char *buf)
{
	/*
	// Dump the data in FE DC BA 98 76 54 32 10... format.
	*/

	int j, i;

	i = strlen(buf)/2 - 1;

	for (j = i; j >= 0; j--)
		printf(" %c%c", buf[2*j+1], buf[2*j]);
}

/***********************************************************************
	dump_text_part
***********************************************************************/

void dump_text_part(char *buf)
{
	int j, ch, i;

	i = strlen(buf)/2 - 1;

	for (j = 0; j <= i; ++j) {
		ch = hexval(buf[2*j]) + (hexval(buf[2*j+1]) << 4);
		if (isprint(ch))
			putchar(ch);
		else
			putchar('.');
	}
}

/***********************************************************************
	dump_hex
***********************************************************************/

void dump_hex(void)
{
	/*
	// Dump 32 nibbles (16 characters) with ASCII representation.
	*/

	char buf[33];
	bin5_t origWP = WorkPtr;

	pager(0);
	GetNNibbles(buf,32);
	dump_hex_part(buf);
	putchar(' ');
	dump_text_part(buf);
	printf(" %05lX\n", origWP);
}

/***********************************************************************
	dump_text
***********************************************************************/

void dump_text(void)
{
	/*
	// Dump 64 characters (128 nibbles), ASCII representation only.
	*/

	char buf[129];
	bin5_t origWP = WorkPtr;

	pager(0);
	GetNNibbles(buf,128);
	putchar(' ');
	dump_text_part(buf);
	printf(" %05lX\n", origWP);
}

/***********************************************************************
	dump_alt
***********************************************************************/

void dump_alt(void)
{
	/*
	// Dump 32 nibbles (16 characters) with ASCII representation.
	// Memory dump format (low to high).
	*/

	char buf[33];
	bin5_t origWP = WorkPtr;

	pager(0);
	GetNNibbles(buf,32);
	printf("%05lX: %s ", origWP, buf);
	dump_text_part(buf);
	putchar('\n');
}

/***********************************************************************
	dump_memory
***********************************************************************/

void dump_memory(bin5_t adr, int dump_type)
{
	static int current_dump_type = 1;
	int j, limit = modes.limit;

	SetWorkPtr(adr);

	if (dump_type != 0) current_dump_type = dump_type;

	switch (current_dump_type) {
	    case 1:
		for (j = 0; j < limit; j++)
			dump_hex();
		break;

	    case 2:
		for (j = 0; j < limit; j++)
			dump_text();
		break;

	    case 3:
		for (j = 0; j < limit; j++)
			dump_alt();
		break;

	    default:
		pager(0);
		printf(vgr__intlogerr);
		break;
	}
}
