/* literals.h - STAR Literal Pool header */

#ifndef _LIT_DEFINED_


/* Literal pool buffer */
struct litbuf {
  struct litbuf *next;		/* Next buffer */
  long
    nnib;			/* # of nibbles (one per char) */

  char
    data[1];			/* Buffer storage */
};


/* Literal Pool functions.
 */
extern void
  literal_init(),		/* Initialize */
  literal_end_of_pass(),	/* Declare end of pass - update stats */
  write_literal_pool(),		/* Write literal pool to code file */
  free_literals();		/* Destroy literal pool chain */

extern long
  lit_begin,			/* Start of literal area */
  lit_end,			/* End of literal area */
  lit_offs,			/* Current literal offset */
  add_literal();		/* Add literal to pool, return address */

#endif
