/* instr.c -- STAR Instruction Table

This file is part of STAR, the Saturn Macro Assembler.

   STAR is not distributed by the Free Software Foundation. Do not ask
them for a copy or how to obtain new releases. Instead, send e-mail to
the address below. STAR is merely covered by the GNU General Public
License.

Please send your comments, ideas, and bug reports to
Jan Brittenson <bson@ai.mit.edu>

*/


/* Copyright (C) 1990 Jan Brittenson.

   STAR is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 1, or (at your option) any
later version.

   STAR is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
for more details.

   You should have received a copy of the GNU General Public License
along with STAR; see the file COPYING. If not, to obtain a copy, write
to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
USA, or send e-mail to bson@ai.mit.edu. */


#include <stdio.h>
#include "sects.h"
#include "star.h"

extern void

  /* Instructions */
  byte1(), fadd(), fbits(), fbrb(), fbrc(), fbrt(), fin(), fmove(),
  fout(), frel(), frotw(), fshfn(), fsrb(), fsub(), fswap(), opc1(),
  opd1(), opsd1(), word3(), word4(), word5(), fslb(),

  /* Directives */
  dbyte(), ddata(), dif(), delse(), dany(), dendif(), drept(),
  ddef(), dorg(), dasc(), dascz(), dalign(), dodd(), deven(),
  derror(), dend(), dexit(), dsave(), drestore(), dmacro(), dradix(),
  dhide(), dstatic(), dfloating(), ddoblock(), ddouble(), ddumpsym(),
  dlibcall(), dsect();


/* Instruction table:
 *
 *	Name		Func	Length, Opcode
 */
struct istruct	instbl[] = {
	{"ADD",		fadd,	0, 0},
	{"ALIGN",	dalign,	1, 0},
	{"AND",		opsd1,	0, 0},
	{"ANY",		dany,	4, 0},
	{"ASCII",	dasc,	1, 0},
	{"ASCIZ",	dascz,	1, 0},
	{"ASECT",	dsect,	0, SC_ASECT},
	{"BRBC",	fbrb,	0, 0},
	{"BRBS",	fbrb,	0, 1},
	{"BRCC",	fbrc,	0, 0},
	{"BRCS",	fbrc,	0, 1},
	{"BREQ",	fbrt,	0, 0},
	{"BRGE",	fbrt,	1, 8},
	{"BRGT",	fbrt,	1, 0},
	{"BRLE",	fbrt,	1, 0xc},
	{"BRLT",	fbrt,	1, 4},
	{"BRNE",	fbrt,	0, 4},
	{"BRNZ",	fbrt,	0, 0xc},
	{"BRZ",		fbrt,	0, 8},
	{"BUSCB",	word4,	0, 0x3808},
	{"BUSCC",	word3,	0, 0xb08},
	{"BUSCD",	word4,	0, 0xd808},
	{"BYTE",	dbyte,	1, 0},
	{"CALL",	frel,	0, 0},
	{"CLR",		opd1,	0, 1},	      /* 1 = 0xA8/D */
	{"CLRB",	fbits,	0, 0},
	{"CONFIG",	word3,	0, 0x508},
	{"CSECT",	dsect,	0, SC_CSECT},
	{"DATA",	ddata,	0, 0},
	{"DEC",		opd1,	0xc, 0},      /* 0 = 0xA0/C */
	{"DEF",		ddef,	3, 1},
	{"DEFINE",	ddef,	3, 0},
	{"DOBLOCK",	ddoblock,0,0},
	{"DOUBLE",	ddouble, 0, 0},
	{"DSECT",	dsect,	0, SC_DSECT},
	{"DUMPSYM",	ddumpsym, 0, 0},
	{"ELSE",	delse,	2, 0},
	{"END",		dend,	0, 0},
	{"ENDIF",	dendif,	4, 0},
	{"ERROR",	derror,	0, 0},
	{"EVEN",	deven,	0, 0},
	{"EXIT",	dexit,	0, 0},
	{"FLOATING",	dfloating, 0, 0},
	{"HIDE",	dhide,  0, 0},
	{"IF",		dif,	1, 0},
	{"IN",		fin,	0, 0},
	{"INC",		opd1,	4, 2},	      /* 2 = 0xB0/E */
	{"INTOFF",	word4,	0, 0xf808},
	{"INTON",	word4,	0, 0x0808},
	{"JUMP",	frel,	0, 1},
	{"LIBCALL",	dlibcall, 0,0},
	{"LSECT",	dsect,	0, SC_LSECT},
	{"MACRO",	dmacro,	0, 0},
	{"MOVE",	fmove,	0, 0},
	{"NEG",		opd1,	8, 3},	      /* 3 = 0xB8/F */
	{"NOP3",	word3,	0, 0x024},
	{"NOP4",	word4,	0, 0x0036},
	{"NOP5",	word5,	0, 0x00046},
	{"NOT",		opd1,	0xc, 3},
	{"ODD",		dodd,	0, 0},
	{"OR",		opsd1,	0, 8},
	{"ORG",		dorg,	1, 0},
	{"ORIGIN",	dorg,	2, 0},
	{"OUT",		fout,	0, 0},
	{"POP",		opc1,	R_C, 0x70},
	{"PSECT",	dsect,	0, SC_PSECT},
	{"PUSH",	opc1,	R_C, 0x60},
	{"RADIX",	dradix,	0, 0},
	{"REPT",	drept,	1, 0},
	{"RESET",	word3,	0, 0xa08},
	{"RESTORE",	drestore, 0, 0},
	{"RET",		byte1,	0, 0x10},
	{"RETBC",	fbrb,	1, 0},
	{"RETBS",	fbrb,	1, 1},
	{"RETCC",	fbrc,	1, 0},
	{"RETCLRC",	byte1,	0, 0x30},
	{"RETCS",	fbrc,	1, 1},
	{"RETEQ",	fbrt,	2, 0},
	{"RETGE",	fbrt,	3, 8},
	{"RETGT",	fbrt,	3, 0},
	{"RETI",	byte1,	0, 0xf0},
	{"RETLE",	fbrt,	3, 0xc},
	{"RETLT",	fbrt,	3, 4},
	{"RETNE",	fbrt,	2, 4},
	{"RETNZ",	fbrt,	2, 0xc},
	{"RETSETC",	byte1,	0, 0x20},
	{"RETSETXM",	byte1,	0, 0x00},
	{"RETZ",	fbrt,	2, 8},
	{"RLN",		frotw,	0, 0},
	{"RRN",		frotw,	0, 4},
	{"RSI",		word5,	0, 0x01808},
	{"SAVE",	dsave,	0, 0},
	{"SETB",	fbits,	0, 1},
	{"SETDEC",	byte1,	0, 0x50},
	{"SETHEX",	byte1,	0, 0x40},
	{"SHUTDN",	word3,	0, 0x708},
	{"SLB",		fslb,	0, 0},
	{"SLN",		fshfn,	0, 0},
	{"SRB",		fsrb,	0, 0},
	{"SREQ",	word3,	0, 0xe08},
	{"SRN",		fshfn,	0, 4},
	{"STATIC",	dstatic,0, 0},
	{"SUB",		fsub,	0, 0},
	{"SUBN",	fsub,	0, 1},
	{"SWAP",	fswap,	0, 0},
	{"UNCNFG",	word3,	0, 0x408},
	{"",		byte1,	0, 0}
	};
