;;
;;   HP-48SX Standard Macro Library
;;   Copyright (C) 1990 Jan Brittenson
;;

	save list
	list=0
	if pass == 1 && !def hp48loaded

;;
;; This file is part of STAR, the Saturn Macro Assembler.
;; 
;;    STAR is not distributed by the Free Software Foundation. Do not ask
;; them for a copy or how to obtain new releases. Instead, send e-mail to
;; the address below. STAR is merely covered by the GNU General Public
;; License.
;; 
;; Please send your comments, ideas, and bug reports to
;; Jan Brittenson <bson@ai.mit.edu>
;; 

;;
;; Copyright (C) 1990 Jan Brittenson.
;; 
;;    STAR is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by the
;; Free Software Foundation; either version 1, or (at your option) any
;; later version.
;; 
;;    STAR is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
;; for more details.
;; 
;;    You should have received a copy of the GNU General Public License
;; along with STAR; see the file COPYING. If not, to obtain a copy, write
;; to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
;; USA, or send e-mail to bson@ai.mit.edu.
;;

; HP-48SX Type prefixes

	type_type = x'28fc
	type_real = x'2933
	type_complex = x'2977
	type_string = x'2a2c
	type_array = x'29e8
	type_list = x'2a74
	type_global = x'2e48
	type_local   = x'2e6d
	type_program = x'2d9d
	type_algebraic = x'2ab8
	type_binary = x'2a4e
	type_grob = x'2b1e
	type_tagged = x'2afc
	type_unit = x'2ada
	type_xlib = x'2e92
	type_function = x'2e92
	type_command = x'2e92
	type_directory = x'2a96
	type_library = x'2b40
	type_backup = x'2b62
	type_address = x'2911
	type_short = x'2911
	type_longreal = x'2955
	type_longcomplex = x'299d
	type_linkedarray = x'2a0a
	type_character = x'29bf
	type_code = x'2dcc
	type_librarydata = x'2b88
	type_2baa = x'2baa
	type_2bcc = x'2bcc
	type_2bee = x'2bee
	type_2c10 = x'2c10
	type_user1 = type_2baa
	type_user2 = type_2bcc
	type_user3 = type_2bee
	type_user4 = type_2c10

	hide	type_type, type_real, type_complex, type_string
	hide	type_array, type_list, type_global, type_local
	hide	type_program, type_algebraic, type_binary, type_grob
	hide	type_tagged, type_unit, type_xlib, type_function
	hide	type_command, type_directory, type_library, type_backup
	hide	type_address, type_short, type_longreal, type_longcomplex
	hide	type_linkedarray, type_character, type_code, type_librarydata
	hide	type_2baa, type_2bcc, type_2bee, type_2c10
	hide	type_user1, type_user2, type_user3, type_user4

	Array = type_array
	List = type_List
	Prg = type_program
	Algebraic = type_algebraic
	Unit = type_unit
	Dir = type_directory

	hide	Array, List, Prg, Algebraic, Unit, Dir

; Address map
	
	static	 0, x'6ffff
	floating x'70000, x'fffff


; Some useful symbols and macros

	false=0
	true=!false

	hide false, true

	; Display type warnings if enabled

	warnings=true

	macro warning	message=`'
	  if warnings
	    error Warning - $message
 	  endif
	endmacro

	hide	warning, warnings

	; EQU-style assignment

sym:	macro equ	value=0
	
	value=$value

	if sym == `'
	  error Bad EQU statement - missing symbol
	else
	  if typeof value != 1
	    warning Possibly nonportable EQU statement
	  endif
	  &sym = value
	endif

	endmacro

	hide	equ

	; Enable listing of block

	macro listblock
	  save list
	  list = 1
	  hide list
	endmacro

	hide	listblock

	; Disable listing of block

	macro nlistblock
	  save list
	  list = 0
	  hide list
	endmacro

	hide	nlistblock

	; End of list block

	macro endlist
	  restore list
	  hide list
	endmacro

	hide	endlist


; Compute address of operand.
; For clarity, no defaults are defined.

  macro	addr	operand, dest

	save	sym, tmp, ntmp
	sym  = gensym

	dest = uc^`$dest'

	if `$dest' == `A'
	  tmp = `C'
	  ntmp= `A'
	else
	  tmp = `A'
	  ntmp= `C'
	endif

	move    pc, $tmp
	$sym = .

	if (`$dest' == `D0') || (`$dest' == `D1')
	  move.5 ($operand)-$sym, $dest
	  swap    $ntmp, $dest
	  add.a   $tmp, $ntmp
	  swap    $ntmp, $dest
	else
	  move.p5 ($operand)-$sym, $dest
	  add.a   $tmp, $dest
	endif
	
	restore	tmp, ntmp, sym

  endmacro

	hide	addr

; Standard kermit preamble

	macro header rom_ver=``D''

	if pass == 3
	rom_ver = uc^$rom_ver

	if typeof rom_ver != 2
	  warning `$rom_ver' is not a string
	endif

	ascii	`HPHP48-'
	data.b	rom_ver
	else
	data.b	0,0,0,0,0,0,0,0
	endif
	endmacro

	hide	header


; RPL block
; Read a block of code and apply data.a operator to it.
;
;	RPL
;	  ...body...
;	ENDRPL

	macro	__rpl	arg=``0''
	  arg = $arg
	  if arg l% 1 == `_'
	    $(arg r% 2)
	  else
	    data.a  $arg
	  endif
	endmacro

	macro	rpl
	  doblock __rpl, `ENDRPL'
	endmacro

	hide	__rpl, rpl


; Type Code (CODE block)
; Read a block of code, apply null to it, and build code data.
;
;	CODE
;	  ...ml body...
;	ENDCODE

	macro	__code	arg=``''
	arg = $arg
	$arg
	endmacro


	macro	code
	  save	beginsym, endsym

	  beginsym = gensym
	  endsym = gensym

	  data.a  type_code

	  $beginsym = .
	  data.a  $endsym-$beginsym

	  doblock  __code, `ENDCODE'

	  $endsym = .

	  restore  beginsym, endsym
	endmacro

	hide	__code, code

; XLIB function ref
; 	FUNCTION  major, minor
;
	macro	function major=0, minor=0
	major=$major
	minor=$minor

	if typeof major != 1
	  warning XLIB major `$major' is not integer
	endif

	if typeof minor != 1
	  warning XLIB minor `$minor' is not integer
	endif

	data.a	type_function
	data.3	major, minor
	endmacro		

	hide	function

; Type Real

	macro real r=`0.0'

	r = $r

	if (typeof r != 4) && (typeof r != 1)
	  warning `$r' is neither real nor integer
	endif

	data.a	type_real
	double	r
	endmacro

	hide	real

; Complex

	macro complex re=`0.0',im=`0.0'

	re=$re
	im=$im

	if (typeof re != 4) && (typeof re != 1)
	  warning Real part `$re' is neither real nor integer
	endif

	if (typeof im != 4) && (typeof im != 1)
	  warning Imaginary part `$im' is neither real nor integer
	endif

	data.a	type_complex
	double	re, im
	endmacro

	hide	complex

; String

	macro string str=``''

	str=$str

	if typeof str != 2
	  warning `$str' is not string
	endif

	data.a	type_string
	data.a	sz^str * 2 + 5
	ascii	str

	endmacro

	hide	string

; Global name

	macro global name=``''

	name=$name

	if typeof name != 2
	  warning `$name' is not string
	endif

	data.a	type_global
	data.b	sz^name
	ascii	name

	endmacro

	hide	global

; Local name

	macro local name=``''

	name=$name

	if typeof name != 2
	  warning `$name' is not string
	endif

	data.a	type_local
	data.b	sz^name
	ascii	name

	endmacro

	hide	local

; Binary

	macro binary value=0, digits=16

	digits=$digits
	value=$value

	if typeof value != 1
	  warning `$value' is not integer
	endif

	data.a	type_binary
	data.a	digits+5

	data.$digits value

	endmacro

	hide	binary

; Short/address

	macro short s=0

	s = $s
	
	if typeof s != 1
	  warning `$s' is not integer
	endif

	data.a	type_short
	data.a	s

	endmacro

	; Alias

	address = short

	hide	address, short

; Character

	macro character ch=0

	ch=$ch

	if (typeof ch != 1) && (typeof ch != 2)
	  warning $ch is neither integer nor string
	endif

	data.a	type_character
	data.b	ch
	endmacro

	hide	character

;
	hp48loaded=true
	hide	hp48loaded

	endif	; pass == 1
	
	.=x'70000

	endlist
