/* formats.h -- formats header
 */

#ifndef _FMT_CONFG_
#define _FMT_CONFG_

/* Each format description is an array of subdescriptions.
 * A subdescription may in turn refer to yet another subdescriptions.
 */

struct format_ent {
  short
    ftype;			/* Format type, see FT_xxx below */

  int
    width,			/* Format width, type dependent */
    repeat;			/* Format repeat factor */
    
  union {
    struct format
      *sf;			/* Reference to subdescription, if any */
  }
  t_v;
};


#define fmtdescr t_v.sf

struct format {
  short
    nformats;			/* Number of formats in .fmtspec[] */

  struct format_ent
    fmtspec[1];			/* Token declaration */
};


#define FT_DATA_MASK 077
#define FT_HEX 1		/* Hex number */
#define FT_DEC 2		/* Decimal number */
#define FT_OCT 3		/* Octal number */
#define FT_BIN 4		/* Binary number */
#define FT_STR 5		/* String */
#define FT_VSTR 6		/* Vectored string */
#define FT_VHEX 7		/* Vectored hex data */
#define FT_FLOAT 010		/* Decimal floating point */

#define FT_CODE_MASK 0100
#define FT_CODE 0100		/* ML code */

#define FT_RPL_MASK 0200
#define FT_RPL  0200		/* RPL code */

#define FT_SUBD 01000		/* Identifies a subdescription */



extern
  nautoformats, nformats, format_added, fmtseq;

extern void
  fmt_free(), load_formats(), fmt_print(),
  add_auto_format(), add_autos_to_fmttab(), print_format_file();

extern struct format
  *formatp();

extern struct symbol
  *fmtroot,
  **fmtref,
  *fmt();

#endif
