#include "dis48.h"
#include <errno.h>

void
#ifdef ANSI
StuffNybble(char *mem, NAddr addr, Nybble n)
#else
StuffNybble(mem, addr, n)
char	*mem;
NAddr	addr;
Nybble	n;
#endif
{
	char	t;
	
	t = mem[addr >> 1] & ((addr & 1) ? 0x0f : 0xf0);
	n &= 0xf;
	if (addr & 1)
		n <<= 4;
		
	mem[addr >> 1] = t | n;
}

#define SIZE	262144

#ifdef ANSI
main(int argc, char **argv)
#else
main(argc, argv)
int	argc;
char	**argv;
#endif
{
	char	*p;
	int	n;
	FILE	*fp;
	NAddr	addr, a;
	char	buf[25];
	char	*mem, *malloc();
	
	if ((mem = malloc(SIZE)) == NULL) {
		fprintf(stderr, "malloc failed\n");
		exit(1);
	}
	
	argc--;
	argv++;
	addr = NOADDR;
	while (argc > 0) {
		if ((fp = fopen(argv[0], "r")) == NULL) {
			fprintf(stderr, "fopen: %s %d\n", argv[0], errno);
			continue;
		}
		
		while (fread(buf, sizeof(char), sizeof(buf), fp) != NULL) {
			if (sscanf(buf, "%*c%5x:", &a) != 1) {
				fprintf(stderr, "Format bad '%s'\n", buf);
				break;
			}
			
			if (addr == NOADDR)
				addr = a;
				
			else if (a != addr)
				fprintf(stderr, "\nAddr mismatch %x '%s'\n",
						addr, buf);
						
			for (n = 16, p = &buf[7]; --n >= 0; p++, addr++) {
				if ((*p >= '0') && (*p <= '9'))
					*p -= '0';
					
				else if ((*p >= 'A') && (*p <= 'F'))
					*p -= 'A' - 10;
					
				else {
					fprintf(stderr, "Bad char '%c'\n", *p);
					break;
				}
				
				StuffNybble(mem, addr, *p);
			}
		}
		
		fclose(fp);
		argc--;
		argv++;
	}
	
	if ((fp = fopen("dump.out", "w")) == NULL) {
		fprintf(stderr, "fopen dump.out\n");
		exit(1);
	}
	
	if (fwrite(mem, sizeof(char), SIZE, fp) != SIZE)
		fprintf(stderr, "fwrite\n");
		
	fclose(fp);
	exit(0);
}
