static char rcs_stuff[] = "$Id: gedmain.c,v 1.2 1992/01/03 17:49:53 murf Exp $";
#include <stdio.h>
#include "gedcom.h"
extern int lineno;
extern int yydebug;
/*
# Copyright (C) 1992 Steven Michael Murphy
#
#
# This file is part of gcom, the GEDCOM file merging utility for UNIX,
# 
# 
# gcom is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# gcom is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with gcom; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

int main(argc,argv)
char **argv;int argc;
{
	struct gedfile ged1,ged2;
	extern FILE *yyin;
	int begind, begfam;
	
	if( argc != 3 )
	{
		fprintf(stderr,"HEY! I need two gedcom files, a 'home' and an 'additional' on the command line!\n");
		exit(1);
	}
	yyin = fopen(argv[1],"r");
	if( !yyin )
	{
		fprintf(stderr,"Could not open %s for reading!\n", argv[1]);
		exit(1);
	}

 	/* yydebug =1; */
 	fprintf(stderr,"Starting on REF database..\n");
	curr_file = &ged1;
	clear_gedfile();
	yyparse();
	fprintf(stderr,"Done\n");
 	fprintf(stderr,"Processed %d families with %d individuals!\n",
 			curr_file->famlist->num,curr_file->indlist->num);
	begind = curr_file->indlist->num;
	begfam = curr_file->famlist->num;
	fclose(yyin);
	
    /* now, pick up another database. That'll be the one to add in*/
		
	yyin = fopen(argv[2],"r");
	if( !yyin )
	{
		fprintf(stderr,"Could not open %s for reading!\n", argv[2]);
		exit(1);
	}
 	fprintf(stderr,"Starting on ADDITIONAL database..\n");
	curr_file = &ged2;
	clear_gedfile();
	lineno = 0;
	/* yyrestart(yyin); */
 	/* yydebug =1; */
	yyparse();
	fprintf(stderr,"Done\n");
 	fprintf(stderr,"Processed %d families with %d individuals!\n",
 			curr_file->famlist->num,curr_file->indlist->num);
	fclose(yyin);
	
	/* now, pump out the home database */
	find_correspondence(&ged1,&ged2);
	/* malloc_debug(2); */
	merge_dbs(&ged1,&ged2);

	fprintf(stderr,"This process added %d individuals and %d families to the\n\
Ref database in all.\n", 
			ged1.indlist->num-begind, ged1.famlist->num-begfam);
	
	fprintf(stderr,"Writing database 'newdatabase.gedcom'...\n");
	ged1.header->file = "newdatabase.gedcom";
	write_gedfile(&ged1);
	return 0;
}
