%{
/*
# Copyright (C) 1992 Steven Michael Murphy
#
#
# This file is part of gcom, the GEDCOM file merging utility for UNIX,
# 
# 
# gcom is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# gcom is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with gcom; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#include <string.h>
#include "gedcom.b.tab.h"
extern int lineno;
static char rcs_stuff[] = "$Id: gedcom.lex,v 1.2 1992/01/03 17:49:48 murf Exp $";
/* below follows a list of all the tokens allowed in GEDCOM files */

%}
optfield		([ ].+)?$

%%
BIC		{ return BIC; }
STILLBORN	{ return STILLBORN;}
CLEARED		{ return CLEARED; }
UNCLEARED	{ return UNCLEARED; }
DNS		{ return DNS; }
SEENOTES	{ return SEENOTES; }
SUBMITTED	{ return SUBMITTED; }
COMPLETED	{ return COMPLETED; }
CHILD	{ return CHILD; }
INFANT	{ return INFANT; }
CANCELLED	{ return CANCELLED; }
DNS/CAN	{ return DNSCAN; }
ADDR[ ].+$		{ setyystr(yytext); return ADDR;}
BAPL([ ].+$)?		{setyystr(yytext);return BAPL;}
BIC{optfield}	{ setyystr(yytext); return BIC;}
BIRT		{return BIRT;}
BURI		{return BURI;}
CHAR[ ].*$		{setyystr(yytext); return CHAR;}
CHIL		{return CHIL;}
CHR		{return CHR;}
COMM[ ].*$		{setyystr(yytext); return COMM;}
CONT[ ].*$		{setyystr(yytext); return CONT;}
DATE[ ].*$		{setyystr(yytext); return DATE;}
DEAT		{return DEAT;}
DEST[ ].*$		{setyystr(yytext); return DEST;}
DIV[ ].*$		{if( yytext[4] == 'Y' ) yylval.num =1;
			else yylval.num = 0; return DIV;}
ENDL		{return ENDL;}
FAM			{return FAM;}
FAMC		{return FAMC;}
FAMS		{return FAMS;}
FILE[ ].*$		{setyystr(yytext); return FILE9;}
FLAG.+$		{setyystr(yytext); return FLAG;}
HEAD		{return HEAD;}
HUSB		{return HUSB;}
INDI		{return INDI;}
MARR		{return MARR;}
NAME[ ].*$	{setyystr(yytext); return NAME;}
NOTE[ ].*$		{setyystr(yytext); return NOTE;}
NUMB[ ].*$		{yylval.num = atoi(yytext+6); return NOTE;}
PHON[ ].*$		{setyystr(yytext); return PHON;}
PLAC[ ].*$		{setyystr(yytext); return PLAC;}
QUAL.*$			{setyystr(yytext); return QUAL;}
REFN{optfield}	{ setyystr(yytext); return REFN;}
REL[ ].*$			{setyystr(yytext); return REL;}
SEX[ ].*$		{setyystr(yytext); return SEX;}
SLGC		{return SLGC;}
SLGS	{return SLGS;}
SOUR[ ].*$	{setyystr(yytext); return SOUR;}
STAL			{return STAL;}
SUBM			{return SUBM;}
TEMP[ ].+$		{setyystr(yytext); return TEMP;}
TITL[ ].*$		{setyystr(yytext); return TITL;}
TRLR		{return TRLR;}
WIFE		{return WIFE;}
@[^@]+@		{int x; 
						x = strlen(yytext);
						yylval.str = (char *)malloc(x);
						strncpy(yylval.str,yytext+1,x-2);
						yylval.str[x-2]=0;
						return REF;}
^0		{yylval.num = 0; return LEV0; }
^1		{yylval.num = 0; return LEV1; }
^2		{yylval.num = 0; return LEV2; }
^3		{yylval.num = 0; return LEV3; }
^[4-9]+		{yylval.num = atoi(yytext); return LEV3;}
\n					{lineno++;}
[ 	]*				{}
%%
setyystr(txt)
char *txt;
{
	int x=strlen(txt);
	char *y = txt;
	while( *y && *y != ' ' )
		y++;
	if( *y )
	{
		/* there is a space */
		x -= (y-txt);
		y++;
		yylval.str = (char *)malloc(x);
		strcpy(yylval.str,y);
	}
	else
		yylval.str = "";
}
