/*================================================================
 * delete.c -- Removes person and family records from database.  
 * Copyright(c) 1992 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 15 Aug 93 - modified
 *================================================================
 */
#include <stdio.h>
#include "standard.h"
#include "table.h"
#include "gedcom.h"

extern STRING idpdel, cfpdel, haslnk;

/*================================================================
 * delete_indi -- Delete person from database; all links to it are
 *   removed; if this leaves a family without links it is removed.
 *==============================================================*/
delete_indi (indi, conf)
NODE indi;	/* person to remove */
BOOLEAN conf;	/* have user confirm */
{
	STRING key;
	NODE name, sex, body, famc, fams;
	INT isex, keyint;
	NODE node, husb, wife, chil, rest, fam, prev, next;
	BOOLEAN found;

	if (!indi && !(indi = ask_for_indi(idpdel, FALSE, FALSE)))
		return;
	if (conf && !ask_yes_or_no(cfpdel)) return;
	split_indi(indi, &name, &sex, &body, &famc, &fams);
	if (!fams) goto checkfamc;
	isex = val_to_sex(sex);
	ASSERT(isex != SEX_UNKNOWN);
	for (node = fams; node; node = nsibling(node)) {
		fam = key_to_fam(rmvat(nval(node)));
		split_fam(fam, &husb, &wife, &chil, &rest);
		ASSERT(husb || wife || chil);
		if (isex == SEX_MALE) {
			ASSERT(husb && eqstr(nval(husb), nxref(indi)));
			free_nodes(husb);
			husb = NULL;
		} else {
			ASSERT(wife && eqstr(nval(wife), nxref(indi)));
			free_nodes(wife);
			wife = NULL;
		}
		join_fam(fam, husb, wife, chil, rest);
		if (!husb && !wife && !chil)
			delete_fam(fam);
		else
			fam_to_dbase(fam);
	}
checkfamc:
	if (famc) {
		fam = key_to_fam(rmvat(nval(famc)));
		split_fam(fam, &husb, &wife, &chil, &rest);
		ASSERT(husb || wife || chil);
		found = FALSE;
		prev = NULL;
		node = chil;
		while (node) {
			if (!strcmp(nxref(indi), nval(node))) {
				found = TRUE;
				break;
			}
			prev = node;
			node = nsibling(node);
		}
		ASSERT(found);
		next = nsibling(node);
		if (!prev)
			chil = next;
		else
			nsibling(prev) = next;
		nsibling(node) = NULL;
		free_nodes(node);
		join_fam(fam, husb, wife, chil, rest);
		if (!husb && !wife && !chil)
			delete_fam(fam);
		else
			fam_to_dbase(fam);
	}
	key = rmvat(nxref(indi));
	keyint = atoi(key + 1);
	addixref(keyint);
	remove_indi_cache(key);
	for (node = name; node; node = nsibling(node))
		remove_name(nval(node), key);
	remove_from_browse_lists(key);
	del_in_dbase(key);
	join_indi(indi, name, sex, body, famc, fams);
	free_nodes(indi);
}
/*=============================================
 * delete_fam -- Delete a family from database.
 *===========================================*/
delete_fam (fam)
NODE fam;
{
	STRING key;
	NODE husb, wife, chil, rest;
	INT keyint;

	if (!fam) return;
	split_fam(fam, &husb, &wife, &chil, &rest);
	if (husb || wife || chil) {
		message(haslnk);
		join_fam(fam, husb, wife, chil, rest);
		return;
	}
	key = rmvat(nxref(fam));
	keyint = atoi(key + 1);
	addfxref(keyint);
	remove_fam_cache(key);
	del_in_dbase(key);
	join_fam(fam, husb, wife, chil, rest);
	free_nodes(fam);
}
/*==================================================
 * split_fam -- Split a family into important parts.
 *================================================*/
split_fam (fam, phusb, pwife, pchil, prest)
NODE fam, *phusb, *pwife, *pchil, *prest;
{
	NODE node, rest, last, husb, lhsb;
	NODE wife, lwfe, chil, lchl, prev;
	STRING tag;

	rest = last = husb = wife = chil = lchl = lhsb = lwfe = NULL;
	prev = NULL;
	node = nchild(fam);
	nchild(fam) = NULL;
	while (node) {
		tag = ntag(node);
		if (eqstr("HUSB", tag))
			if (husb)
				lhsb = nsibling(lhsb) = node;
			else
				husb = lhsb = node;
		else if (eqstr("WIFE", tag))
			if (wife)
				lwfe = nsibling(lwfe) = node;
			else
				wife = lwfe = node;
		else if (eqstr("CHIL", tag)) {
			if (chil)
				lchl = nsibling(lchl) = node;
			else
				chil = lchl = node;
		} else if (rest)
			last = nsibling(last) = node;
		else
			last = rest = node;
		prev = node;
		node = nsibling(node);
		nsibling(prev) = NULL;
	}
	*phusb = husb;
	*pwife = wife;
	*pchil = chil;
	*prest = rest;
}
/*================================================
 * join_fam -- Join a family from important parts.
 *==============================================*/
join_fam (fam, husb, wife, chil, rest)
NODE fam, husb, wife, chil, rest;
{
	NODE node = NULL;
	nchild(fam) = NULL;
	if (husb) {
		nchild(fam) = node = husb;
		while (nsibling(node))
			node = nsibling(node);
	}
	if (wife) {
		if (node)
			node = nsibling(node) = wife;
		else
			nchild(fam) = node = wife;
		while (nsibling(node))
			node = nsibling(node);
	}
	if (rest) {
		if (node)
			node = nsibling(node) = rest;
		else
			nchild(fam) = node = rest;
		while (nsibling(node))
			node = nsibling(node);
	}
	if (chil) {
		if (node)
			nsibling(node) = chil;
		else
			nchild(fam) = chil;
	}
}
/*==================================================
 * del_in_dbase -- Write deleted record to database.
 *================================================*/
static del_in_dbase (key)
STRING key;
{
	if (!key || *key == 0) return;
	ASSERT(store_record(key, "DELE\n", 5));
}
