/*================================================================
 * traverse.c -- Interpret general traversal iteration.
 * Copyright(c) 1991 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 1993 - controlled
 *   Version 2.3.5 - 31 Aug 1993 - modified
 *================================================================
 */
#include <stdio.h>
#include "standard.h"
#include "table.h"
#include "gedcom.h"
#include "interp.h"

/*================================================
 * interp_traverse -- Interpret traverse iterator.
 *==============================================*/
BOOLEAN interp_traverse (node, stab)
INTERP node; TABLE stab;
{
	NODE cnode, stack[100];
	BOOLEAN eflg;
	INT lev = -1;
	NODE root = (NODE) evaluate (inode(node), stab, &eflg);
	if (eflg || !root) return FALSE;
	stack[++lev] = cnode = root;
	while (TRUE) {
		insert_table(stab, isubnode(node), (WORD) cnode);
		insert_table(stab, ilev(node), (WORD) lev);
		if (!interpret(ibody(node), stab)) return FALSE;
		if (nchild(cnode)) {
			cnode = stack[++lev] = nchild(cnode);
			continue;
		}
		if (nsibling(cnode)) {
			cnode = stack[lev] = nsibling(cnode);
			continue;
		}
		while (--lev >= 0 && !nsibling(stack[lev]))
			;
		if (lev < 0) break;
		cnode = stack[lev] = nsibling(stack[lev]);
	}
	return TRUE;
}
