/*===================================================================
 * interp.h - This is the header file for the report interpreter
 *   feature.
 * Copyright(c) 1991 by Thomas T. Wetmore IV; all rights reserved.
 *  Version 2.3.4 - 24 Jun 93 - controlled
 *  Version 2.3.5 - 16 Aug 93 - modified
 *===================================================================
 */
typedef struct itag *INTERP;
struct itag {
	char i_type;
	WORD i_word1;
	WORD i_word2;
	WORD i_word3;
	WORD i_word4;
	WORD i_word5;
	INT  i_line;
	INTERP i_next;
};

#define ILITERAL  1
#define IIDENT    2
#define ICHILDREN 3
#define ISPOUSES  4
#define IPROC     5
#define IFUNC     6
#define IIF       7
#define IFAMILIES 8
#define IICONS    9
#define IWHILE   10
#define ICALL    11
#define IINDICES 12
#define IINDI    13
#define INOTES   14
#define INODES   15
#define ILIST    16
#define ITRAV    17
#define IFAM     18

/*=================== in all types ===================*/
#define itype(i)     ((i)->i_type)
#define inext(i)     ((i)->i_next)
#define iline(i)     ((i)->i_line)
/*=================== in literal nodes ===============*/
#define iliteral(i)  ((i)->i_word1)
/*================== in ident nodes ==================*/
#define iident(i)    ((i)->i_word1)
#define ielist(i)    ((i)->i_word2)
#define ifunc(i)     ((i)->i_word3)
/*=================== in icons nodes ==============*/
#define iicons(i)    ((i)->i_word1)
/*=================== in children nodes ==============*/
#define ifamily(i)   ((i)->i_word1)
#define ichild(i)    ((i)->i_word2)
#define inum(i)      ((i)->i_word4)
#define ibody(i)     ((i)->i_word5)
/*=================== in children, spouse nodes ======*/
#define iprinc(i)    ((i)->i_word1)
#define ispouse(i)   ((i)->i_word2)
#define ifamvar(i)   ((i)->i_word3)
/*=================== in forindex loop nodes ======*/
#define iindex(i)    ((i)->i_word1)
#define iindivar(i)  ((i)->i_word2)
#define ivalvar(i)   ((i)->i_word3)
/*=================== in proc nodes ==================*/
#define iname(i)     ((i)->i_word1)
#define iparams(i)   ((i)->i_word2)
/*===================== in if nodes ==================*/
#define icond(i)     ((i)->i_word1)
#define ithen(i)     ((i)->i_word2)
#define ielse(i)     ((i)->i_word3)
/*===================== in call nodes ================*/
#define iargs(i)     ((i)->i_word2)
/*===== in fornotes, forparas, forsents nodes ========*/
#define inode(i)     ((i)->i_word1)
#define istrng(i)    ((i)->i_word2)
#define isubnode(i)  ((i)->i_word2)
/*================= in traverse nodes ================*/
#define ilev(i)      ((i)->i_word3)
/*================= in forlist nodes =================*/
#define ilist(i)     ((i)->i_word1)
#define ielement(i)  ((i)->i_word2)
/*====================================================*/

extern INTERP literal_node();
extern INTERP children_node();
extern INTERP iden_node();
extern INTERP proc_node();

typedef struct {
	STRING ft_name;
	INT ft_nparms_min;
	INT ft_nparms_max;
	WORD (*ft_eval)();
} BUILTINS;

extern BUILTINS builtins[];
extern INT nobuiltins;

extern TABLE globtab;

extern WORD evaluate();
extern WORD evaluate_iden();
extern WORD evaluate_func();
extern WORD evaluate_cond();
extern NODE eval_indi();
extern NODE eval_fam();
extern WORD valueof_iden();
extern STRING get_date();

extern INT rplineno;
extern FILE *ofp;
extern INT curcol;
extern INT currow;
extern INT _rows;
extern INT _cols;
extern INT semerrors;
extern INT nobuiltins;

#define UNBUFFERED 0
#define BUFFERED   2
#define PAGEMODE   3

