/*================================================================
 * gedcom.h -- Master header file of LifeLines system.
 * Copyright(c) 1992 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 02 Sep 93 - modified
 *================================================================
 */
#define MAXNAMELEN 512

#define OKAY  1
#define ERROR 0
#define DONE -1

/*===============================================================
 * NODE -- Holds internal form of persons and families; each NODE
 *   is a single GEDCOM line.
 *==============================================================*/
typedef struct ntag *NODE, NODE_struct;
struct ntag {
	STRING n_xref;		/* cross ref */
	STRING n_tag;		/* tag */
	STRING n_val;		/* value */
	NODE   n_parent;	/* parent */
	NODE   n_child;		/* first child */
	NODE   n_sibling;	/* sibling */
};
#define nxref(n)    ((n)->n_xref)
#define ntag(n)     ((n)->n_tag)
#define nval(n)     ((n)->n_val)
#define nparent(n)  ((n)->n_parent)
#define nchild(n)   ((n)->n_child)
#define nsibling(n) ((n)->n_sibling)

#define SEX_MALE    1
#define SEX_FEMALE  2
#define SEX_UNKNOWN 3

#define BROWSE_INDI 1
#define BROWSE_FAM  2
#define BROWSE_PED  3
#define BROWSE_TAND 4
#define BROWSE_QUIT 5
#define BROWSE_2FAM 6
#define BROWSE_LIST 7

extern INT lineno;
extern BOOLEAN inited;
extern BOOLEAN keyflag;
extern STRING editstr;
extern STRING editfile;
extern STRING llreports;
extern TABLE placabbvs;		/* table for place abbrvs */
extern TABLE tagtable;		/* table for GEDCOM tags */

NODE add_child();
NODE add_family();
NODE add_indi_by_edit();
NODE add_unlinked_indi();
STRING addat();
STRING alloc_string();
NODE ask_for_fam();
FILE *ask_for_file();
NODE ask_for_indi();
STRING ask_for_indi_key();
STRING ask_for_string();
BOOLEAN check_name();
NODE choose_child();
NODE choose_family();
NODE choose_spouse();
NODE copy_nodes();
NODE create_node();
NODE edit_family();
NODE edit_indi();
STRING event_to_date();
STRING event_to_plac();
STRING event_to_string();
NODE fam_to_husb();
NODE fam_to_wife();
BOOLEAN fgetline();
NODE file_to_node();
NODE find_tag();
NODE first_fp_to_node();
FILE *fopenpath();
NODE format_and_choose_indi();
STRING full_value();
STRING *get_child_strings();
STRING *get_family_strings();
STRING *get_names();
STRING *get_person_strings();
STRING *get_spouse_strings();
INT getfinitial();
STRING getfxref();
STRING getixref();
STRING getsurname();
STRING indi_to_event();
NODE indi_to_famc();
NODE indi_to_fath();
STRING indi_to_list_string();
NODE indi_to_moth();
STRING indi_to_name();
NODE indi_to_next_sib();
NODE indi_to_prev_sib();
NODE key_to_fam();
NODE key_to_indi();
STRING manip_name();
NODE merge_two_fams();
NODE merge_two_indis();
STRING name_string();
STRING name_surfirst();
NODE next_fp_to_node();
BOOLEAN node_to_file();
NODE node_to_node();
STRING node_to_string();
NODE remove_dupes();
BOOLEAN retrieve_file();
STRING retrieve_record();
STRING rmvat();
BOOLEAN sgetline();
STRING shorten_date();
STRING shorten_plac();
NODE sort_children();
STRING soundex();
BOOLEAN store_file();
BOOLEAN store_record();
NODE string_to_node();
STRING trim();
STRING trim_name();
NODE unique_nodes();

#define fam_to_event indi_to_event

#define NAME(indi)  find_tag(nchild(indi),"NAME")
#define SEX(indi)   val_to_sex(find_tag(nchild(indi),"SEX"))
#define BIRT(indi)  find_tag(nchild(indi),"BIRT")
#define DEAT(indi)  find_tag(nchild(indi),"DEAT")
#define BAPT(indi)  find_tag(nchild(indi),"CHR")
#define BURI(indi)  find_tag(nchild(indi),"BURI")
#define FAMC(indi)  find_tag(nchild(indi),"FAMC")
#define FAMS(indi)  find_tag(nchild(indi),"FAMS")

#define HUSB(fam)   find_tag(nchild(fam),"HUSB")
#define WIFE(fam)   find_tag(nchild(fam),"WIFE")
#define MARR(fam)   find_tag(nchild(fam),"MARR")
#define CHIL(fam)   find_tag(nchild(fam),"CHIL")

#define DATE(evnt)   find_tag(nchild(evnt),"DATE")
#define PLAC(evnt)   find_tag(nchild(evnt),"PLAC")

#define indi_to_key(indi)  (rmvat(nxref(indi)))
#define fam_to_key(fam)    (rmvat(nxref(fam)))
#define num_families(indi) (node_list_length(FAMS(indi)))
#define num_children(fam)  (node_list_length(CHIL(fam)))

#define FORCHILDREN(fam,child,num) \
	{\
	NODE __cnode = find_tag(nchild(fam), "CHIL");\
	NODE child;\
	num = 0;\
	while (__cnode) {\
		child = key_to_indi(rmvat(nval(__cnode)));\
		if (strcmp("CHIL", ntag(__cnode)) || child == NULL)\
			fatal("FORCHILDREN -- ARRGHH");\
		num++;\
		{
#define ENDCHILDREN \
		}\
		__cnode = nsibling(__cnode);\
	}}
#define FORSPOUSES(indi,spouse,fam,num) \
	{\
	NODE __fnode = FAMS(indi);\
	INT __sex = SEX(indi);\
	NODE spouse;\
	NODE fam;\
	num = 0;\
	while (__fnode) {\
		fam = key_to_fam(rmvat(nval(__fnode)));\
		if (__sex == SEX_MALE)\
			spouse = fam_to_wife(fam);\
		else\
			spouse = fam_to_husb(fam);\
		if (spouse != NULL) {\
			num++;\
		{
#define ENDSPOUSES \
		}}\
		__fnode = nsibling(__fnode);\
	}}
#define FORFAMILIES(indi,fam,spouse,num) \
	{\
	NODE __fnode = FAMS(indi);\
	INT __sex = SEX(indi);\
	NODE spouse;\
	NODE fam;\
	num = 0;\
	while (__fnode) {\
		fam = key_to_fam(rmvat(nval(__fnode)));\
		if (__sex == SEX_MALE)\
			spouse = fam_to_wife(fam);\
		else\
			spouse = fam_to_husb(fam);\
		num++;\
		{
#define ENDFAMILIES \
		}\
		__fnode = nsibling(__fnode);\
	}}
#define FORTAGVALUES(root,tag,node,value)\
	{\
	NODE node, __node = nchild(root);\
	STRING value, __value;\
	while (__node) {\
		while (__node && strcmp(tag, ntag(__node)))\
			__node = nsibling(__node);\
		if (__node == NULL) break;\
		__value = value = full_value(__node);/*OBLIGATION*/\
		node = __node;\
		{
#define ENDTAGVALUES \
		}\
		if (__value) stdfree(__value);/*RELEASE*/\
		 __node = nsibling(__node);\
	}}
