/*
 *	@(#)unpcb.h	1.1	(Alex Crain)	6/20/89
 *
 *  unpcb.h - unix intern protocol control block.
 *
 *  Written by Alex Crain.
 *
 *  This file is loosly based in the Berkeley file unpcb.h,
 *  but is *not* guarenteed to be in any way compatable. It is
 *  close enough to the Berkeley code that the following applies...
 *
 *  Copyright (c) 1982, 1986, 1988 Regents of the University of California.
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms are permitted
 *  provided that this notice is preserved and that due credit is given
 *  to the University of California at Berkeley. The name of the University
 *  may not be used to endorse or promote products derived from this
 *  software without specific prior written permission. This software
 *  is provided "as is" without express or implied warranty.
 *
 */

#ifndef _unpcb_h_
#define _unpcb_h_

#include <uipc/conf.h>

struct unpcb {
   struct	socket * unp_socket;	/* backpointer to socket	     */
   struct	inode * unp_inode;	/* file reference		     */
   ino_t	unp_ino;		/* fake inode number		     */
   struct	unpcb * unp_conn;	/* control block of connected socket */
   struct	unpcb * unp_refs;	/* referencing socket liked list     */
   struct	unpcb * unp_nextref;	/* link in unp_refs list	     */
   struct	mbuf * unp_addr;	/* bound address of socket	     */
   int		unp_cc;			/* copy of rcv.sb_cc		     */
   int		unp_mbcnt;		/* copy of rcv.sb_mbcnt		     */
};

#define sotounpcb(so)	((struct unpcb *)((so)->so_pcb))

#endif /* _unpcb_h_ */
