/*
 *	@(#)mbuf.h	1.1	(Alex Crain)	6/20/89
 *
 *  mbuf.h - mbuf description macros
 *
 *  Written by Alex Crain.
 *
 *  This file is loosly based in the Berkeley header file of the 
 *  same name, but is *not* guarenteed to be in any way compatable. It is
 *  close enough to the berkeley code that the following applies...
 *
 *  Copyright (c) 1982, 1986, 1988 Regents of the University of California.
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms are permitted
 *  provided that this notice is preserved and that due credit is given
 *  to the University of California at Berkeley. The name of the University
 *  may not be used to endorse or promote products derived from this
 *  software without specific prior written permission. This software
 *  is provided "as is" without express or implied warranty.
 *
 */

#ifndef _mbuf_h_
#define _mbuf_h_

#include <uipc/conf.h>

#define MSIZE		128

#define MMINOFF		12
#define MTAIL		4
#define MMAXOFF		(MSIZE - MTAIL)
#define MLEN		(MSIZE - MMINOFF - MTAIL)

#define dtom(x)		((struct mbuf *)((int)(x) & ~(MSIZE - 1)))
#define mtod(m, t)	((t)((int)(m) + (m)->m_off))

#define ptom(x)		((struct mbuf *)(((int)(x) << 7) | mbmask))
#define mtop(x, t)	((t)(((int)(x) >> 7) & 0xFFFF))

struct mbuf {
   struct	mbuf * m_next;
   u_long	m_off;
   short	m_len;
   short	m_type;
   u_char	m_dat[MLEN];
   struct	mbuf * m_act;
};

#define MT_FREE		0
#define MT_DATA		1
#define MT_HEADER	2
#define MT_SOCKET	3
#define MT_PCB		4
#define MT_SONAME	8
#define MT_SOOPTS	10
#define MT_RIGHTS	12

/* flags to mget */
#define M_DONTWAIT	0
#define M_WAIT		1

/* length to m_copy to copy all */
#define M_COPYALL	10000000

#define MGET(m, i, t)	\
{  int _s = splimp ();		\
   if ((m) = mfree)	\
    {  if ((m)->m_type != MT_FREE) panic("mget"); (m)->m_type = t; \
       mfree = (m)->m_next; (m)->m_next = (struct mbuf *) 0; \
       (m)->m_off = MMINOFF; } \
   else \
       (m) = m_more (i, t); \
   splx (_s); }

#define MFREE(m, n) \
{  int _s = splimp (); \
   if ((m)->m_type == MT_FREE) panic ("mfree"); \
   (m)->m_type = MT_FREE; \
   (n) = (m)->m_next; (m)->m_next = mfree; mfree = (m); \
   (m)->m_off = 0; (m)->m_act = 0;\
   splx (_s); \
   if (m_want) \
    { m_want = 0; \
      wakeup((caddr_t)&mfree); }}

#ifdef KERNEL
struct mbuf * mfree, * mbmem;
unsigned int mbmask;
int m_want;
struct mbuf * m_get (), * m_getclr(), *m_free (), * m_more (), * m_copy ();
void m_freem ();
#endif

#endif _mbuf_h_
