/*
 *	@(#)conf.h	1.1	(Alex Crain)	6/20/89
 *
 *  conf.h - 3b1 specifics for the uipc driver.
 *
 *  (C) Copyright 1989 Alex Crain
 *
 */

#ifndef _conf_h_
#define _conf_h_

/*
 *  Useful spls. 
 */

#define splimp	spl7
#define splnet	spl5

/*
 *  Useful macros
 */

#define MIN(x, y) ((x) < (y) ? (x) : (y))
#define MAX(x, y) ((x) > (y) ? (x) : (y))

/*
 *  stdata is a pointer to a streams structure, and is referenced in 
 *  sys/inode.h. We rename it here and use it for a socket pointer.
 */

#define stdata socket
#define i_sptr i_socket

/*
 *  I never understood why at&t doesn't offer a complete set of these.
 *  ushort and uint are found in types.h, but uchar() is a kernel function,
 *  so we invent a complete set from scratch.
 */

typedef unsigned long	u_long;
typedef unsigned int	u_int;
typedef unsigned short	u_short;
typedef unsigned char	u_char;

/*
 *  The number of available mbufs
 */

#define NMBUF 512

/*
 *  New signals. The signal numbers are not the same as BSD.
 */

#define SIGURG		22
#define SIGIO		23

/*
 *  New flags for (struct file *)->i_flag
 */

#define FMARK		00040
#define FDEFER		00100

/*
 *  Flags for iomove (addr, len, flag)
 */

#define IO_WRITE	0		/* u.u_base -> addr	*/
#define IO_READ		1		/* addr -> u.u_base	*/

/*
 *  Flags for useracc (addr, len, flag)
 */

#define UACC_READ	0
#define UACC_WRITE	1

/*
 *  define the relationship between file structures and sockets
 */

#define filesock(FP)	mtod (ptom ((FP)->f_offset), struct socket *)
#define sockoffset(SO)	mtop (dtom (SO), off_t)

#endif /* _conf_h_ */
