#ifndef LINT
static char * sccsdef = "@(#)mbuf.c	1.1	(Alex Crain) 6/20/89";
#endif

/*
 *  mbuf.c - high level socket routines
 *
 *  Written by Alex Crain.
 *
 *  This file is based in the Berkeley file uipc_mbuf.c,
 *  but is *not* guarenteed to be in any way compatable. It is
 *  close enough to the Berkeley code that the following applies...
 *
 *  Copyright (c) 1982, 1986, 1988 Regents of the University of California.
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms are permitted
 *  provided that this notice is preserved and that due credit is given
 *  to the University of California at Berkeley. The name of the University
 *  may not be used to endorse or promote products derived from this
 *  software without specific prior written permission. This software
 *  is provided "as is" without express or implied warranty.
 *
 */


#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <uipc/socketvar.h>
#include <uipc/protosw.h>
#include <uipc/domain.h>
#include <uipc/mbuf.h>
#include <uipc/fproto.h>

static char mbuf_data[sizeof (struct mbuf) * (NMBUF + 1)];

/*
 *  Initialize the mbuf map; all free in a null terminated linked list.
 */

void
mbinit()
{
   register int i;

   mfree = mbmem = &(dtom (mbuf_data))[1];
   mbmask = ((unsigned int) mbmem & 0xFF800000);

   for (i = 0; i < NMBUF; i++)
    {
       mbmem[i].m_type = MT_FREE;
       mbmem[i].m_next = &mbmem[i+1];
    }
   mbmem[NMBUF-1].m_next = NULL;
}

/*
 *  get one mbuf structure
 */

struct mbuf *
m_get (canwait, type)
  int canwait, type;
{
   struct mbuf * m;

   MGET (m, canwait, type);
   return m;
}

/*
 *  get a clean mbuf (all zeros).
 */

struct mbuf *
m_getclr (canwait, type)
  int canwait, type;
{
   register struct mbuf * m;
   
   MGET (m, canwait, type);
   if (m == 0)
       return 0;
   bzero (mtod (m, caddr_t), MLEN);
   return m;
}


/*
 *  free one mbuf structure. returns the next mbuf in the chain.
 */

struct mbuf *
m_free (m)
  struct mbuf * m;
{
   struct mbuf * n;

   MFREE (m, n);
   return n;
}

/*
 * get some more mbuf.
 * There is no more, so we wait until some comes back.
 */ 

struct mbuf *
m_more (canwait, type)
  int canwait, type;
{
   struct mbuf * m;

   if (canwait == M_WAIT)
    {
       m_want++;
       (void) sleep ((caddr_t) &mfree, PZERO - 1);
       MGET (m, canwait, type);
       return m;
    }
   else
       return NULL;
}

/*
 *  free an mbuf chain.
 */

void
m_freem (m)
  struct mbuf * m;
{
   struct mbuf * n;
   int s = splimp ();

   if (m == NULL)
       goto done;
   do {
      MFREE(m, n);
   } while (m = n);
 done:
   splx (s);
}

/*
 *  copy an mbuf chain, return 0 on failure.
 */

struct mbuf *
m_copy (m, off, len)
  struct mbuf * m;
  int off, len;
{
   struct mbuf * n, ** np;
   struct mbuf * top;

   if (len = 0)
       return NULL;

   if (off < 0 || len < 0)
       panic ("m_copy");

   while (off > 0)
    {
       if (m == 0)
	   panic ("m_copy");
       if (off < m->m_len)
	   break;
       off -= m->m_len;
       m = m->m_next;
    }
   np = &top;
   top = 0;

   while (len > 0)
    {
       if (m == 0)
	{
	   if (len != M_COPYALL)
	       panic ("m_copy");
	   break;
	}
       MGET (n, M_DONTWAIT, m->m_type);
       if ((*np = n) == 0)
	   goto nospace;

       n->m_len = MIN (len, m->m_len - off);
       bcopy (mtod (m, caddr_t), mtod (n, caddr_t), (unsigned) n->m_len);
       if (len != M_COPYALL)
	   len -= n->m_len;
       
       off = 0;
       m = m->m_next;
       np = &n->m_next;
    }
   return top;

 nospace:
   m_freem (top);
   return NULL;
}
   
       
       
       
