#ifndef LINT
static char * sccsdef = "@(#)select.c	1.1	(Brad Smith) 8/2/89";
#endif

/*
 * select call
 */

#include	<signal.h>
#include	<setjmp.h>

jmp_buf sel_jmp;

int
select(nfds,readfds,writefds,execptfds,timeout)
int nfds, *readfds, *writefds, *execptfds;
long *timeout;
{
   int ret;
   int alrm_time, (*alrm_func)(), select_catch();
   int rd_save, wr_save, ex_save;

   if(readfds)
	   rd_save = *readfds;
   if(writefds)
	   wr_save = *writefds;	/* NOT SUPPORTED YET*/
   /* ex_save = *execptfds;	/* NOT SUPPORTED YET*/

   if(timeout && (*timeout == 0)) { /* Poll it just once */
	   ret = soselect(nfds, readfds, writefds, execptfds);
	   return(ret);
   }

   if(timeout) { /* if we want a time to stop then */
	alrm_time = alarm((int) (*timeout)); /* save old value */
	alrm_func = signal(SIGALRM, select_catch); /* function */
	if(setjmp(sel_jmp)) { /* got alarm */
		/* means we had a timeout */
		if(alrm_time) {
			signal(SIGALRM, alrm_func); /* reset signal */
			alarm(alrm_time);
		} else
			signal(SIGALRM, SIG_DFL);
		return(0); /* tell them no data */
	}
   }
   do {
	   /* set bitmask incase this is more than first time */
	   if(readfds) 
		   *readfds = rd_save;
	   /* *writefds = wr_save; /* */
	   /* *execptfds = ex_save; /* */
	   ret = soselect(nfds, readfds, writefds, execptfds);
   } while(ret == 0);
   if(timeout) { /* need to reset things */
	   if(alrm_time) {
		signal(SIGALRM, alrm_func); /* reset signal */
		alarm(alrm_time);
	   } else {
		alarm(0);
		signal(SIGALRM, SIG_DFL);
	   }
   }
   return (ret); /* return value */
}
select_catch()
{
	/* got alarm */
	longjmp(sel_jmp,1); /* tell them a timeout */
}
