#ifndef LINT
static char * sccsdef = "@(#)interface.c	1.1	(Alex Crain) 6/20/89";
#endif

/*
 *  interface.c - loadable driver interface.
 *
 *  Written By Alex Crain.
 *
 *  This file contains the driver interface routines for the uipc driver, as
 *    discribed in drivers(7). These interface routines are:
 *	uipcinit ();
 *
 */

#include <sys/types.h>
#include <sys/systm.h>
#include <sys/errno.h>
#include <sys/user.h>
#include <sys/conf.h>
#include <uipc/socketvar.h>
#include <uipc/mbuf.h>
#include <uipc/protosw.h>
#include <uipc/domain.h>
#include <uipc/fproto.h>
#include <uipc/pty.h>

#include "sysent.h"

extern void (* sock_read)();
extern void (* sock_write)();
extern void (* sock_close)();

/* stuff to wake up on */
extern int select_sleep, select_sleep_addr;

void
ptyinit ()
{
   int i;

   /*
    * add our own system call processor.
    */

   sysent[SYSL_LOCSYS].sy_call = (int (*)()) dosyscall;
   sysent[SYSL_LOCSYS].sy_narg = 3;

   /*
    *  link to the existing hooks in the kernal.
    */

   sock_read = uipc_read;
   sock_write = uipc_write;
   sock_close = uipc_close;

   /*
    *  Initialize the system.
    */

   mbinit ();
   domaininit ();

   /*
    * find out where the pty major device is
    */
   for(i=0;i<cdevcnt;i++) {
	if(cdevsw[i].d_open == ptyopen)
		pty_major = i; /* got it */
   }
   so_linesw_setup();
}

void
dosyscall()
{
   int index = u.u_ap[0] - SYSL_FIRST;
   /*
    * Intercept our calls
    */

   if (index >= 0 && index <= (SYSL_LAST - SYSL_FIRST))
    {
       /*
	*  syscall arguments are available via the users %sp, at u.u_ar0[15].
	*  These arguments must be copied to the argument vector u.u_arg[]
	*  for access by the kernal. Noting that the stack looks like:
	*	%sp -> [ frame link, &67, arg1, arg2 ... ]
	*/
       int arg = 0;
       int * ap = (int *) (u.u_ar0[15]) + 2;
       while (arg < sysentries[index].sy_narg)
	   u.u_arg[arg++] = fuword(ap++);

       /*
	*  Perform the call.
	*/
       (* sysentries[index].sy_call) ();
    }
   else
       locsys ();
}

int
uipcrelease ()
{
   int mbmem_ref;
   int s = spl5();
   struct mbuf * m;
   
   for (m = mbmem; m < &mbmem[NMBUF+1]; m++)
       if (m->m_type == MT_SOCKET)
	   if (soclose (mtod (m, struct socket *)))
	        return EBUSY;
   for (mbmem_ref =0, m = mbmem; m < &mbmem[NMBUF+1]; m++, mbmem_ref++)
       if (m->m_type != MT_FREE)
	{
	   int * i;
	   (void) printf ("\n\n\nUIPC: Illegal mbuf type %d.\n", m->m_type);
	   (void) printf ("m = ([*|%x] [m_next|%x] [m_len|%x] [m_type|%x])\n",
			  m, m->m_next, m->m_len, m->m_type);
	   (void) printf ("mbmem_ref=%d, NMBUF=%d\n", mbmem_ref, NMBUF);
	   for (i = mtod (m, int *); 
		i < ((int *) ((caddr_t) m + MSIZE - MTAIL));
		i+=4)
	       (void) printf ("%x %x %x %x\n", *i, *(i+1), *(i+2), *(i+3));
	   panic ("uipc_release");
	}

   splx (s);
   so_linesw_release();
   return 0;
}

/*
 *  rdwr() uses this for reading sockets. 
 *
 *  There are no arguments, pertinant info is available as:
 *	u.u_ap[0] -	The file descriptor number
 *	u.u_base - 	IO buffer address
 *	u.u_count -	size of buffer.
 *	u.u_segflg -	IO buffer location
 *
 *  Errors do not return, rather an error condition is handled with a longjmp
 *  to u.u_qsav, with some non-zero argument. the call will return -1 to the 
 *  user, passing the error in errno (u.u_error). Since the jump returns
 *  directly to trap(), we need to do any houskeeping here.
 */

void
uipc_write ()
{
   struct file * fp = getf (u.u_ap[0]);

   u.u_error = sosend (filesock (fp), (struct mbuf *) 0, 0, (struct mbuf *) 0);
   
   /*
    *  process errors
    */

   if (u.u_error)
       longjmp (u.u_qsav, 1);
}

void
uipc_read ()
{
   struct file * fp = getf (u.u_ap[0]);

   u.u_error = 
       soreceive (filesock (fp), (struct mbuf **) 0, 0, (struct mbuf **) 0);
			  
			  
   
   /*
    *  process errors
    */

   if (u.u_error)
       longjmp (u.u_qsav, 1);
}

void
uipc_close (sp)
  off_t sp;
{
   u.u_error = soclose (mtod (ptom (sp), struct socket *));

   /* next check us for wakeup maybe? */
   if(select_sleep) {
	select_sleep = 0;
	wakeup((caddr_t) &select_sleep_addr);
   }
   /*
    *  process errors
    */

   if (u.u_error)
       longjmp (u.u_qsav, 1);
}


/*
 *  General utilities for the BSD<->sysV mix.
 */

#ifdef unixpc

asm("	global bzero	");
asm("bzero:		");
asm("	mov.l	4(%sp),%a0");
asm("	mov.w	10(%sp),%d0");
asm("	sub.w	&1,%d0	");
asm("	bmi	end	");
asm("loop:		");
asm("	mov.b	&0,(%a0)+");
asm("	dbf	%d0,loop");
asm("end:		");
asm("	rts		");

#else

void
bzero (s, n)
  char * s; 
  int n;
{
   while (n--)
       *s++ = '\0';
}

#endif

int
ufavail ()
{
   int avail = 0, fd = 0;

   for (fd = 0; fd < 80; fd++)
       if (u.u_ofile[fd] == 0)
	   avail++;

   return avail;
}
