/*
 *	@(#)protosw.h	1.1	(Alex Crain)	6/20/89
 *
 *  protosw.h - protocol switch definition
 *
 *  Written by Alex Crain.
 *
 *  This file is based in the Berkeley header file of the 
 *  same name, but is *not* guarenteed to be in any way compatable. It is
 *  close enough to the berkeley code that the following applies...
 *
 *  Copyright (c) 1982, 1986, 1988 Regents of the University of California.
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms are permitted
 *  provided that this notice is preserved and that due credit is given
 *  to the University of California at Berkeley. The name of the University
 *  may not be used to endorse or promote products derived from this
 *  software without specific prior written permission. This software
 *  is provided "as is" without express or implied warranty.
 *
 */

#ifndef _proto_h_
#define _proto_h_

#include <uipc/conf.h>

struct protosw {
   short	pr_type;
   struct	domain * pr_domain;
   short	pr_protocol;
   short	pr_flags;
   int 		(* pr_input) ();
   int		(* pr_output) ();
   int		(* pr_ctlinput) ();
   int		(* pr_ctloutput) ();
   int		(* pr_usrreq) ();
   int		(* pr_init) ();
   int		(* pr_fasttimo) ();
   int		(* pr_slowtimo) ();
   int		(* pr_drain) ();
};

#define PR_SLOWHZ	2
#define PR_FASTHZ	5

/*
 *  values for pr_flags
 */

#define PR_ATOMIC	0x01		/* exchange atomic messages only     */
#define PR_ADDR		0x02		/* addresses given w/ messages	     */
#define PR_CONNREQUIRED	0x04		/* connection reuired by protocol    */
#define PR_WANTRCVD	0x08		/* want PRU_RCVD calls		     */
#define PR_RIGHTS	0x10		/* passes capabilities		     */

/*
 *  arguments to usrreq
 */

#define PRU_ATTACH	0
#define PRU_DETACH	1
#define PRU_BIND	2
#define PRU_LISTEN	3
#define PRU_CONNECT	4
#define PRU_ACCEPT	5
#define PRU_DISCONNECT	6
#define PRU_SHUTDOWN	7
#define PRU_RCVD	8
#define PRU_SEND	9
#define PRU_ABORT	10
#define PRU_CONTROL	11
#define PRU_SENSE	12
#define PRU_RCVOOB	13
#define PRU_SENDOOB	14
#define PRU_SOCKADDR	15
#define PRU_PEERADDR	16
#define PRU_CONNECT2	17
#define PRU_FASTTIMO	18
#define PRU_SLOWTIMO	19
#define PRU_PROTORCV	20
#define PRU_PROTOSEND	21

#define PRE_NREQ	21

#define PRCO_GETOPT	0
#define PRCO_SETOPT	1

#endif /* _proto_h_ */
