#include <sys/types.h>
#include <signal.h>
#include <uipc/socket.h>
#include <stdio.h>

#define DATA1 "In Xanadu, did Kublai Kahn..."
#define DATA2 "A Stately pleasure dome decree ..."

sigcatch (sig)
  int sig;
{
   printf ("died on a SIGPIPE\n");
   exit (0);
}

main ()
{
   int sockets[2], child;
   char buf[1024];

   setbuf (stdout, 0);

   signal (SIGPIPE, sigcatch);

   if (socketpair (AF_UNIX, SOCK_STREAM, 0, sockets) < 0) 
    {
       extern int errno;
       printf ("socketpair error [%d].\n", errno);
       exit(1);
    }

   if ((child = fork ()) == -1)
       perror ("fork");
   else if (child)
    {
       close (sockets[0]);
       if (read(sockets[1], buf, 1024) < 0)
	   perror ("reading stream message [1]");
       printf ("-->%s\n", buf);
       if (write (sockets[1], DATA1, sizeof (DATA2)) < 0)
 	   perror ("writing stream message [1]");
       close (sockets[1]);
    }
   else
    {
       close (sockets[1]);
       if (write (sockets[0], DATA2, sizeof (DATA2)) < 0)
 	   perror ("writing stream message [0]");
       if (read(sockets[0], buf, 1024) < 0)
	   perror ("reading stream message [0]");
       printf ("-->%s\n", buf);
       close(sockets[0]);
    }
}

