#ifndef LINT
static char * sccsdef = "@(#)proto.c	1.1	(Alex Crain) 6/20/89";
#endif

/*
 *  proto.c - protocol spec for the UNIX domain.
 *
 *  Written by Alex Crain.
 *
 *  This file is loosly based in the Berkeley file uipc_proto.c,
 *  but is *not* guarenteed to be in any way compatable. It is
 *  close enough to the Berkeley code that the following applies...
 *
 *  Copyright (c) 1982, 1986, 1988 Regents of the University of California.
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms are permitted
 *  provided that this notice is preserved and that due credit is given
 *  to the University of California at Berkeley. The name of the University
 *  may not be used to endorse or promote products derived from this
 *  software without specific prior written permission. This software
 *  is provided "as is" without express or implied warranty.
 *
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <uipc/mbuf.h>
#include <uipc/socket.h>
#include <uipc/socketvar.h>
#include <uipc/protosw.h>
#include <uipc/domain.h>
#include <uipc/fproto.h>

/*
 *  UNIX domain protocols
 */

int	uipc_usrreq ();
int	raw_init (), raw_usrreq (), raw_input (), raw_ctlinput ();
extern struct domain unixdomain;

struct protosw unixsw[] = {
   { SOCK_STREAM, &unixdomain, 0, PR_CONNREQUIRED | PR_WANTRCVD | PR_RIGHTS,
      0,	0,	0,	0,
      uipc_usrreq,
      0,	0,	0,	0, },
   { SOCK_DGRAM,  &unixdomain, 0, PR_ATOMIC | PR_ADDR | PR_RIGHTS,
      0,	0,	0,	0,
      uipc_usrreq,
      0,	0,	0,	0, },
#ifdef SOCK_RAW
   { 0,		  0,	       0, 0,
      raw_input, 0,	raw_ctlinput, 0,
      raw_usrreq,
      raw_init,	0,	0,	0, },
#endif
};

struct domain unixdomain =
{ AF_UNIX, "unix", 0, unp_externalize, (int (*)()) unp_dispose,
   unixsw, &unixsw[sizeof (unixsw) / sizeof (unixsw[0])] };

