/* lpstat - the printer daemon maintenance tool		Author: Ralf Wenk */

/* list the jobs in the queue or cancel one of it. If a job is not
 * canceled by its initiator mail is send to him.
 *
 * Ralf Wenk	last update:	Tue Jun  9 16:17:20 1992
 *
 * $Id: lpstat.c,v 1.1 92/06/09 17:01:31 ralf Exp $
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <unistd.h>
#include <dirent.h>
#include <limits.h>
#include <string.h>
#include <signal.h>
#include <errno.h>
#include <pwd.h>
#include <stdio.h>


#define TRUE	1
#define FALSE	0
#define SPDIR	"/usr/spool/lpd"	/* spool directory */
#define LPDLOCK	"Lock"			/* shows that a lpd is running */
#define NOBODY	"-"


/* No header defines this ! */
extern FILE *popen();
extern int pclose();


/*
 * return the basename of a file
 */
char *basename ( path )
char *path;
{
  char *cptr;

  if (( cptr = strrchr( path,'/')) != NULL )
    cptr++;
  else
    cptr = path;
  return( cptr );
}	/* basename */


/*
 * get the name of the real user
 */
char *getuser ()
{
  struct passwd *pwdptr;
  char *cptr;

  if (( pwdptr = getpwuid( getuid())) != NULL )
    cptr = pwdptr->pw_name;
  else
    cptr = NOBODY;
  return( cptr );
}	/* getuser */


/*
 * invoke the mailer
 */
void sendmail ( to, from, jobid )
char *to, *from, *jobid;
{
  FILE *pfp = NULL;
  char cmd[PATH_MAX];

  sprintf( cmd,"mail -s \"Problems with your lp job %s\" %s", jobid, to );
  pfp = popen( cmd,"w");
  fprintf( pfp,"The job is canceled by %s\n\nYour lpstat\n", from );
  pclose( pfp );
}	/* sendmail */


/*
 * show the jobs in the spooldirectory
 */
void showjob ( from, verbose )
char *from;
int verbose;
{
  FILE *fp;
  DIR *spdir;				/* spool directory */
  struct dirent *entry;
  char buff[BUFSIZ];
  int first;
  int copies;
  char *source, *dest, *user;

  spdir = opendir(".");
  while (( entry = readdir( spdir )) != NULL )
  {
    if ( isdigit( entry->d_name[0] ))
    {
      first = TRUE;
      if (( fp = fopen( entry->d_name,"r")) != NULL )
      {
        while ( fgets( buff, BUFSIZ, fp ) != NULL )
        {
          copies = atoi( strtok( buff," "));
          source = strtok( (char *)NULL," ");
          dest = strtok( (char *)NULL," ");
          user = strtok( (char *)NULL,"\n");
          if ( from == NULL || ( from != NULL && strcmp( from, user ) == 0 ))
          {
            if ( first )
            {
              fprintf( stdout,"job %s", entry->d_name );
              if ( from == NULL )
                fprintf( stdout," from %s", user );
              fprintf( stdout," to %s", dest );
              if ( copies > 1 )
                fprintf( stdout,", %d copies", copies );
              fprintf( stdout,"\n");
              first = FALSE;
            }
            if ( verbose )
              fprintf( stdout,"\t%s\n", source );
          }
        }
        fclose( fp );
      }
    }
  }
  closedir( spdir );
}	/* showjob */


/*
 * if a daemon is running tell him that his job may be canceled
 */
void telldaemon ()
{
  FILE *fp;
  char pid[6];

  if (( fp = fopen( LPDLOCK,"r")) != NULL )
  {
    while ( fgets( pid, sizeof( pid ), fp ) == NULL );
    fclose( fp );
    kill( atoi( pid ), SIGUSR1 );
  }
}	/* telldaemon */


/*
 * cancel a job in the spooldirectory
 */
void canceljob ( id )
char *id;
{
  FILE *fp;
  DIR *spdir;				/* spool directory */
  struct dirent *entry;
  char buff[BUFSIZ];
  char dfname[20];
  int copies;
  char *source, *user, *thisuser;

  strcpy( dfname, SPDIR );
  strcat( dfname,"/D.");
  thisuser = getuser();
  spdir = opendir(".");
  while (( entry = readdir( spdir )) != NULL )
  {
    if ( isdigit( entry->d_name[0] ) && strcmp( entry->d_name, id ) == 0 )
    {
      if (( fp = fopen( entry->d_name,"r")) != NULL )
      {
        unlink( entry->d_name );	/* remove the job */
        telldaemon();
        while ( fgets( buff, BUFSIZ, fp ) != NULL )
        {
          strtok( buff," ");
          source = strtok( (char *)NULL," ");
          strtok( (char *)NULL," ");
          user = strtok( (char *)NULL,"\n");
          if ( strncmp( dfname, source, strlen( dfname )) == 0 )
            unlink( source );		/* source is a datafile in SPDIR */
        }
        fclose( fp );
        if ( strcmp( user, thisuser ) != 0 )
          sendmail( user, thisuser, entry->d_name );
      }
    }
  }
  closedir( spdir );
}	/* canceljob */


/*
 * do the requested job
 */
int main( argc, argv )
int argc;
char *argv[];
{
  FILE *fp;
  char *user;
  char *jobid;
  int verbose;
  char option;
  extern char *optarg;
  extern int optind;

  jobid = NULL;
  verbose = FALSE;
  chdir( SPDIR );
  user = getuser();
  while (( option = getopt( argc, argv,"ac:v")) != EOF )
  {
    switch ( option )
    {
      case 'a':
        user = NULL;
        break;
      case 'c':
        jobid = optarg;
        break;
      case 'v':
        verbose = TRUE;
        break;
      default:
        fprintf( stderr,"Usage: % [-a][-v][-c jobid]\n", basename( argv[0] ));
        break;
    }
  }
  if ( jobid == NULL )
    showjob( user, verbose );
  else
    canceljob( jobid );
  exit( 0 );
}	/* main */
