/* backup <device> <files> copies files to backup device by H. Salomons */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

typedef struct stat stat_t;

#include <dirent.h>

#define NULLD ((struct dirent *) 0)
#define CHARP(x)  (x == ((char *) 0) ? "NULL" : x)

#undef SHOW_RESULT
#define PROFILE ".backup.pro"
#define HOME "HOME"
#define BACKDIR "/tmp"
#define BACKTAR "/tmp/back%03d.tar"
#define BACKLST "/tmp/back%03d.lst"
#define TRUE 1
#define FALSE 0
#define MAX_NAME 256
#define MAX_CMD 512
#define MAX_SKIP 32
#define MAX_ARGS 64
#define MAX_STRG 256

/* in blocks, single and double sided */
#define SINGLE_SIZE 720
#define DOUBLE_SIZE 1440

/* in bytes */
#define BLOCK_SIZE 512

#define LIST_DIR 0
#define LIST_FILE 1
#define SUCCESS 0
#define FAILURE 1

#define MAX_DEPTH 32
#define NULLP ((char *) 0)
#define NULLF ((FILE *) 0)
#define MALLOC(a, b)  ((a *) malloc((unsigned int) ((b) * sizeof(a)) ) )
#define FREE(a) free((char *) a)

#define remove(a) unlink(a)

typedef struct fileinfo_struct
{
    char       *fi_name;
    char       *fi_back;
    long        fi_size;
    long        fi_bsiz;
    struct fileinfo_struct *fi_next;
}           fileinfo;
typedef fileinfo *fi_ptr;

#define NULL_FI ((fi_ptr) 0)

extern int  strlen();
extern void exit();
extern int  list_files();
extern void add_path();
extern void add_file();
extern char *malloc();
extern char *strsave();
extern int  dlist();
extern int  backup_one();
extern long getftime();
extern void free();
extern void qsort();
extern void sync();
extern char *eoln;
extern char *progname;
extern char *dirback;
extern FILE *fnout;
extern long block_count;
extern long block_max;
extern char oname[];
extern char dname[];
extern char *pathname[];
extern char *skip[];
extern int numskip;
extern fi_ptr *fptr;
extern fi_ptr start;
extern unsigned list_count;
extern int  oseqnr;
extern long since;
extern char *listname;
extern char *diskname;
extern int file_number;
extern char do_compress;
