/* Yautil.c	18-Oct-86	Memory, file routines with error handling */
/* 22-Jul-87 IBM */
/* 09-Jul-89 ZTC */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	[xgetw()	xputw()		itoa()]
			open()		xopen()		xalloc()
			xrealloc()	xfree()		message()
			errmsg()	er2msg()	bug()
			yyerror()	yyterror()	enquote()

	Uses:		where()
*/

#include <stdio.h>

#define	PHASE0

#include "yadefs.h"

#ifdef NEEDGETW

#ifndef NOTBINARY	/* is this what they call a double negative ? */

int
xgetw(f)
FILE *f;
{
    int b1,b2;

    if ((b1=getc(f)) == EOF || (b2=getc(f)) == EOF)
	return EOF;
    else
	return ( (b2<<8) | b1 );
}

int
xputw(u,f)
unsigned u;
FILE *f;
{
    if (putc(u & 0xff,f) == EOF || putc((u>>8) & 0xff,f) == EOF)
	return EOF;
    else
	return u;
}

#else	/* NOTBINARY */

/* horrendous but useful start during new ports ! */

int
xgetw(f)
FILE *f;
{
    unsigned u;

    fscanf(f,"%i",&u);
    return u;
}

int
xputw(u,f)
unsigned u;
FILE *f;
{
    fprintf(f,"0x%x ",u);
}

#endif	/* NOTBINARY */

#endif /* NOGETW */

#ifdef NEEDITOA

char *
itoa(n,s,r)
int n;
register char *s;
int r;
{
    int i;

    if ((i=n/r))
	s=itoa(i,s,r);
    *s++=n % r + '0';
    *s=0;
    return s;
}

#endif /* NEEDITOA */


FILE *xopen(name,mode)
char *name;
char *mode;
{
    FILE *f;

    if ((f=fopen(name,mode)) == NULL) {
	fputs("Can't open <",stderr);
	fputs(name,stderr);
	fputs("> for ",stderr);
	fputs(mode,stderr);
	fputs("\n",stderr);
	exit(1);
    }
    return f;
}

void
xclose(f,name)
FILE *f;
char *name;
{
    if (fclose(f) == EOF) {
	fputs("Can't close <",stderr);
	fputs(name,stderr);
	fputs(">\n",stderr);
	exit(1);
    }
}


char *xalloc(n)					/* Allocate n bytes of store */
unsigned n;
{
    char *p;

    if (n == 0) {
	errmsg("xalloc: zero request\n",WARNING);
	return NULL;
    }
    if ((p=malloc(n)) != NULL) {
	trace(("xalloc: %p bytes %04x\n",p,n));
	return p;
    }
    else
	errmsg("Xalloc: Out of memory\n",ABORT);
}

char *xrealloc(p,n)			/* Reallocate n bytes of store */
char *p;
unsigned n;
{
    if (n == 0) {
	errmsg("xrealloc: zero request\n",WARNING);
	xfree(p);
	return NULL;
    }
    if ((p=realloc(p,n)) != NULL) {
	trace(("xrealloc: %p bytes %04x\n",p,n));
	return p;
    }
    else
	errmsg("xrealloc: Out of memory\n",ABORT);
}

void
xfree(blk)					/* Deallocate block */
char *blk;					/* Size specified in header */
{
    free(blk);
}

void
message(s)
char *s;
{
    if (o_debug) {
	fputs(s,stdout);
	fputs("\n",stdout);
    }
}

void
errmsg(s,i)
char *s;
int i;
{
    where(stderr);
    switch (i) {
	case WARNING:	fputs(" - Warning - ",stderr);
			++cnwarning;
			break;
	case FATAL:	fputs(" - Fatal - ",stderr);
			++cnfatal;
			break;
	case ABORT:	fputs(" - Abort - ",stderr);
			break;
    }
    fputs(s,stderr);
    fputs("\n",stderr);
    if (i == ABORT) {
	exit(1);
    }
}

void
er2msg(s1,s2,i)
char *s1,*s2;
int i;
{
    where(stderr);
    switch (i) {
	case WARNING:	fputs(" - Warning - ",stderr);
			++cnwarning;
			break;
	case FATAL:	fputs(" - Fatal - ",stderr);
			++cnfatal;
			break;
	case ABORT:	fputs(" - Abort - ",stderr);
			break;
    }
    fputs("<",stderr);
    fputs(s1,stderr);
    fputs("> ",stderr);
    fputs(s2,stderr);
    fputs("\n",stderr);
    if (i == ABORT) {
	exit(1);
    }
}

void
bug(s)
char *s;
{
    where(stderr);
    fputs("- Bug - ",stderr);
    fputs(s,stderr);
    fputs("\n",stderr);
    exit(1);
}

void
yyerror(s)
char *s;
{
    fprintf(stderr,"- Abort - %s\n",s);
    exit(1);
}

void
yyterror(token)
char *token;				/* NULL is last in list */
{
    static int first=1;			/* expecting 1st in a list */

    if (first) {
	fprintf(stderr,"- Abort - syntax error");
    }
    if (first && token) {
	fprintf(stderr,", expecting %s",token);
    }
    if (!first && token) {
	fprintf(stderr," or %s",token);
    }
    first=0;
    if (!token) {				/* end of list */
	fprintf(stderr,"\n");
	first=1;			/* for next time ... */
	exit(1);			/* but, alas ... */
    }
}

char *
enquote(old)			/* "stringize" string */
char *old;			/* dealing with escapes and embedded quotes */
{
    char *new,*ptr;
    unsigned lng,index;

    ptr=new=xalloc(lng=(strlen(old)+3));
    /* includes room for surrounding quotes & trailing \0 */

    *ptr++='"';
    while (*old) {
	if (*old == '\\' || *old == '"') {
	    index=ptr-new;
	    new=xrealloc(new,++lng);
	    ptr=new+index;
	    *ptr++='\\';
	}
	*ptr++= *old++;
    }
    *ptr++='"';
    *ptr='\0';

    return new;
}

