/* Yapack.c	03-Dec-86	Pack transitions into action table */
/* 25-Jul-87 IBM */
/* 25-Mar-88 VAXVMS */
/* 09-Jul-89 ZTC*/

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	pack()

	Statics:	doshift()	dogoto()	clearv()
			addv()		defv()		findspot()
			bstart()	badvance()	gadvance()
			vadvance()	loadspot()	gadd()
			addend()	addfront()	joingroup()
			isbase()	getshift()	getgoto()
			ytact()		ytpgo()		ytpact()
			ytchk()
*/

#include <stdio.h>

#define PHASE2

#include "yadefs.h"

typedef struct group {		/* Group of entries in yxact[] */
    struct group *next;
    int start;			/* Start displacement */
    int end;			/* End displacement */
    struct tolist *toptr,	/* Head of list of tostates (the entries) */
		  *tolast;	/* Tail of above */
} GROUP;

typedef struct tolist {		/* Group of sequential entries in yxact[] */
    struct tolist *next;	/* Next entry in yxact[] */
    int tostate;		/* Entry is destination of shift */
} TOLIST;

typedef struct vlist {		/* List of values read in for this state */
    struct vlist *next;		/* Kept sorted by offset */
    int tostate;
    int offset;
} VLIST;

static int *yxpact;		/* Index (base) to yxact for each state */
static int *yxpgo;		/* Index (base) to yxact for each nont */
static int *yxchk;		/* Symbol on entering state (DFA so unique) */

static int nnact;		/* Count of entries in yxact[] */

static int gttok;		/* Lookahead at entry in shift or goto file */
static int gtnont;
static int gtfrom;
static int gtto;

static int base;		/* Base of current spread in yxact[] */
static int low;			/* Lowest offset in current value */

static int gdispl;		/* Group displacement from yxact[0] */
static int vdispl;		/* value displacement from yxact[0] */

static int st;			/* State during shifts */
static int nont;		/* Nonterminal during gotos */

static GROUP *group;		/* Current group */
static GROUP *head;		/* First group in list */

static TOLIST *toptr;		/* Current position in groups tolist */

static VLIST *vhead;		/* Head of current states value list */
static VLIST *vptr;		/* Current entry in above */

static int bdispl;		/* Remember base position */
static GROUP *bgroup;
static TOLIST *btoptr;

#define MAXACT 30000

#define FINDGOTO	0	/* Mode values for findspot() */
#define FINDSHIFT	1

#ifdef TRACE
#define	troff()	dpoff()
#define tract() dpact()
static void dpoff();
static void dpact();
#else
#define	troff()
#define tract()
#endif

void
pack()
{
    void getshift(),doshift(),getgoto(),dogoto();
    void clearv(),yttable();
    int ytpgo(),ytact(),ytpact(),ytchk();
    int i;

    message("pack:");

    yxpact=(int *)xalloc(cnstate*sizeof(int));
    yxchk=(int *)xalloc(cnstate*sizeof(int));
    yxpgo=(int *)xalloc(cnnont*sizeof(int));

    for (i=0; i<cnstate; ++i) {
	yxpact[i]=YXFLAG;
	yxchk[i]=YXFLAG;
    }
    for (i=0; i<cnnont; ++i) {
	yxpgo[i]=YXFLAG;
    }

    nnact= -1;				/* Deepest entry doesn't exist */
					/* space to avoid old assign op */
    head=NULL;				/* No groups to start with */

    fshift=xopen(nshift,READ_BINARY);
    vhead=NULL;				/* No value list yet */
    getshift();				/* Lookahead */
    nont=0;				/* isbase() doesn't check gotos yet */
    for (st=0; st<cnstate; ++st) {
	trace(("pack:doing st %d\n",st));
	doshift();
    }
    xclose(fshift,nshift);

    fgoto=xopen(ngoto,READ_BINARY);
    clearv(&vhead);
    getgoto();
    st=cnstate;				/* Make isbase() check all states */
    for (nont=0; nont<cnnont; ++nont) {
	trace(("pack:doing nont %d\n",nont));
	dogoto();
    }
    xclose(fgoto,ngoto);

    ++nnact;				/* Was deepest entry - now is size */

    trace(("pack: %d yxact[] entries\n",nnact));

    fytabc=xopen(nytabc,"a");
    yttable(fytabc,ytpgo,"yypgo",cnnont,TABLEWIDTH);
    yttable(fytabc,ytpact,"yypact",cnstate,TABLEWIDTH);
    yttable(fytabc,ytchk,"yychk",cnstate,TABLEWIDTH);
    yttable(fytabc,ytact,"yyact",nnact,TABLEWIDTH);
    fprintf(fytabc,"#define YYLAST %d\n",nnact);
    xclose(fytabc,nytabc);
}

static void
doshift()
{
    void clearv(),addv(),getshift(),loadspot();
    int findspot();

    if (gttok == -1 || gtfrom != st) {	/* No shifts for this state */
	return;
    }

    clearv(&vhead);
    low=bsnont-1;
    while (gttok != -1 && gtfrom == st) {	/* Read in shifts */
	trace(("doshift: tok %d from %d to %d\n",gttok,gtfrom,gtto));
	yxchk[gtto]=gttok;		/* Check[] contains tok that gets us */
					/* to the state */
	addv(&vhead,gttok,gtto);
	if (gttok < low) {
	    low=gttok;
	}
	getshift();
    }

    if (findspot(FINDSHIFT)) {		/* Find a place for the values */
	loadspot();			/* If not already all there, load */
    }
    yxpact[st]=base;
}

static void
dogoto()
{
    void clearv(),addv(),defv(),getgoto(),loadspot();
    int findspot();

    if (gtnont == -1 || gtnont != nont) {	/* No gotos for this nont */
	return;
    }

    clearv(&vhead);
    low=0;					/* Always have default at 0 */
    while (gtnont != -1 && gtnont == nont) {	/* Read in gotos */
	trace(("dogoto: nont %d from %d to %d\n",gtnont,gtfrom,gtto));
	yxchk[gtto]= -gtnont;		/* -ve to distinguish from tok */
					/* space to avoid old assign op */
	addv(&vhead,gtfrom+1,gtto);	/* +1 leaves space for 0 (default) */
	getgoto();
    }

    defv(&vhead);			/* Find default and put at offset 0 */

    if (findspot(FINDGOTO)) {		/* Find a place for the values */
	loadspot();			/* If not already all there, load */
    }
    yxpgo[nont]=base;
}

static void
clearv(ahead)
VLIST **ahead;
{
    VLIST *new;

    while (*ahead) {
	new=(*ahead)->next;
	xfree((char *)*ahead);
	*ahead=new;
    }
}

static void
addv(ahead,offset,tostate)
VLIST **ahead;
int offset;
int tostate;
{
    VLIST *new,*spot,*last;

    last=NULL;
    for (spot= *ahead; spot && spot->offset < offset; spot=spot->next) {
					/* "= *" avoids old assignment op */
	last=spot;
    }

    if (spot && spot->offset == offset) {	/* Already in list */
	return;
    }

    new=(VLIST *)xalloc(sizeof(VLIST));
    new->next=spot;
    new->offset=offset;
    new->tostate=tostate;

    if (last) {				/* In middle of list */
	last->next=new;
    }
    else {				/* New head of list */
	*ahead=new;
    }
}

static void				/* Find default entry */
defv(ahead)				/* ie. most frequent tostate */
VLIST **ahead;
{
    void addv();

    VLIST *ml,*l,*llast,*lnext;
    int freq,mfreq,mtostate;

    mfreq=0;
    ml=NULL;
    for (l= *ahead; l; l=l->next) {	/* Find most frequent tostate */
					/* "= *" avoids old assignment op */
	freq=1;
	for (lnext=l->next; lnext; lnext=lnext->next) {
	    if (l->tostate == lnext->tostate) {
		++freq;
	    }
	}
	if (freq >= mfreq) {		/* Use highest offset if choice */
					/* to minimize spread */
	    ml=l;
	    mtostate=l->tostate;
	}
    }
    llast=NULL;
    for (l= *ahead; l; l=lnext) {	/* Delete any occurences of mtostate */
					/* "= *" avoids old assignment op */
	lnext=l->next;
	if (l->tostate == mtostate) {
	    if (llast) {
		llast->next=lnext;
	    }
	    else {
		*ahead=lnext;
	    }
	    xfree((char *)l);
	}
	else {
	    llast=l;
	}
    }
    addv(ahead,0,mtostate);		/* Replace it with default (offset 0)*/
}

static int			/* Find a place to put the values */
findspot(mode)			/* Returns 0 if already in place */
int mode;			/* FINDGOTO or FINDSHIFT - selects yxchk[] */
{
    void bstart(),badvance(),gadvance(),vadvance();
    int isbase();
    int chkval,range,clash,addreqd,donecant;

    trace(("findspot:\n"));

    base= -low;				/* space to avoid old assign op */
    if (mode == FINDGOTO) {
	chkval= -nont;			/* space to avoid old assign op */
	range=base+cnstate;			/* Plus 0 default entry */
    }
    else {					/* chkval=gdispl-base(token) */
	range=base+bsnont-1;
    }
    bstart();					/* Set group=head & save */

    for (;;) {
	trace(("findspot: new base\n"));
	vptr=vhead;				/* Start from 1st value */
	vdispl=vptr->offset+base;		/* Is always at least one */
	addreqd=0;
	clash=0;
	donecant=0;
	while (!clash && (vdispl <= range || gdispl <= range)) {
	    trace(("findspot: another pass\n"));
	    troff();
	    if (gdispl == vdispl) {		/* value, in group */
		trace(("findspot: value in group\n"));
		if (toptr->tostate != vptr->tostate) {
		    trace(("findspot:clash on to (is %d want %d)\n",
			toptr->tostate,vptr->tostate));
			clash=1;
		}
		else {
		    gadvance();
		    vadvance();
		}
	    }
	    else {
		if (gdispl < vdispl) {		/* No value, in group */
		    if (mode == FINDSHIFT) {	/* Use token as yxchk[] */
			chkval=gdispl-base;
		    }				/* Else is -nont already */
		    if (yxchk[toptr->tostate] == chkval) {
			trace(("findspot: clash on check\n"));
			clash=1;		/* Was ok, but we want error */
		    }
		    else {
			gadvance();
		    }
		}
		else { /* gdispl > vdispl */	/* value, in space */
		    if (donecant++ == 0 && isbase(base)) {
			trace(("findspot: clash on cantbe\n"));
			clash=1;		/* Base already used */
		    }
		    else {
			addreqd=1;		/* Need to load the space */
			vadvance();
		    }
		}
	    }
	}
	if (clash) {
	    badvance();			/* Try next ++base (sets gdispl,etc) */
	    ++range;
	}
	else {
	    break;			/* Base is where to load */
	}
    }
    return addreqd;
}

static void				/* Start from base 0 or less */
bstart()				/* Sets b... and g... */
{
    if (group=head) {
	gdispl=group->start;
	toptr=group->toptr;
    }
    else {
	gdispl=MAXACT;
	toptr=NULL;
    }
    bgroup=group;			/* Remember the base */
    bdispl=gdispl;
    btoptr=toptr;
}

static void				/* Advance base by one */
badvance()				/* and set gdispl to start of base */
{
    void gadvance();

    group=bgroup;			/* Restore old base */
    gdispl=bdispl;
    toptr=btoptr;
    ++base;
    while (gdispl < base) {		/* Advance if necessary */
	gadvance();
    }
    bgroup=group;			/* Save new base for next time */
    bdispl=gdispl;
    btoptr=toptr;
}

static void			/* Advance to next group member */
gadvance()			/* MUST NEVER be called if no groups */
{
    trace(("gadvance:\n"));
    ++gdispl;
    toptr=toptr->next;
    if (gdispl > group->end) {
	if (group->next) {
	    group=group->next;
	    gdispl=group->start;
	    toptr=group->toptr;
	}
	else {
	    gdispl=MAXACT;	/* NB. group unchanged */
	    toptr=NULL;
	}
    }
    troff();
}

static void			/* Advance to next value, if exists */
vadvance()			/* MUST NEVER be called if no vptr */
{
    trace(("vadvance:\n"));
    if (vptr=vptr->next) {
	vdispl=vptr->offset+base;
    }
    else {
	vdispl=MAXACT;
    }
    troff();
}

static void				/* Load any values not already there */
loadspot()				/* From base (leaves base unchanged) */
{
    void gstart(),gadvance(),vadvance();
    void gadd();

    trace(("loadspot:\n"));
    tract();

    vptr=vhead;
    vdispl=vptr->offset+base;
    group=head;				/* NB. doesn't use bstart,badvance */

    while (vptr) {
	while (group && group->next && vdispl >= group->next->start) {
	    group=group->next;
	}
	if (group == NULL || vdispl > group->end) {	/* value, in space */
	    trace(("loadspot: space\n"));
	    gadd(vdispl,vptr->tostate);
	}
	vadvance();			/* Has been loaded or already there */
    }

    tract();
}

static void
gadd(displ,tostate)
int displ;				/* Where new entry is */
int tostate;				/* To state of only entry in group */
{
    void joingroup(),addend(),addfront();
    GROUP *g;

    trace(("gadd:\n"));
    tract();

    g=NULL;					/* Use as flag */
    if (group) {
	if (group->end+1 == displ) {		/* Add to end of group */
	    addend(group,tostate);
	    g=group;
	}
	else {
	    if (group->next && group->next->start == displ+1) {
		addfront(group->next,tostate);	/* Add to front of next */
		g=group->next;
	    }
	}
    }

    if (g == NULL) {				/* Need a new group */
	g=(GROUP *)xalloc(sizeof(GROUP));
	g->start=displ;
	g->end=displ-1;
	g->toptr=g->tolast=NULL;
	addend(g,tostate);			/* Add to the end of empty */
	if (group) {				/* Link it into the list */
	    g->next=group->next;
	    group->next=g;
	}
	else {
	    head=g;
	    g->next=NULL;
	}
	group=g;				/* We are now the last group */
    }
    else {					/* Added to existing group */
	if (group->next && group->end+1 == group->next->start) {
	    joingroup(group,group->next);	/* Coalesce adjacent groups */
	}
    }

    if (displ > nnact) {
	nnact=displ;				/* Remember deepest group */
    }
    troff();
    tract();
}

static void
addend(group,tostate)			/* Add to end of groups tolist */
GROUP *group;
int tostate;
{
    TOLIST *newto;

    newto=(TOLIST *)xalloc(sizeof(TOLIST));
    newto->tostate=tostate;
    if (group->tolast) {		/* Add to end of tolist */
	group->tolast->next=newto;
    }
    else {				/* Adding to empty tolist */
	group->tolast=group->toptr=newto;
    }
    newto->next=NULL;			/* We are the last */
    group->tolast=newto;
    ++group->end;
}

static void
addfront(group,tostate)
GROUP *group;
int tostate;
{
    TOLIST *newto;

    newto=(TOLIST *)xalloc(sizeof(TOLIST));
    newto->tostate=tostate;
    newto->next=group->toptr;
    group->toptr=newto;
    if (group->tolast == NULL) {
	group->tolast=newto;
    }
    --group->start;
}

static void
joingroup(g1,g2)
GROUP *g1,*g2;
{
    trace(("joingroup:\n"));
    tract();
    g1->tolast->next=g2->toptr;
    g1->tolast=g2->tolast;
    g1->end=g2->end;
    g1->next=g2->next;
    xfree((char *)g2);
    tract();
}

static int				/* Has base already been used ? */
isbase(base)
int base;
{
    int i;

    trace(("isbase: st %d nont %d base %d\n",st,nont,base));
    for (i=0; i<st; ++i) {		/* Look at filled shift bases */
	if (yxpact[i] == base) {
	    trace(("isbase: yxpact[]==base\n"));
	    return 1;
	}
    }
    for (i=0; i<nont; ++i) {		/* Look at filled goto bases */
	if (yxpgo[i] == base) {
	    trace(("isbase: yxpgo[]==base\n"));
	    return 1;
	}
    }
    return 0;
}

static void
getshift()
{
    if ((gttok=getw(fshift)) != -1 ) {	/* Token (real value) */
	gtfrom=getw(fshift);		/* From state (sorted on this) */
	gtto=getw(fshift);		/* To state */
    }
}

static void
getgoto()
{
    if ((gtnont=getw(fgoto)) != -1 ) {	/* Nont (real value)(sorted on this) */
	gtfrom=getw(fgoto);		/* From state */
	gtto=getw(fgoto);		/* To state */
    }
}

static int
ytact(i)
int i;
{
    void bstart(),gadvance();
    int r;

    if (i == 0) {
	base=0;
	bstart();			/* Start at the beginning */
    }
    if (i == gdispl) {
	r=toptr->tostate;
	gadvance();
	return r;
    }
    else {
	return 0;			/* Space is filled with 0 */
    }
}

static int
ytpgo(i)
int i;
{
    return yxpgo[i];
}

static int
ytpact(i)
int i;
{
    return yxpact[i];
}

static int
ytchk(i)
int i;
{
    return yxchk[i];
}

#ifdef TRACE
static void
dpoff()
{
    printf("bdispl %d bgroup %08lx btoptr %08lx\tbase %d low %d\n",
	bdispl,(unsigned long)bgroup,(unsigned long)btoptr,base,low);
    printf("gdispl %d  group %08lx  toptr %08lx",
	gdispl,(unsigned long)group,(unsigned long)toptr);
    if (group) {
	printf("\tstart %d end %d",group->start,group->end);
    }
    printf("\nvdispl %d   vptr %08lx",vdispl,(unsigned long)vptr);
    if (vptr) {
	printf("\tvoffset %d vtostate %d",vptr->offset,vptr->tostate);
    }
    printf("\n");
}

static void
dpact()
{
    void dpto();
    GROUP *g;

    g=head;
    while (g) {
	printf("%08lx: group\tstart %d end %d\n",
	    (unsigned long)g,g->start,g->end);
	dpto(g->toptr);
	g=g->next;
    }
}

static void
dpto(t)
TOLIST *t;
{
    while (t) {
	printf("\t%08lx: to %d\n",(unsigned long)t,t->tostate);
	t=t->next;
    }
}

#endif
