/* Yafdef.c	21-Jan-87	Parser functions used in defs only */
/* 22-Jul-87 */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	docommand()	setprec()	setassoc()
			settype()
*/

#include <stdio.h>

#define PHASE1

#include "yadefs.h"

void
docommand(sym,toknum)
SYMBOL *sym;			/* Symbol is identifier or literal */
int toknum;			/* Token number */
{
    void settok(),setnum(),setprec(),setassoc(),settype(),setnont();

    switch (command) {
	case TOKEN:	settok(sym,toknum);
			settype(sym,curtype);
			break;
	case LEFT:
	case RIGHT:
	case NONASSOC:
			settok(sym,toknum);
			setprec(sym,curprec);
			setassoc(sym,command);
			settype(sym,curtype);
			break;
	case TYPE:
			setnont(sym);
			settype(sym,curtype);
			break;
	default:
			bug("Docommand");
			break;
    }
}

void
setprec(sym,prec)
SYMBOL *sym;
int prec;
{
    if (sym->prec && sym->prec != prec) {
	errmsg("Can't redefine precedence",FATAL);
    }
    else {
	sym->prec=prec;
    }
}

void
setassoc(sym,assoc)
SYMBOL *sym;
int assoc;
{
    if (sym->assoc != NONE && sym->assoc != assoc) {
	errmsg("Can't redefine associativity",FATAL);
    }
    else {
	sym->assoc=assoc;
    }
}

void
settype(sym,type)
SYMBOL *sym;
char *type;
{
    if (type != NOTYPE) {
	if (sym->type != NOTYPE) {
	    if (sym->type != type) {
		errmsg("Can't redefine type",FATAL);
	    }
	    /* else same so leave */
	}
	else {
	    sym->type=type;
	}
    }
    /* else leave it alone whether sym->type is NOTYPE or not */
    /* ie. allows %token <type> sym then later %left sym without type */

    /* this isn't necessary for prec and assoc because %token can't set */
    /* either of these, and setprec/setassoc aren't called for %token */
}

