/* Yaconf.c	27-Nov-86	Scan transitions resolving conflicts */
/* 05-Jan-87	NB. All external (youtput,yxdef[],yxexca[]) references to */
/*		rules are to the ruleseq[] number, NOT to the internally */
/*		used rule number in fitem, etc - this is in order to use */
/*		the sequence number to index the action case statement */
/*		The internal number is different, since rules are grouped by */
/*		parent nonterminal */
/* 25-Jul-87 IBM */
/* 09-Jul-89 ZTC */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	conf()

	Statics:	ytdef()		ytexca()	ytr1()
			ytr2()		srconf()	endstate()
			rrconf()	finddef()	addexca()
			dotrans()	gettrans()	doitem()
			getitem()	lsitem()
*/

#include <stdio.h>

#define PHASE2

#include "yadefs.h"

#define realtok(s)	( toknum[(s)] )

static FILE *fconflict;			/* Where to send conflict messages */
static int sr,psr,rr;			/* Count of conflicts (p..=resolved) */
static int *yxdef;			/* Array of default reductions */
					/* Size of cnstate */

typedef struct intlist {
    struct intlist *next;
    int val;
} INTLIST;

static INTLIST *yxexca;			/* List of exception PAIRS */
static int nnexca;			/* Number of list entries (2*pairs) */

static int txsym;
static int txfrom;
static int txto;
static int itst;
static int itlhs;
static int itrule;
static int itdposn;
static int comprule;			/* Rule just seen in state (real) */

void
conf()					/* Resolve conflicts */
{
    void getitem(),gettrans(),doitem(),dotrans(),endstate();
    void yttable();
    int ytdef(),ytexca(),ytr1(),ytr2();
    int st;
    INTLIST *l,*l2;

    message("conf:");

    ftrans=xopen(ntrans,READ_BINARY);
    fshift=xopen(nshift,WRITE_BINARY);
    if (o_verbose) {
	foutput=xopen(noutput,"w");
	fconflict=foutput;		/* Conflicts go with description */
    }
    else {
	fconflict=stderr;		/* Conflicts go to stderr */
    }
    fitem=xopen(nitem,READ_BINARY);

    yxdef=(int *)xalloc(cnstate*sizeof(int));

    yxexca=NULL;
    nnexca=0;				/* Exception table empty */

    sr=psr=rr=0;
    cnshift=0;				/* Count entries in fshift */

    getitem();				/* Lookahead at files */
    gettrans();

    for (st=0; st <cnstate; ++st) {
	if (o_verbose) fprintf(foutput,"state %u\n",st);
	yxdef[st]=0;			/* Default action is error */
	doitem(st);
	dotrans(st);
	endstate(st);
	if (o_verbose) fprintf(foutput,"\n");
    }
    fprintf(fconflict,
	"%u shift/reduce, %u reduce/reduce conflicts reported\n",
	sr,rr);
    fprintf(fconflict,
	"(another %u shift/reduce conflicts resolved)\n",psr);

    xclose(ftrans);
    putw(-1,fshift);		/* Eof indicator */
    xclose(fshift);
    if (o_verbose) xclose(foutput);
    xclose(fitem);

    fytabc=xopen(nytabc,"a");
    yttable(fytabc,ytdef,"yydef",cnstate,TABLEWIDTH);
    yttable(fytabc,ytexca,"yyexca",nnexca,2);
    yttable(fytabc,ytr1,"yyr1",cnrule,TABLEWIDTH);
    yttable(fytabc,ytr2,"yyr2",cnrule,TABLEWIDTH);
    xclose(fytabc);

    xfree((char *)yxdef);
    for (l=yxexca; l; l=l2) {
	l2=l->next;
	xfree((char *)l);
    }
}

static int
ytdef(i)
int i;
{
    return yxdef[i];
}

static int
ytexca(i)			/* MUST be called from 0 consecutively */
int i;
{
    static INTLIST *l;

    if (i)
	return (l=l->next)->val;
    else
	return (l=yxexca)->val;
}

static int
ytr1(i)
int i;
{
    int j;

    for (j=0; ruleseq[j] != i; ++j);
    return valnont(rulesym[j]);
}

static int
ytr2(i)
int i;
{
    int j;

    for (j=0; ruleseq[j] != i; ++j);
    return lngrule(j);
}

static int			/* Check that there is no conflict */
srconf(tok,from,to)		/* Returns 1 shift not to be deleted */
int tok;
int from;
int to;
{
    int fail,delreduce,delshift;
    int i,r;

    delshift=delreduce=fail=0;
    for (i=0; i<cnincon; ++i) {
	if (ist[i] == from) {
	    if (isbit(ila[i],tok)) {
		r=irule[i];
		trace(("check: tokassoc %u tokprec %u ruleprec %u\n",
			tokassoc[tok],tokprec[tok],ruleprec[r]));
		if (tokprec[tok] == 0 || ruleprec[r] == 0) {
		    fail=1;
		    delreduce=1;	/* Default is to shift */
		}
		else if (tokprec[tok] == ruleprec[r]) {
		    switch (tokassoc[tok]) {
			case LEFT:	/* Resolve by reduction */
					delshift=1;
					break;
			case RIGHT:	/* Resolve by shift */
					delreduce=1;
					break;
			case NONE:	/* Can't resolve - fall thru */
					fail=1;
			case NONASSOC:	/* Error - don't shift or reduce ! */
					delshift=1;
					delreduce=1;
					break;
		    }
		}
		else if (tokprec[tok] < ruleprec[r]) {
		    delshift=1;
		}
		else {
		    delreduce=1;
		}
		if (fail) {
		    ++sr;
		}
		else {
		    ++psr;
		}
		if (delreduce) {
		    trace(("check: delete reduction\n"));
		    clrbit(ila[i],tok);
		}
		if (fail || o_listall) {
		    fprintf(fconflict,
			"%u:s/r conflict (shift %u,reduce %u) on %s\n",
			from,to,ruleseq[r],nametok(tok));
		}
	    }
	}
    }
    return (delshift == 0);
}

static void
endstate(st)
int st;
{
    void addexca();
    void rrconf();
    int finddef();
    int idef,ifirst,ilast,i,j,k,r;

    for (i=0; i<cnincon && ist[i]!=st; ++i);
    ifirst=i;
    for (i=ifirst; i<cnincon && ist[i]==st; ++i);
    ilast=i-1;
    trace(("endstate: from %u(%u) to %u(%u)\n",
	ifirst,ist[ifirst],ilast,ist[ilast]));

    if (ilast > ifirst) {		/* Is a complex state */
					/* ie. >1 complete item */
	rrconf(ifirst,ilast);		/* Resolve any rr conflict */

	if (yxdef[st] != -2) {		/* No exception used yet(eg. accept) */
	    yxdef[st]=-2;		/* Flag use of exception for state */
	    addexca(-1,st);		/* Exception state */
	}
	idef=finddef(ifirst,ilast);	/* Find rule to use as default */

	for (i=ifirst; i<=ilast; ++i) {	/* For all rules */
	    if (i != idef) {		/* Apart from default */
		r=irule[i];
		for (k=0; k<cntok; ++k) {
		    if (isbit(ila[i],k)) {
			addexca(realtok(k),ruleseq[r]);
					/* lookahead k -> reduce to r */
			if (o_verbose) {
			    fprintf(foutput,"\t%s\treduce %u\n",
				nametok(k),ruleseq[r]);
			}
		    }
		}
	    }
	}
	addexca(-2,ruleseq[r=irule[idef]]);	/* default reduction */
	if (o_verbose) fprintf(foutput,"\t.\treduce %u\n",ruleseq[r]);
    }
    else {				/* Is simple or inconsistent */
					/* with only one complete item */

	if (yxdef[st] == -2) {		/* Add default error or reduce */
	    addexca(-2,comprule);	/* To exception list */
	}
	else {
	    yxdef[st]=comprule;		/* No exceptions */
	}
	if (o_verbose) {
	    if (comprule) {
		fprintf(foutput,"\t.\treduce %u\n",comprule);
	    }
	    else {
		fprintf(foutput,"\t.\terror\n");
	    }
	}
    }
}

static void				/* Resolve any rr conflict */
rrconf(ifirst,ilast)
int ifirst,ilast;			/* Range of incon table to check */
{
    int i,j,k;

    for (k=0; k<cntok; ++k) {
	trace(("rrconf: token %s\n",nametok(k)));
	for (i=ifirst; i<=ilast; ++i) {
	    trace(("rrconf: item %u\n",i));
	    if (isbit(ila[i],k)) {
		trace(("rrconf: item %u lookahead %s\n",i,nametok(k)));
		for (j=ifirst; j<i; ++j) {
		    trace(("rrconf: checking against item %u\n",j));
		    if (isbit(ila[j],k)) {
		        trace(("rrconf: conflict\n"));
		        ++rr;
		        fprintf(fconflict,
			    "%u:r/r conflict (reduce %u, %u) on %s\n",
			    ist[i],ruleseq[irule[i]],
			    ruleseq[irule[j]],nametok(k));
		        if (ruleseq[irule[i]] < ruleseq[irule[j]]) {
			    trace(("rrconf: removing from %u\n",j));
			    clrbit(ila[j],k);
		        }
		        else {	/* Default is to use earlier rule */
			    trace(("rrconf: removing from %u\n",i));
			    clrbit(ila[i],k);
		        }
		    }
		}
	    }
	}
    }
}

static int			/* Find default reduction */
finddef(ifirst,ilast)
int ifirst,ilast;			/* Index to rules in incon table */
{
    int most,count,idef,i,j;

    most=0;
    idef=ifirst;			/* Just in case all empty !! ?? */
    for (i=ifirst; i<=ilast; ++i) {	/* For each rule */
	count=0;
	for (j=0; j<cntok; ++j) {	/* Count number of lookahead symbols */
	    if (isbit(ila[i],j)) {
		++count;
	    }
	}
	if (count > most) {		/* Default is the one with the most */
	    most=count;			/* Lookahead symbols */
	    idef=i;
	}
    }
    return idef;
}

static void
addexca(v1,v2)
int v1,v2;
{
    INTLIST *l,*l1,*l2;

    for (l=yxexca; l && l->next; l=l->next);

    l1=(INTLIST *)xalloc(sizeof(INTLIST));
    l2=(INTLIST *)xalloc(sizeof(INTLIST));
    if (l)
	l->next=l1;
    else
	yxexca=l1;
    l1->next=l2;
    l2->next=NULL;
    l1->val=v1;
    l2->val=v2;
    nnexca+=2;
}

static void
dotrans(st)
int st;
{
    void gettrans();
    int srconf();
    int real,tok,lastsym;

    trace(("dotrans:\n"));
    lastsym=-1;				/* Don't do duplicate entries */
    while (txsym != -1 && txfrom == st) {
	if (txsym != lastsym) {
	    lastsym=txsym;
	    if (istok(txsym)) {
		tok=valtok(txsym);
		real=realtok(tok);
		if (srconf(tok,txfrom,txto)) {	/* Shift is valid */
		    if (real == ENDTOKEN) {	/* Shift on $end is accept */
			if (o_verbose) {
			    fprintf(foutput,"\t%s\taccept\n",nametok(tok));
			}
			yxdef[st]=-2;		/* Flag use of exception */
			addexca(-1,st);		/* Set exception state */
			addexca(real,-1);	/* $end -> Accept */
		    }
		    else {
			if (o_verbose) {
			    fprintf(foutput,"\t%s\tshift %u\n",
				nametok(tok),txto);
			}
			++cnshift;
			putw(real,fshift);	/* Token's real value */
			putw(txfrom,fshift);	/* From state */
			putw(txto,fshift);	/* To state */
		    }
		}
	    }
	    else {				/* Is nont */
		if (o_verbose) {
		    fprintf(foutput,"\t%s\tgoto %u\n",namesym(txsym),txto);
		}
	    }
	}
	gettrans();
    }
}

static void
gettrans()
{
    trace(("gettrans:\n"));
    if ((txsym=getw(ftrans)) != -1 ) {	/* Symbol */
	txfrom=getw(ftrans);		/* From state (sorted on this) */
	txto=getw(ftrans);		/* To state */
	(void)getw(ftrans);		/* Ignore rule */
	(void)getw(ftrans);		/* Ignore dposn */
	trace(("gettrans: txsym=%u txfrom=%u txto=%u\n",txsym,txfrom,txto));
    }
}

static void
doitem(st)
int st;
{
    void getitem(),lsitem();

    trace(("doitem:\n"));
    comprule=0;				/* No complete item found yet */
    while (itst != -1 && itst == st) {
	if (o_verbose) {
	    lsitem(itrule,itdposn,itlhs);
	}
	if (itdposn == 0) {		/* Complete item */
	    comprule=ruleseq[itrule];	/* Remember real rule for endstate() */
	}
	getitem();
    }
    if (o_verbose) fprintf(foutput,"\n");
}

static void
getitem()
{
    trace(("getitem:\n"));
    if ((itst=getw(fitem)) != -1) {	/* State containing item */
	itlhs=getw(fitem);		/* LHS Symbol (NB. Not valnont()) */
	itrule=getw(fitem);		/* Rule number */
	itdposn=getw(fitem);		/* Distinguished posn (0=complete) */
	trace(("getitem: itst=%u itlhs=%u itrule=%u itdposn=%u\n",
		itst,itlhs,itrule,itdposn));
    }
}

static void
lsitem(rule,dposn,lhs)
int rule,dposn,lhs;
{
    int i,end;

    end=lngrule(rule)+1;
    dposn=dposn ? dposn : end;
    fprintf(foutput,"\t%s\t: ",namesym(lhs));
    for (i=1; i<dposn; ++i) {
	fprintf(foutput,"%s ",namesym(rhs[rulerhs[rule]+i-1]));
    }
    fprintf(foutput,"_ ");
    for (i=dposn; i<end; ++i) {
	fprintf(foutput,"%s ",namesym(rhs[rulerhs[rule]+i-1]));
    }
    if (dposn == end) {		/* Complete items - append rule sequence */
	fprintf(foutput,"\t(%u)",ruleseq[rule]);
    }
    fprintf(foutput,"\n");
}

