/* Yabit.c	30-Oct-86	Bit handling routines */
/* 25-Jul-87 IBM */
/* 25-Mar-88 VAXVMS */
/* 23-Apr-88 */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	eqbit()		orbit()		copybit()
			zerobit()
			[#ifndef BITMACRO
			isbit()		setbit()	clrbit()
			sizebit()	alcbit()]

*/

#include <stdio.h>

#include "yadefs.h"

int
eqbit(to,from,n)
BITSTR *to,*from;
int n;
{
    int i;

    for (i=0; i<sizebit(n); ++i) {
	if (*from++ != *to++) {
	    return 0;
	}
    }
    return 1;
}

#ifdef AND				/* Not used any more */
int
andbit(to,from,n)
BITSTR *to,*from;
int n;
{
    int i,overlap;

    overlap=0;
    for (i=0; i<sizebit(n); ++i) {
	if (*from=(*to & *from)) {
	    ++overlap;
	}
	++to;
	++from;
    }
    return overlap;
}
#endif

int
orbit(to,from,n)
BITSTR *to,*from;
int n;
{
    int i,added;

	/* NB. For last word, may not all be be in use as bit string */
	/* but both unused tails will be 0 since zerobit() and hence */
	/* won't interfere with the comparison or the or operation */

    added=0;
    for (i=0; i<sizebit(n); ++i) {
	trace(("*to=%04x *from=%04x &=%04x ^=%04x\n",
		*to,*from,(*to & *from),(*from ^ (*to & *from))));
	if (*from ^ (*to & *from)) {	/* If there is anything in from that */
					/* is not already in to */
	    *to|= *from;		/* Add it to to */
					/* "= *" avoids old assignment op */
	    trace(("new *to=%04x\n",*to));
	    ++added;
	}
	++to;
	++from;
    }
    return added;
}

void
copybit(to,from,n)
BITSTR *to,*from;
int n;
{
    int i;

    for(i=0; i<sizebit(n); ++i) *to++= *from++;
					/* "= *" avoids old assignment op */
}

void
zerobit(s,n)
BITSTR *s;
int n;
{
    int i;

    for(i=0; i<sizebit(n); ++i) *s++=0;
}

#ifndef BITMACRO

int
isbit(s,n)
BITSTR *s;
int n;
{
    return ( ((s)[(n) / BITLNG]) &  (1 << ((n) % BITLNG)) );
}

void
setbit(s,n)
BITSTR *s;
int n;
{
    ( ((s)[(n) / BITLNG]) |= (1 << ((n) % BITLNG)) );
}

void
clrbit(s,n)
BITSTR *s;
int n;
{
    ( ((s)[(n) / BITLNG]) &= ~(1 << ((n) % BITLNG)) );
}

int
sizebit(n)
int n;
{
    return ( (n-1)/BITLNG+1 );
}

BITSTR *
alcbit(n)
int n;
{
    return ( (BITSTR *)xalloc(sizebit(n)*BITBYTE) );
}

#endif
