/*
 * WMAIL -	MicroWalt Extended Mail Agent.
 *		This is the MicroWalt Mail Agent; which is derived
 *		from  the  "Mini-Mail" written by Peter S. Housel.
 *
 *		M E S S A G E    D E L I V E R Y    M O D U L E
 *
 * Author:	Fred van Kempen, MicroWalt Corporation
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <pwd.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include "wmail.h"


static int doneit;			/* did we record this message? */
extern int errno;			/* missing from "sys/errno.h" */


/* Send a message to a remote user. */
void send_remote(name)
char *name;
{
  char cmdbuff[128];
#ifdef UMAILER
  sprintf(cmdbuff, "exec %s -i%s %s %s %s >/dev/null", RMAIL, tempfn,
#else
  sprintf(cmdbuff, "exec %s <%s %s %s %s >/dev/null", RMAIL, tempfn,
#endif
	immediate ? "-n" : "", verbose ? "-v" : "", name);
  system(cmdbuff);
}


/* Deliver a message to a user. */
int deliver(addr, mailfp)
char *addr;
FILE *mailfp;
{
  void (*sigint)(), (*sighup)(), (*sigquit)();	/* saved signal state */
  char cpbuff[1024];			/* copy buffer */
  char lockname[PATHLEN];		/* maildrop lock */
  char addressee[PATHLEN];		/* name of addressee */
  char dlmbox[PATHLEN];			/* delivery mailbox */
  FILE *boxfp, *rfp;			/* record and mailbox file */
  struct stat stb;			/* for checking drop modes, owners */
  struct passwd *pw;			/* sender and recipent */
  int errs = 0;				/* count of errors */
  int dropfd;				/* file descriptor for user's drop */
  int created = FALSE;			/* true if we created the maildrop */
  int locktries;			/* tries when box is locked */

  /* Shut off signals during the delivery. */
  sigint = signal(SIGINT, SIG_IGN);
  sighup = signal(SIGHUP, SIG_IGN);
  sigquit = signal(SIGQUIT, SIG_IGN);

  /* Open record file if enabled. */
  if (rc_record != (char *)NULL && doneit == FALSE) {
	rfp = fopen(rc_record, "a");
	if (rfp != (FILE *)NULL) {
		/* This is a security hole ! */
		chown(rc_record, old_uid, old_gid);

		/* Copy temp. file to mailbox. */
		while (fgets(cpbuff, sizeof(cpbuff), mailfp) != (char *)NULL)
			fwrite(cpbuff, sizeof(char), strlen(cpbuff), rfp);

		/* To make sure! */
		fprintf(rfp, "\n");
		fclose(rfp);
		rfp = (FILE *)NULL;
		rewind(mailfp);
	}
	doneit = TRUE;
  }

  strcpy(forward, "");			/* Clear 'Forward' flag */
  strcpy(addressee, addr);		/* set addressee */

  /* OK, 'addressee' is the recipient. Check if local. */
  if (strchr(addressee, '!') || strchr(addressee, '@')) {
	remote = TRUE;			/* the guy is remote... */
       	send_remote(addressee);		/* call RMAIL for this... */
	return(FALSE);
  }

  /* Hmm, it is a local user. Do we know him? */
  if ((pw = getpwnam(addressee)) == (struct passwd *)NULL) {
	fprintf(stderr, "%s: user %s unknown\n", progname, addressee);
	return(TRUE);
  } else {
	sprintf(dlmbox, DROPNAME, addressee);
 	sprintf(lockname, LOCKNAME, addressee);
  }

  /* OK, we know him. Check if we have to forward his mail. */
  if (chk_box(dlmbox) == 1) {		/* forward messages to 'forward' */
	strcpy(addressee, forward);

        /* We now have the final addressee. Check for remote users again. */
	if (strchr(addressee, '!') || strchr(addressee, '@')) {
		remote = TRUE;
          	send_remote(addressee);		/* No, call RMAIL */
  	  	return(FALSE);
	} else {	/* Check if this guy is known. */
		if ((pw = getpwnam(addressee)) == (struct passwd *)NULL) {
			fprintf(stderr, "%s: forward-user %s unknown\n",
							progname, addressee);
		   	return(TRUE);
	        } else {
			sprintf(dlmbox, DROPNAME, addressee);
			sprintf(lockname, LOCKNAME, addressee);
		}
	}
  }

  /*
   * We now have a local user 'addressee' who exists.
   * Lock the maildrop while we're messing with it. Races are possible
   * (though not very likely) when we have to create the maildrop, but
   * not otherwise. If the box is already locked, wait awhile and try
   * again.
   */
   locktries = 0;
   created = 0;
trylock:
   if (link(dlmbox, lockname) != 0) {
	if (errno == ENOENT) {	/* user doesn't have a drop yet */
		if ((dropfd = creat(dlmbox, 0600)) < 0) {
			fprintf(stderr, "%s: cannot create drop for %s\n",
		      					progname, addressee);
			return(TRUE);
		}
		++created;
		goto trylock;
	} else {   /* somebody else has it locked, it seems - wait */
		if (++locktries >= LOCKTRIES) {	
			fprintf(stderr, "%s: could not lock drop for %s\n",
		      					progname, addressee);
	      		return(TRUE);
		}
		sleep(LOCKWAIT);
		goto trylock;
	}
  }

  if (created) {
	chown(dlmbox, pw->pw_uid, pw->pw_gid);
	boxfp = fdopen(dropfd, "a");
  } else boxfp = fopen(dlmbox, "a");

  if (boxfp == (FILE *)NULL || stat(dlmbox, &stb) < 0) {
	fprintf(stderr, "%s: serious drop problems for %s\n",
						progname, addressee);
        unlink(lockname);
        return(TRUE);
  }

  if (stb.st_uid != pw->pw_uid || (stb.st_mode & S_IFMT) != S_IFREG) {
	fprintf(stderr, "%s: mailbox for user %s is illegal\n",
						progname, addressee);
	unlink(lockname);
	return(TRUE);
  }

  /* Copy temp. file to mailbox. */
  while (TRUE) {
	if (fgets(cpbuff, sizeof(cpbuff), mailfp) == (char *)NULL) break;
	fwrite(cpbuff, sizeof(char), strlen(cpbuff), boxfp);
  }

  /* To make sure! */
  fprintf(boxfp, "\n");

  if (ferror(boxfp) || fclose(boxfp) != 0) {
	fprintf(stderr, "%s: error delivering to %s", progname, addressee);
	perror("");
	errs++;
  }
  unlink(lockname);

  /* Put signals back the way they were. */
  signal(SIGINT, sigint);
  signal(SIGHUP, sighup);
  signal(SIGQUIT, sigquit);

  return((errs == 0) ? FALSE : TRUE);
}


/*
 * Send a message to all users in 'vec[]'.
 * This is a rather tricky job, since the addresses may be aliases,
 * which may expand to multiple users in turn!
 * Return TRUE if an error ocurred, otherwise return FALSE.
 */
int do_send(vec, msg, quote)
char *vec[];				/* table of recipients */
char *msg;				/* ASCII value of message number */
int quote;				/* should the message be quoted? */
{
  char *addr[MAXRCPT];
  register FILE *mfp;
  int idx, adi, st;

  idx = 0;
  adi = 0;
  strcpy(recipients, "");
  while (vec[idx] != (char *)NULL) {
	adi = exp_alias(vec[idx], recipients, adi, addr);
	idx++;
  }
  if (sayall) recipients[strlen(recipients) - 2] = '\0'; /* kill last comma */
    else strcpy(recipients, addr[0]);

  /* Input the message with the Mail Editor. */
  mfp = edit_mail(msg, quote);
  if (mfp == (FILE *)NULL) return(FALSE);

  /* Add and expand the possible Cc: and Bcc: recipients. */
  if (addr_cc[0] != '\0') {
	adi = exp_alias(addr_cc, (char *)NULL, adi, addr);
  }
  if (addr_bcc[0] != '\0') {
	adi = exp_alias(addr_bcc, (char *)NULL, adi, addr);
  }
	
  /* We have the message, now deliver it to all recipients! */
  idx = 0;
  adi = 0;
  doneit = FALSE;
  while (addr[idx] != (char *)NULL) {
	rewind(mfp);				/* rewind data-file */
	st = deliver(addr[idx], mfp);		/* deliver message */
	if (st != 0) adi = st;			/* remember the error */
	if (addr[idx] != (char *)NULL)		/* free name in memory */
			free(addr[idx]);
	if (rc_copies == TRUE) doneit = FALSE;	/* reset record flag */
	idx++;					/* and do next message! */
  }

  fclose(mfp);
  return((adi == 0) ? FALSE : TRUE);
}


/* Send a FORWARDED message. */
void do_forward(let, quote, addr)
LETTER *let;
int quote;
char *addr;
{
  char *vec[2];
  char buff[16];

  sprintf(subject, "[ %s ]", let->sender2);
  sprintf(buff, "%d", let->seqno);

  /* Setup a recipient table. */
  vec[0] = addr;
  vec[1] = (char *)NULL;
  strcpy(addr_cc, "");
  strcpy(addr_bcc, "");


  /* We have the message, now send it to the recipient(s) ! */
  if (do_send(vec, buff, quote) == FALSE)
	printf("Letter %d has been forwarded to \"%s\"\n", let->seqno, addr);
    else printf("*** Forward: letter %d could not be forwarded.\n", let->seqno);
}


/* 
 * Save the current message to file 'dead.letter'.
 *
 * If the environmental variable "DEADLETTER" is defined,
 * use its value as the file name. Otherwise, use DEADLETTER
 * in the current directory. Check if we may write to that file!
 */
void dead_letter()
{
  char cpbuff[1024];
  char fname[PATHLEN];
  register FILE *inf, *outf;
  char *sp;

  fname[0] = '\0';
  if ((sp = getenv("DEADLETTER")) != (char *)NULL) strcpy(fname, sp);
    else sprintf(fname, "%s/%s", home, DEADLETTER);

  /* Open the message file. */
  if ((inf = fopen(tempfn, "r")) == (FILE *)NULL) {
	fprintf(stderr, "%s: cannot open \"%s\"\n", progname, tempfn);
	return;
  }

  /* Check if we may create/write that file. */
  if (allowed(fname, 02) == FALSE) {
	/* We may not. Say so! */
	fprintf(stderr, "%s: cannot create \"%s\"\n", progname, fname);
	fclose(inf);
	return;
  }

  /* We may create or append to the dump-file. */
  if ((outf = fopen(fname, "a")) == (FILE *)NULL) {
	fprintf(stderr, "%s: cannot create \"%s\"\n", progname, fname);
	fclose(inf);
	return;
  }

  /* Copy temp. file to dead.letter. */
  while (TRUE) {
	if (fgets(cpbuff, sizeof(cpbuff), inf) == (char *)NULL) break;
	fwrite(cpbuff, sizeof(char), strlen(cpbuff), outf);
  }

  fclose(inf);
  fclose(outf);

  /* Make the sender owner of the file. */
  chown(fname, old_uid, old_gid);

  fprintf(stderr, "%s: dumped message on file \"%s\"\n", progname, fname);
}
