/*
 * WMAIL -	MicroWalt Extended Mail Agent.
 *		This is the MicroWalt Mail Agent; which is derived
 *		from  the  "Mini-Mail" written by Peter S. Housel.
 *
 *		The paging-code (for paging letters on the screen)
 *		was taken from "more.c", by Brandon Allbery.
 *
 *		R E A D    M A I L    M O D U L E
 *
 * Author:	Fred van Kempen, MicroWalt Corporation
 */
#include <sys/types.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <sgtty.h>
#include <termcap.h>
#include <unistd.h>
#include <stdio.h>
#include "wmail.h"


#define MOREBUF		1024		/* "More" output buffer size */


static char mobuf[MOREBUF];		/* output buffer */
static char tcaps[256];			/* Termcap capability buffer */
static int mline;			/* current terminal line */
static int mcol;			/* current terminal column */
static int mobc;			/* position in output buffer */
static int CO;				/* number of chars on screen line */
static int LI;				/* number of lines on screen */
static char *SO;			/* StandOUT (reverse) mode */
static char *SE;			/* StandIN (normal) mode */
static char *CE;			/* ClearToEndOfLine */
static char *TERMINAL = (char *)NULL;	/* Terminal name/identifier */


/* Write one line of text to the screen. */
static int lwrite(fd, buf, len)
int fd;
char *buf;
unsigned len;
{
  int here, start;
  int cmd;

  start = 0;
  here = 0;
  while (here != len) {
	cmd = '\0';
      	switch (buf[here++]) {
		case '\n':
			mcol = 0;
			if (++mline == LI) {
				fflush(stdout);
		     		write(1, buf + start, here - start);
		     		fflush(stdout);
		     		fprintf(stderr,
					"%s--More--%s", SO, SE);
		     		do {
				    read(fd, &cmd, 1);
       				} while (strchr(" \r\nqQ'nN", cmd)
							== (char *)NULL);
		        	fprintf(stderr, "\r%s", CE);
		        	mline = 0;
		        	start = here;
 	  		}
			break;
		case '\r':
			mcol = 0;
			break;
		case '\b': 
			if (mcol != 0) mcol--;
			  else {
				mline--;
				mcol = CO - 1;
			}
			break;
		case '\t':
			do {
			    mcol++;
			} while (mcol % 8 != 0);
			break;
		default:   
			if (buf[here-1] < ' ' || (buf[here-1] & 0x80))
		  					 buf[here-1] = '?';
			if (++mcol == CO) {
				mcol = 0;
		     		if (++mline == LI) {
		       			fflush(stdout);
		       			write(1, buf + start, here - start);
		       			fflush(stdout);
		       			fprintf(stderr, 
						"%s--More--%s", SO, SE);
		       			do {
			   		    read(fd, &cmd, 1);
       			  		} while (strchr(" \r\nqQ'nN", cmd)
							== (char *)NULL);
		       			fprintf(stderr, "\r%s", CE);
		       			mline = 0;
		       			start = here;
		      		}
		    	}
	}
      	switch (cmd) {
		case '\0':
			break;
		case ' ':
			mline = 0;
		   	break;
		case '\r':
		case '\n':
			mline = LI - 1;
		   	break;
		case 'q':
		case 'Q':
		   	return(1);
		case 'n':
		case 'N':
			return(1);
		default:
			break;
	}
  }
  if (here != start) {
	fflush(stdout);
	write(1, buf + start, here - start);
	fflush(stdout);
  }
  return(0);
}


/* Display the given letter on the screen. */
void showlet(let)
LETTER *let;
{
  struct sgttyb ttymode;
  off_t curr, limit;
  int c, fd, st;

  if ((fd = open("/dev/tty", O_RDONLY)) == -1) {
	fprintf(stderr, "%s: cannot open /dev/tty\n", progname);
	return;
  }
  ioctl(fd, TIOCGETP, &ttymode);
#ifdef _MINIX
  ttymode.sg_flags |= CBREAK;
#else
  ttymode.sg_flags |= RAW;
#endif /* _MINIX */
  ttymode.sg_flags &= ~ECHO;
  ioctl(fd, TIOCSETP, &ttymode);

  if (TERMINAL == (char *)NULL) tcap_init();
  st = 0;
  mobc = 0;
  mline = 1;
  mcol = 0;

  fseek(boxfp, (curr = let->location), SEEK_SET);
  limit = (let->next != NIL_LET) ? let->next->location : -1L;

  printf("Message %d:\n", let->seqno);
  while(curr != limit && ((c = fgetc(boxfp)) != EOF) && st==0) {
	if (mobc == MOREBUF) {
		st = lwrite(fd, mobuf, mobc);
        	mobc = 0;
       	}
      	mobuf[mobc++] = (char) c;
      	++curr;
  }
  if (st == 0) lwrite(fd, mobuf, mobc);
  mobc = 0;
  fflush(stdout);

#ifdef _MINIX
  ttymode.sg_flags &= ~CBREAK;
#else
  ttymode.sg_flags &= ~RAW;
#endif /* _MINIX */
  ttymode.sg_flags |= ECHO;
  ioctl(fd, TIOCSETP, &ttymode);
  close(fd);
}


/* Print the contents of letter 'let' to file 'tofp' . */
void printlet(let, tofp)
LETTER *let;
FILE *tofp;
{
  off_t curr, limit, oldpos;
  int c;

  if (tofp==stdout && !printmode) {
	showlet(let);
	return;
  }

  oldpos = ftell(boxfp);
  fseek(boxfp, (curr = let->location), SEEK_SET);
  limit = (let->next != NIL_LET) ? let->next->location : -1L;

  if (tofp == stdout) printf("Message %d:\n", let->seqno);
  while(curr != limit && (c = fgetc(boxfp)) != EOF) {
	fputc(c, tofp);
	++curr;
  }
  fflush(tofp);
  fseek(boxfp, oldpos, SEEK_SET);
}


/* Print all letters and quit. */
void printall()
{
  LETTER *let;

  let = firstlet;
  if (let == NIL_LET) {
	fprintf(stderr, "No mail for %s.\n", sender);
	return;
  }

  while(let != NIL_LET) {
      	printlet(let, stdout);
      	let = let->next;
  }
}


/* Initialize the various TERMCAP entries. */
static int tcap_init()
{
  char buf[1024];
  char *tbufp;

  tbufp = tcaps;

  if ((TERMINAL = getenv("TERM")) == (char *)NULL) {
        write(2, "TERM not defined, using \"minix\"\n", 32);
        TERMINAL = "minix";
  }
  switch(tgetent(buf, TERMINAL)) {
        case -1:
                write(2, "No /etc/termcap present!\n", 25);
                exit(-1);
        case 0:
                write(2, "No termcap definition for $TERM\n", 32);
                exit(-1);
        default:
                break;
  }
  if ((SO = tgetstr("so", &tbufp)) == (char *)NULL) {
        write(2, "Termcap: \"so\" not defined!\n", 27);
        exit(-1);
  }
  if ((SE = tgetstr("se", &tbufp)) == (char *)NULL) {
        write(2, "Termcap: \"se\" not defined!\n", 27);
        exit(-1);
  }
  if ((CE = tgetstr("ce", &tbufp)) == (char *)NULL) {
	write(2, "Termcap: \"ce\" not defined!\n", 27);
	exit(-1);
  }
  LI = tgetnum("li") - 1;	/* --More-- counts! */
  CO = tgetnum("co");
}
