/*
 * WMAIL -	MicroWalt Extended Mail Agent.
 *		This is the MicroWalt Mail Agent; which is derived
 *		from  the  "Mini-Mail" written by Peter S. Housel.
 *
 *		R E A D    M A I L R C   M O D U L E
 *
 * Author:	Fred van Kempen, MicroWalt Corporation
 */
#include <sys/types.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "wmail.h"


typedef struct _alias_ {
  struct _alias_ *next;
  char           *alias;
  char           *expand;
} ALIAS;
#define NIL_ALIAS	(ALIAS *)NULL


int rc_asksub = FALSE;				/* ask for Subject: line */
int rc_askcc = FALSE;				/* ask for Cc: line */
int rc_askbcc = FALSE;				/* ask for Bcc: line */
int rc_autosig = FALSE;				/* automatic .signature */
int rc_copies = FALSE;				/* save all copies in record */ 
char *rc_signature = SIGNATURE;			/* .signature file */
char *rc_folder = (char *)NULL;			/* mail folder */
char *rc_mbox = SAVEFILE;			/* mail save file */
char *rc_record = (char *)NULL;			/* traffic recording file */
char *rc_shell = SHELL;				/* escape shell */
char *rc_prompt = PROMPT;			/* mail prompt */
char *rc_eedit = EEDITOR;			/* line editor */
char *rc_vedit = VEDITOR;			/* visual editor */
static ALIAS *rc_alist = NIL_ALIAS;		/* alias list */


#define isterm(c) ((c) == ' ' || (c) == '\t' || (c) == '#' || (c) == '=')


/* Assign a "set" variable. */
static void do_set(var, val, assign)
char *var;
char *val;
int assign;
{
  char *sp;

  if (assign == FALSE) {	/* booleans only */
	if (!strcmp(var, "asksub")) rc_asksub = TRUE;
	  else if (!strcmp(var, "noasksub")) rc_asksub = FALSE;
	  else if (!strcmp(var, "askcc")) rc_askcc = TRUE;
	  else if (!strcmp(var, "noaskcc")) rc_askcc = FALSE;
	  else if (!strcmp(var, "askbcc")) rc_askbcc = TRUE;
	  else if (!strcmp(var, "noaskbcc")) rc_askbcc = FALSE;
	  else if (!strcmp(var, "autosig")) rc_autosig = TRUE;
	  else if (!strcmp(var, "noautosig")) rc_autosig = FALSE;
	  else if (!strcmp(var, "copies")) rc_copies = TRUE;
	  else if (!strcmp(var, "nocopies")) rc_copies = FALSE;
	  else printf("*** Error in .mailrc: unknown boolean variable \"%s\"\n", var);
  } else {			/* assigned variables */
	sp = (char *)malloc(strlen(val) + 2);
	if (sp == (char *)NULL) {
		printf("*** Error in .mailrc: out of memory for \"%s\"\n", var);
		return;
	} else strcpy(sp, val);
	if (!strcmp(var, "eeditor")) rc_eedit = sp;
	  else if (!strcmp(var, "veditor")) rc_vedit = sp;
	  else if (!strcmp(var, "shell")) rc_shell = sp;
	  else if (!strcmp(var, "prompt")) rc_prompt = sp;
	  else if (!strcmp(var, "signature")) rc_signature = sp;
	  else if (!strcmp(var, "folder")) rc_folder = sp;
	  else if (!strcmp(var, "record")) rc_record = sp;
	  else if (!strcmp(var, "mailsave")) rc_mbox = sp;
	  else {
		printf("*** Error in .mailrc: unknown variable \"%s\"\n", var);
		free(sp);
	}
  }
}


/* Add an "alias" or "group" alias to the list. */
static void do_alias(name, expand)
char *name;
char *expand;
{
  register ALIAS *ap, *xp;

  xp = (ALIAS *) malloc(sizeof(ALIAS));
  if (xp == NIL_ALIAS) {
	printf("*** .mailrc: out of memory for alias \"%s\"\n", name);
	return;
  }
  xp->alias = (char *)malloc(strlen(name) + 2);
  xp->expand = (char *)malloc(strlen(expand) + 2);
  if (xp->alias == (char *)NULL || xp->expand == (char *)NULL) {
	printf("*** .mailrc: out of memory for expansion \"%s\"\n", expand);
	return;
  }
  strcpy(xp->alias, name);
  strcpy(xp->expand, expand);
  if (rc_alist == NIL_ALIAS) {	/* first alias */
	rc_alist = xp;
	xp->next = NIL_ALIAS;
  } else {
	ap = rc_alist;
	while (ap->next != NIL_ALIAS) ap = ap->next;
	ap->next = xp;
	xp->next = NIL_ALIAS;
  }
}


/* Read the mailer configuration file (".mailrc"). */
void rc_read(name)
char *name;
{
  char lbuf[512];
  char cmd[40];
  char var[40];
  char val[1024];
  int assign, quote;
  FILE *infp;
  register char *sp, *bp, *cp;

  if ((infp = fopen(name, "r")) == (FILE *)NULL) return;
  while (1) {
	sp = fgets(lbuf, 512, infp);
	cp = sp;
	if (sp == (char *)NULL) break;
	lbuf[strlen(lbuf) - 1] = '\0';
	switch (*sp) {
	    	case '\0':		/* blank line */
			continue;
	    	case '#':		/* comment line */
			continue;
	    	default:		/* data! */
			while (*sp == ' ' || *sp == '\t') sp++;
		   	bp = cmd;
			while (*sp && !isterm(*sp)) {
		 		if (*sp >= 'A' && *sp <= 'Z')
					*bp++ = *sp - 'A' + 'a';
				  else *bp++ = *sp;
				sp++;
			}
			*bp = '\0';

			while (*sp == ' ' || *sp == '\t') sp++;

			bp = var;
			while (*sp && !isterm(*sp)) {
				 if (*sp >= 'A' && *sp <= 'Z')
					*bp++ = *sp - 'A' + 'a';
				  else *bp++ = *sp;
				sp++;
			 }
			*bp = '\0';

			while (*sp == ' ' || *sp == '\t') sp++;

			bp = val;
			quote = FALSE;
			if (*sp == '=') {
				sp++;
				while (*sp == ' ' || *sp == '\t') sp++;
				assign = 1;
			} else assign = 0;
			while (*sp && *sp != '#') switch(*sp) {
				case '"':
					quote = TRUE - quote;
					sp++;
					continue;
				case ' ':
				case '\t':
					if (quote == TRUE) *bp++ = *sp;
					sp++;
					continue;
				case '#':
					if (quote == TRUE) *bp++ = *sp++;
					  else *sp = '\0';
					continue;
				default:
					*bp++ = *sp++;
					continue;
			}
			*bp = '\0';
	}
	if (!strcmp(cmd, "set")) do_set(var, val, assign);
	  else if (!strcmp(cmd, "alias") ||
		   !strcmp(cmd, "group")) do_alias(var, val);
	  else printf("*** .mailrc: syntax error:\n> %s\n", cp);
  }
  fclose(infp);
}


/*
 * Fetch the definition of an alias-to-be.
 * We do this with a routine instead of a global alias list,
 * to keep the ALIAS structure separated from the rest.
 */
char *rc_alias(aname)
char *aname;
{
  register ALIAS *ap;

  ap = rc_alist;
  while (ap != NIL_ALIAS) {
	if (!strcmp(ap->alias, aname)) return(ap->expand);
	ap = ap->next;
  }
  return((char *)NULL);
}
