/*
 * UMAIL -	MINIX Remote Domain-addressing Mail Router
 *
 *		This version of RMAIL handles message-headers in a much
 *		more "standard" way. It can handle bang-addresses, plus
 *		the new-style Internet addressing (user@host.domain).
 *		It is called by programs as "Mail" and "Uuxqt".
 *
 * 		D E F I N I T I O N S
 *
 * Author:	F. van Kempen, waltje@minixug.hobby.nl
 */

#ifdef _MINIX
#	define VERSION               "3.45/MINIX"
#	define CONFIG	"/usr/lib/uucp/umail.cf"
#endif	/* _MINIX */

#ifdef _UNIX
#	define VERSION                "3.45/UNIX"
#	define CONFIG	"/usr/lib/uucp/umail.cf"
#endif	/* _UNIX */

#ifndef TRUE
#	define FALSE	0
#	define TRUE	1
#endif	/* TRUE */

typedef struct __name {
  struct __name *next;
  char *name;
} NAME;

typedef struct __var {
  struct __var *next;
  char *name;
  char *value;
} VAR;

typedef struct __host {
  struct __host *next;
  char *name;
  int smart;
  char *command;
  char *opts;
} HOST;

typedef struct __routemap {
  struct __routemap *next;
  char *domain;
  char *host;
  char *route;
} ROUTE;

typedef struct {
  char user[256];			/* user name of address */
  char host[256];			/* host name of address */
  char domain[256];			/* domain name of address */
} BOX;

#define NILNAME      ((NAME *)NULL)
#define NILVAR        ((VAR *)NULL)
#define NILHOST      ((HOST *)NULL)
#define NILROUTE    ((ROUTE *)NULL)
#define NILBOX	      ((BOX *)NULL)


/* Globals in ummain.c. */
extern char *Version;			/* UMAIL version ID */
extern int immediate, debug;		/* commandline option flags */
extern int restrict;			/* restricted (UUCP) use only */
extern int aremote;			/* is addressee REMOTE or LOCAL ? */
extern int old_uid, old_gid;		/* original UID and GID of caller */
extern char dfile[], infile[];		/* names of message temp-files */
extern char errmsg[];			/* global error message */
extern char mailsender[];		/* who sent the message? */
extern char mailaddr[];			/* final routed address to use. */
extern char mailhost[];			/* which host to send to */
extern char mailcmd[];			/* command to use to send the mail */
extern char mailopts[];			/* which options the mailer uses */
extern NAME *namelist;			/* list of my network names */
extern VAR *varlist;			/* list of configuration variables */
extern HOST *hostlist;			/* list of reacheable host names */
extern ROUTE *routemap;			/* list of domain routes */

/* Configuration settings. */
extern char *myname;			/* my UUCP site name */
extern char *mydomain;			/* my UUCP domain name */
extern char *myorg;			/* Name of my organization */
extern char *mydept;			/* Name of my department */
extern int oldmailer;			/* mailer uses old From-lines? */
extern int usepath;			/* add "Path:" field to local mail */
extern int sendfrom;			/* add "From user date [remote from] line */
extern int escape;			/* routing ESCAPE enable */


/*
 * Function Prototypes.
 */
#if _MSDOS
#       define  _PROTOTYPE(function, params)    function params
#       define  _VOIDSTAR       void *
#       define  _VOID           void
#       define  _CONST          const
#       define  _VOLATILE       volatile
#       define _SIZET           size_t
#else
#ifndef _ANSI_H
#       include <ansi.h>
#endif  /* _ANSI_H */
#endif  /* _MSDOS */

_PROTOTYPE( char *xtime, (time_t *salt) );
_PROTOTYPE( struct tm *xltime, (time_t *pt) );
_PROTOTYPE( BOX *convert, (char *adr) );
_PROTOTYPE( int route, (BOX *box) );
_PROTOTYPE( int header, (FILE *infp, FILE *outfp) );
_PROTOTYPE( char *strupr, (char *s) );
_PROTOTYPE( char *strlwr, (char *s) );
_PROTOTYPE( void add_name, (char *name) );
_PROTOTYPE( void add_host, (char *name, int smart, char *cmd, char *opts) );
_PROTOTYPE( void add_route, (char *domain, char *host, char *route) );
_PROTOTYPE( void add_var, (char *name, char *val) );
_PROTOTYPE( char *lookup, (char *what) );
_PROTOTYPE( int boolean, (char *ascii) );
_PROTOTYPE( HOST *gethost, (char *host) );
_PROTOTYPE( ROUTE *getdomain, (char *domain) );
_PROTOTYPE( char *mfgets, (char *s, int n, FILE *iop) );
_PROTOTYPE( char *whoami, (void) );
_PROTOTYPE( char *full_id, (char *user) );
_PROTOTYPE( char *realname, (char *who) );
_PROTOTYPE( char *maketime, (time_t *salt) );
_PROTOTYPE( void fcopy, (FILE *inf, FILE *outf) );
_PROTOTYPE( int scanner, (char *fname) );
_PROTOTYPE( int KnowHost, (char *name) );
_PROTOTYPE( int islocal, (char *name) );
_PROTOTYPE( char *mesgid, (void) );
_PROTOTYPE( char *shortid, (void) );
_PROTOTYPE( char *genname, (int prefix, int grade, char *sysname) );
_PROTOTYPE( int send_local, (char *user, char *data) );
_PROTOTYPE( int send_remote, (char *rmtname, char *rmtuser, char *data) );
_PROTOTYPE( void errmail, (char *str, int mgronly) );
_PROTOTYPE( int sendit, (char *who, char *host, char *cmd, char *opts, char *data) );

