/*
 * WMAIL -	MicroWalt Extended Mail Agent.
 *		This is the MicroWalt Mail Agent; which is derived
 *		from  the  "Mini-Mail" written by Peter S. Housel.
 *		This version  has a better  user-interface, and it
 *		also "knows" about things like forwarding, replies
 *		etc. Overall, it looks like the Mail (uppercase M)
 *		on our local DYNIX(tm) (==BSD) system...
 *		The paging-code (for paging letters on the screen)
 *		was taken from "more.c", by Brandon Allbery.
 *
 *		R E A D    M A I L    M O D U L E
 *
 * Author:	Fred van Kempen, MicroWalt Corporation
 *
 * Revisions:
 *		11/07/89 FvK	Edited a little for the new MSS.
 *		11/10/89 FvK	Increased more() buffer size.
 *		12/04/89 FvK	Fixed return() bug.
 *				Removed ref's to 'misdone'.
 *		12/16/89 FvK	Added "more" output macro.
 *				Added "screen" macros.
 *				Cleanup.
 *		02/17/90 Fvk	Cleaned for release.
 *
 * To Do:
 *		- TERMCAP/TERMINFO use !
 */
#include <sys/types.h>
#include <string.h>
#include <sgtty.h>
#include <unistd.h>
#include <stdio.h>
#include "wmail.h"


#define MOREBUF		1024	/* "More" output buffer size */
#define STOUT	   "\033[7m"	/* ANSI/VT-100 StandOUT (reverse) mode */
#define STIN	   "\033[0m"	/* ANSI/VT-100 StandIN (normal) mode */
#define CLEOL	    "\033[K"	/* ANSI/VT-100 ClearToEndOfLine */


static char mobuf[MOREBUF];	/* output buffer */
static int mline;		/* current terminal line */
static int mcol;		/* current terminal column */
static int mobc;		/* position in output buffer (== chars in) */
static int   CO = 80;		/* number of chars on screen line */
static int   LI = 24;		/* number of lines on screen */
static char *SO = STOUT;	/* ANSI/VT-100 StandOUT (reverse) mode */
static char *SI = STIN;		/* ANSI/VT-100 StandIN (normal) mode */
static char *CE = CLEOL;	/* ANSI/VT-100 ClearToEndOfLine */


/*
 * Write one line of text to the screen.
 * Return 1 if a Quit command was given.
 */
static int lwrite(fd, buf, len)
int fd;
char *buf;
unsigned len;
{
  unsigned here, start;
  int cmd;

  start = 0;
  here = 0;
  while (here != len) {
	cmd = '\0';
      	switch (buf[here++]) {
		case '\n':
			mcol = 0;
			if (++mline == LI) {
				fflush(stdout);
		     		write(1, buf + start, here - start);
		     		fflush(stdout);
		     		fprintf(stderr,
					"\007%s--More--%s", SO, SI);
		     		do {
				    read(fd, &cmd, 1);
       				} while (strchr(" \r\nqQ'nN", cmd)
							== (char *)NULL);
		        	fprintf(stderr, "\r%s", CE);
		        	mline = 0;
		        	start = here;
 	  		}
			break;
		case '\r':
			mcol = 0;
			break;
		case '\b': 
			if (mcol != 0) mcol--;
			  else {
				mline--;
				mcol = CO - 1;
			}
			break;
		case '\t':
			do {
			    mcol++;
			} while (mcol % 8 != 0);
			break;
		default:   
			if (buf[here-1] < ' ' || (buf[here-1] & 0x80))
		  					 buf[here-1] = '?';
			if (++mcol == CO) {
				mcol = 0;
		     		if (++mline == LI) {
		       			fflush(stdout);
		       			write(1, buf + start, here - start);
		       			fflush(stdout);
		       			fprintf(stderr, 
						"\007%s--More--%s", SO, SI);
		       			do {
			   		    read(fd, &cmd, 1);
       			  		} while (strchr(" \r\nqQ'nN", cmd)
							== (char *)NULL);
		       			fprintf(stderr, "\r%s", CE);
		       			mline = 0;
		       			start = here;
		      		}
		    	}
	}
      	switch (cmd) {
		case '\0':
			break;
		case ' ':
			mline = 0;
		   	break;
		case '\r':
		case '\n':
			mline = LI - 1;
		   	break;
		case 'q':
		case 'Q':
		   	return(1);
		case 'n':
		case 'N':
			return(1);
		default:
			break;
	}
  }
  if (here != start) {
	fflush(stdout);
	write(1, buf + start, here - start);
	fflush(stdout);
  }
  return(0);
}


/*
 * Display the given letter on the screen.
 * Do this on a per-page basis...
 */
void showlet(let)
LETTER *let;
{
  struct sgttyb ttymode;
  off_t curr, limit;
  int c, fd, st;

  if ((fd = open("/dev/tty", 0)) == -1) {
	fprintf(stderr, "%s: cannot open /dev/tty\n", progname);
	return;
  }
  ioctl(fd, TIOCGETP, &ttymode);
#ifdef _MINIX
  ttymode.sg_flags |= CBREAK;
#else
  ttymode.sg_flags |= RAW;
#endif /* _MINIX */
  ttymode.sg_flags &= ~ECHO;
  ioctl(fd, TIOCSETP, &ttymode);

  fseek(boxfp, (curr = let->location), SEEK_SET);
  limit = (let->next != NIL_LET) ? let->next->location : -1L;

  st = mline = mcol = mobc = 0;
  printf("Message %d:\n", let->seqno);
  while(curr != limit && ((c = fgetc(boxfp)) != EOF) && st==0) {
	if (mobc == MOREBUF) {
		st = lwrite(fd, mobuf, mobc);
        	mobc = 0;
       	}
      	mobuf[mobc++] = (char) c;
      	++curr;
  }
  if (st == 0) lwrite(fd, mobuf, mobc);
  mobc = 0;
  fflush(stdout);

#ifdef _MINIX
  ttymode.sg_flags &= ~CBREAK;
#else
  ttymode.sg_flags &= ~RAW;
#endif /* _MINIX */
  ttymode.sg_flags |= ECHO;
  ioctl(fd, TIOCSETP, &ttymode);
  close(fd);
}


/*
 * Print the contents of letter 'let' to file 'tofp'
 */
void printlet(let, tofp)
LETTER *let;
FILE *tofp;
{
  off_t curr, limit, oldpos;
  int c;

  if (tofp==stdout && !printmode) {
	showlet(let);
	return;
  }

  oldpos = ftell(boxfp);
  fseek(boxfp, (curr = let->location), SEEK_SET);
  limit = (let->next != NIL_LET) ? let->next->location : -1L;

  if (tofp == stdout) printf("Message %d:\n", let->seqno);
  while(curr != limit && (c = fgetc(boxfp)) != EOF) {
	fputc(c, tofp);
	++curr;
  }
  fflush(tofp);
  fseek(boxfp, oldpos, SEEK_SET);
}


/*
 * Print all letters and quit.
 */
void printall()
{
  LETTER *let;

  let = firstlet;
  if (let == NIL_LET) {
	fprintf(stderr, "No mail for %s.\n", sender);
	return;
  }

  while(let != NIL_LET) {
      	printlet(let, stdout);
      	let = let->next;
  }
}
